/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.machines.GuiAdvancedGreenhouse;
import sonar.calculator.mod.common.containers.ContainerAdvancedGreenhouse;
import sonar.calculator.mod.common.tileentity.TileEntityBuildingGreenhouse;
import sonar.calculator.mod.utils.helpers.GreenhouseHelper;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.energy.EnergyMode;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.filters.IExtractFilter;
import sonar.core.handlers.inventories.handling.filters.SlotFilter;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.SonarHelper;

public class TileEntityAdvancedGreenhouse
extends TileEntityBuildingGreenhouse
implements IFlexibleGui {
    public static final SlotFilter resource_slots = new SlotFilter(null, new int[]{0, 1, 2, 3, 4, 5, 6}, new int[]{1});
    public static final SlotFilter plant_slots = new SlotFilter(null, new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16}, new int[]{0, 2, 3, 4, 5});
    public int plants;
    public int lanterns;
    public int checkTicks;
    public int growTicks;
    public int growTick;
    public int[] logStack = new int[]{0};
    public int[] glassStack = new int[]{4, 5};
    public int[] plankStack = new int[]{6};
    public int[] stairStack = new int[]{1, 2, 3};

    public TileEntityAdvancedGreenhouse() {
        super(183, 30, 42, 94);
        this.storage.setCapacity(CalculatorConfig.ADVANCED_GREENHOUSE_STORAGE);
        this.storage.setMaxTransfer(CalculatorConfig.ADVANCED_GREENHOUSE_TRANSFER_RATE);
        this.inv.setSize(17);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> resource_slots.checkFilter(SLOT, FACE) ? Boolean.valueOf(this.checkInsert(SLOT, STACK, FACE)) : null, EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> plant_slots.checkFilter(SLOT, FACE) ? Boolean.valueOf(TileEntityAdvancedGreenhouse.isSeed(STACK)) : null, EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.dischargeSlot((int)7), EnumFilterType.INTERNAL);
        this.inv.getExtractFilters().put(IExtractFilter.BLOCK_EXTRACT, EnumFilterType.EXTERNAL);
        this.energyMode = EnergyMode.RECIEVE;
        this.type = 2;
        this.maxLevel = 100000;
        this.plantTick = 10;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.discharge(7);
    }

    @Override
    public ArrayList<BlockPos> getPlantArea() {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        for (int Z = -3; Z <= 3; ++Z) {
            for (int X = -3; X <= 3; ++X) {
                coords.add(this.field_174879_c.func_177982_a(this.forward.func_82601_c() * 4 + X, 0, this.forward.func_82599_e() * 4 + Z));
            }
        }
        return coords;
    }

    @Override
    public void gasLevels() {
        int add;
        boolean day = this.field_145850_b.func_72935_r();
        if (day) {
            add = this.plants / 5 * 8 - this.lanterns * 50;
            this.addGas(-add);
        }
        if (!day) {
            add = this.plants / 5 * 2 + this.lanterns * 50;
            this.addGas(add);
        }
    }

    @Override
    public int getPlants() {
        this.plants = 0;
        for (int Z = -3; Z <= 3; ++Z) {
            for (int X = -3; X <= 3; ++X) {
                BlockPos pos = this.field_174879_c.func_177982_a(this.forward.func_82601_c() * 4 + X, 0, this.forward.func_82599_e() * 4 + Z);
                if (!(this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof IGrowable)) continue;
                ++this.plants;
            }
        }
        return this.plants;
    }

    @Override
    public int getLanterns() {
        this.lanterns = 0;
        for (int Z = -3; Z <= 3; ++Z) {
            for (int X = -3; X <= 3; ++X) {
                for (int Y = 0; Y <= 5; ++Y) {
                    BlockPos pos = this.field_174879_c.func_177982_a(this.forward.func_82601_c() * 4 + X, Y, this.forward.func_82599_e() * 4 + Z);
                    if (this.field_145850_b.func_180495_p(pos).func_177230_c() != Calculator.gas_lantern_on) continue;
                    ++this.lanterns;
                }
            }
        }
        return this.lanterns;
    }

    @Override
    public void addFarmland() {
        for (int Z = -3; Z <= 3; ++Z) {
            for (int X = -3; X <= 3; ++X) {
                IBlockState state;
                Block block;
                BlockPos pos = this.field_174879_c.func_177982_a(4 * this.forward.func_82601_c() + X, 0, 4 * this.forward.func_82599_e() + Z);
                if (X == 3 && Z == 3 || X == -3 && Z == -3 || X == 3 && Z == -3 || X == -3 && Z == 3) {
                    if (this.storage.getEnergyLevel() < (long)this.waterRF || !GreenhouseHelper.applyWater(this.field_145850_b, pos)) continue;
                    this.storage.modifyEnergyStored((long)(-this.waterRF));
                    continue;
                }
                if (this.storage.getEnergyLevel() >= (long)this.farmlandRF && GreenhouseHelper.applyFarmland(this.field_145850_b, pos)) {
                    this.storage.modifyEnergyStored((long)(-this.farmlandRF));
                }
                if ((block = (state = this.field_145850_b.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockAccess)this.field_145850_b, pos) || !GreenhouseHelper.r(this.field_145850_b, pos)) continue;
                this.field_145850_b.func_175698_g(pos);
            }
        }
    }

    @Override
    public ArrayList<TileEntityBuildingGreenhouse.BlockPlace> getStructure() {
        int s;
        int i;
        ArrayList<TileEntityBuildingGreenhouse.BlockPlace> blocks = new ArrayList<TileEntityBuildingGreenhouse.BlockPlace>();
        int hX = SonarHelper.getHorizontal((EnumFacing)this.forward).func_82601_c();
        int hZ = SonarHelper.getHorizontal((EnumFacing)this.forward).func_82599_e();
        int hoX = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d().func_82601_c();
        int hoZ = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d().func_82599_e();
        int fX = this.forward.func_82601_c();
        int fZ = this.forward.func_82599_e();
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        for (i = 1; i <= 6; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x, y + i, z, -1));
        }
        for (i = 0; i <= 3; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hX * 4, y + i, z + hZ * 4, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hoX * 4, y + i, z + hoZ * 4, -1));
        }
        for (i = 1; i <= 3; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hX * i, y - 1, z + hZ * i, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hoX * i, y - 1, z + hoZ * i, -1));
        }
        for (int j = 1; j <= 3; ++j) {
            int i2;
            if (j != 3) {
                for (i2 = 0; i2 <= 5; ++i2) {
                    blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hX * j, y + i2, z + hZ * j, -1));
                    blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hoX * j, y + i2, z + hoZ * j, -1));
                }
                continue;
            }
            for (i2 = 0; i2 <= 4; ++i2) {
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hX * j, y + i2, z + hZ * j, -1));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hoX * j, y + i2, z + hoZ * j, -1));
            }
        }
        x = this.field_174879_c.func_177958_n() + this.forward.func_82601_c() * 8;
        y = this.field_174879_c.func_177956_o();
        z = this.field_174879_c.func_177952_p() + this.forward.func_82599_e() * 8;
        for (i = 0; i <= 3; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hX * 4, y + i, z + hZ * 4, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hoX * 4, y + i, z + hoZ * 4, -1));
        }
        for (i = 0; i <= 5; ++i) {
            if (i <= 4) {
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hX * 3, y + i, z + hZ * 3, -1));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hoX * 3, y + i, z + hoZ * 3, -1));
            }
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hX * 2, y + i, z + hZ * 2, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hoX * 2, y + i, z + hoZ * 2, -1));
        }
        for (i = 0; i <= 6; ++i) {
            if (i > 2) {
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hX, y + i, z + hZ, -1));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hoX, y + i, z + hoZ, -1));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x, y + i, z, -1));
            }
            if (i <= 2) {
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hX, y + i, z + hZ, -1));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hoX, y + i, z + hoZ, -1));
            }
            if (i != 2) continue;
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x, y + i, z, -1));
        }
        for (i = 2; i <= 3; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hX * i, y - 1, z + hZ * i, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hoX * i, y - 1, z + hoZ * i, -1));
        }
        x = this.field_174879_c.func_177958_n();
        y = this.field_174879_c.func_177956_o();
        z = this.field_174879_c.func_177952_p();
        for (i = 1; i <= 7; ++i) {
            if (i == 4) continue;
            for (s = 0; s <= 2; ++s) {
                if (s == 0) {
                    blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hX * 4 + fX * i, y + s, z + hZ * 4 + fZ * i, -1));
                    blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hoX * 4 + fX * i, y + s, z + hoZ * 4 + fZ * i, -1));
                    continue;
                }
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hX * 4 + fX * i, y + s, z + hZ * 4 + fZ * i, -1));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hoX * 4 + fX * i, y + s, z + hoZ * 4 + fZ * i, -1));
            }
        }
        for (int Y = 0; Y <= 3; ++Y) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hX * 4 + fX * 4, y + Y, z + hZ * 4 + fZ * 4, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hoX * 4 + fX * 4, y + Y, z + hoZ * 4 + fZ * 4, -1));
        }
        blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hX, y + 6, z + hZ, -1));
        blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hoX, y + 6, z + hoZ, -1));
        for (i = -1; i <= 9; ++i) {
            for (s = 3; s <= 7; ++s) {
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hX * this.intValues(s, TileEntityBuildingGreenhouse.BlockType.STAIRS) + fX * i, y + s, z + hZ * this.intValues(s, TileEntityBuildingGreenhouse.BlockType.STAIRS) + fZ * i, this.type("r")));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hoX * this.intValues(s, TileEntityBuildingGreenhouse.BlockType.STAIRS) + fX * i, y + s, z + hoZ * this.intValues(s, TileEntityBuildingGreenhouse.BlockType.STAIRS) + fZ * i, this.type("l")));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + fX * i, y + 7, z + fZ * i, -1));
            }
        }
        for (i = -1; i <= 9; ++i) {
            if (i == 0) continue;
            if (i != 4 && i != 8) {
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hX * 4 + fX * i, y + 3, z + hZ * 4 + fZ * i, this.type("d")));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hoX * 4 + fX * i, y + 3, z + hoZ * 4 + fZ * i, this.type("d2")));
            }
            if (i == 8) continue;
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hX * 3 + fX * i, y + 4, z + hZ * 3 + fZ * i, this.type("d")));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hX * 2 + fX * i, y + 5, z + hZ * 2 + fZ * i, this.type("d")));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hX + fX * i, y + 6, z + hZ + fZ * i, this.type("d")));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hoX * 3 + fX * i, y + 4, z + hoZ * 3 + fZ * i, this.type("d2")));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hoX * 2 + fX * i, y + 5, z + hoZ * 2 + fZ * i, this.type("d2")));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hoX + fX * i, y + 6, z + hoZ + fZ * i, this.type("d2")));
        }
        return blocks;
    }

    @Override
    public int[] getSlotsForType(TileEntityBuildingGreenhouse.BlockType type) {
        switch (type) {
            case LOG: {
                return this.logStack;
            }
            case STAIRS: {
                return this.stairStack;
            }
            case PLANKS: {
                return this.plankStack;
            }
            case GLASS: {
                return this.glassStack;
            }
        }
        return new int[0];
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerAdvancedGreenhouse(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiAdvancedGreenhouse(player.field_71071_by, this);
    }
}

