/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.items.IStability;
import sonar.calculator.mod.client.gui.machines.GuiAnalysingChamber;
import sonar.calculator.mod.common.containers.ContainerAnalysingChamber;
import sonar.calculator.mod.common.item.misc.CircuitBoard;
import sonar.calculator.mod.common.recipes.AnalysingChamberRecipes;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.inventories.IAdditionalInventory;
import sonar.core.api.upgrades.IUpgradableTile;
import sonar.core.api.utils.BlockCoords;
import sonar.core.common.tileentity.TileEntityEnergySidedInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.ItemTransferHelper;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.upgrades.UpgradeInventory;
import sonar.core.utils.MachineSideConfig;

public class TileEntityAnalysingChamber
extends TileEntityEnergySidedInventory
implements IUpgradableTile,
IAdditionalInventory,
IFlexibleGui {
    public SyncTagType.INT stable = new SyncTagType.INT(0);
    public SyncTagType.INT analysed = new SyncTagType.INT(2);
    public final int[] itemSlots = new int[]{2, 3, 4, 5, 6, 7};
    public UpgradeInventory upgrades = new UpgradeInventory(3, 1, new Object[]{"VOID", "TRANSFER"});
    public static List<Integer> energyValues = Lists.newArrayList((Object[])new Integer[]{0, 1000, 500, 250, 10000, 5000, 100000, 100, 175, 400, 750, 800});

    public TileEntityAnalysingChamber() {
        this.sides.input = new int[]{0};
        this.sides.output = new int[]{2, 3, 4, 5, 6, 7};
        this.sides.default_extract = null;
        this.storage.setCapacity(CalculatorConfig.ANALYSING_CHAMBER_STORAGE);
        this.storage.setMaxTransfer(CalculatorConfig.ANALYSING_CHAMBER_TRANSFER_RATE);
        this.inv.setSize(8);
        this.inv.getInsertFilters().put(SlotHelper.chargeSlot((int)1), EnumFilterType.INTERNAL);
        this.energyMode = EnergyMode.SEND;
        this.syncList.addParts(new IDirtyPart[]{this.stable, this.analysed});
    }

    @Nullable
    public Boolean checkExtract(int slot, int amount, @Nullable EnumFacing face, EnumFilterType type) {
        if (type.isExternal() && slot == 0 && this.sides.getSideConfig(face).isInput()) {
            return CircuitBoard.getState(this.inv.getStackInSlot(slot)) != CircuitBoard.CircuitState.NOT_ANALYSED;
        }
        return null;
    }

    @Nullable
    public Boolean checkInsert(int slot, @Nonnull ItemStack stack, @Nullable EnumFacing face, EnumFilterType type) {
        if (slot == 0) {
            return CircuitBoard.getState(stack) == CircuitBoard.CircuitState.NOT_ANALYSED;
        }
        return slot == 1;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.upgrades.getUpgradesInstalled("TRANSFER") > 0) {
            this.transferItems();
        }
        if ((Integer)this.analysed.getObject() == 1 && ((ItemStack)this.slots().get(0)).func_190926_b()) {
            this.analysed.setObject((Object)0);
            this.stable.setObject((Object)0);
        }
        if (this.canAnalyse()) {
            this.analyse(0);
        }
        this.charge(1);
        this.stable.setObject((Object)this.stable(0));
        this.addEnergy(EnumFacing.field_82609_l);
        this.func_70296_d();
    }

    public void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        if (slot == 0) {
            this.markBlockForUpdate();
        }
    }

    public void transferItems() {
        ArrayList outputs = this.sides.getSidesWithConfig(MachineSideConfig.OUTPUT);
        for (Object side : outputs) {
            IItemHandler handler = ItemTransferHelper.getItemHandler((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a((EnumFacing)side), (EnumFacing)side);
            if (handler == null) continue;
            ItemTransferHelper.doSimpleTransfer((Iterable)Lists.newArrayList((Object[])new IItemHandler[]{this.inv.getItemHandler((EnumFacing)side)}), (Iterable)Lists.newArrayList((Object[])new IItemHandler[]{handler}), IS -> !IS.func_190926_b(), (int)4);
        }
        ArrayList inputs = this.sides.getSidesWithConfig(MachineSideConfig.INPUT);
        if (!inputs.isEmpty()) {
            for (EnumFacing side : inputs) {
                IItemHandler handler = ItemTransferHelper.getItemHandler((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(side), (EnumFacing)side);
                if (handler == null) continue;
                ItemTransferHelper.doTransferFromSlot((IItemHandler)this.inv.getItemHandler(side), (Iterable)Lists.newArrayList((Object[])new IItemHandler[]{handler}), (int)0);
            }
            ArrayList chambers = SonarHelper.getConnectedBlocks((Block)Calculator.storageChamber, (List)inputs, (World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)256);
            ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
            for (BlockCoords chamber : chambers) {
                IItemHandler handler = ItemTransferHelper.getItemHandler((World)this.field_145850_b, (BlockPos)chamber.getBlockPos(), (EnumFacing)EnumFacing.DOWN);
                if (ItemTransferHelper.isInvalidItemHandler((IItemHandler)handler)) continue;
                handlers.add(handler);
            }
            ItemTransferHelper.doSimpleTransfer((Iterable)Lists.newArrayList((Object[])new IItemHandler[]{this.inv()}), handlers, IS -> true, (int)32);
        }
    }

    private void analyse(int slot) {
        NBTTagCompound tag;
        if (((ItemStack)this.slots().get(slot)).func_77942_o() && !(tag = ((ItemStack)this.slots().get(slot)).func_77978_p()).func_74767_n("Analysed")) {
            int storedEnergy = TileEntityAnalysingChamber.itemEnergy(((ItemStack)this.slots().get(slot)).func_77978_p().func_74762_e("Energy"));
            this.storage.getInternalWrapper().receiveEnergy(storedEnergy, false);
            for (int i = 1; i < 7; ++i) {
                if (i > 2 || this.upgrades.getUpgradesInstalled("VOID") == 0) {
                    this.add(RecipeHelperV2.getItemStackFromList((List)AnalysingChamberRecipes.instance().getOutputs(null, new Object[]{i, tag.func_74762_e("Item" + i)}), (int)0), i + 1);
                }
                tag.func_82580_o("Item" + i);
            }
            tag.func_82580_o("Energy");
            tag.func_74757_a("Analysed", true);
            this.analysed.setObject((Object)1);
        }
    }

    private void add(ItemStack item, int slotID) {
        this.slots().set(slotID, new ItemStack(item.func_77973_b(), 1, item.func_77952_i()));
    }

    private boolean canAnalyse() {
        if (((ItemStack)this.slots().get(0)).func_77973_b() == Calculator.circuitBoard) {
            for (int slot : this.itemSlots) {
                if (((ItemStack)this.slots().get(slot)).func_190926_b()) continue;
                return false;
            }
            return true;
        }
        if (((ItemStack)this.slots().get(0)).func_190926_b()) {
            this.stable.setObject((Object)0);
            return false;
        }
        return false;
    }

    public static int itemEnergy(int n) {
        return n < energyValues.size() ? energyValues.get(n) : 0;
    }

    private int stable(int par) {
        ItemStack stableStack = (ItemStack)this.slots().get(par);
        if (stableStack.func_77942_o() && stableStack.func_77973_b() instanceof IStability) {
            IStability item = (IStability)stableStack.func_77973_b();
            boolean stable = item.getStability(stableStack);
            if (!stable) {
                item.onFalse(stableStack);
            }
            return stable ? 1 : 0;
        }
        return 0;
    }

    public EnergyMode getModeForSide(EnumFacing side) {
        if (side == null) {
            return EnergyMode.SEND_RECIEVE;
        }
        if (side == EnumFacing.DOWN) {
            return EnergyMode.SEND;
        }
        return EnergyMode.BLOCKED;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.upgrades.readData(nbt, type);
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.upgrades.writeData(nbt, type);
        }
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        int vUpgrades = this.upgrades.getUpgradesInstalled("VOID");
        if (vUpgrades != 0) {
            currenttip.add(FontHelper.translate((String)"circuit.void") + ": " + FontHelper.translate((String)"circuit.installed"));
        }
        return currenttip;
    }

    public ItemStack[] getAdditionalStacks() {
        ArrayList drops = this.upgrades.getDrops();
        if (drops == null || drops.isEmpty()) {
            return new ItemStack[]{ItemStack.field_190927_a};
        }
        ItemStack[] toDrop = new ItemStack[drops.size()];
        int pos = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_190926_b()) {
                toDrop[pos] = drop;
            }
            ++pos;
        }
        return toDrop;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerAnalysingChamber(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiAnalysingChamber(player.field_71071_by, this);
    }

    public UpgradeInventory getUpgradeInventory() {
        return this.upgrades;
    }
}

