/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.machines.GuiBasicGreenhouse;
import sonar.calculator.mod.common.containers.ContainerBasicGreenhouse;
import sonar.calculator.mod.common.tileentity.TileEntityBuildingGreenhouse;
import sonar.calculator.mod.utils.helpers.GreenhouseHelper;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.energy.EnergyMode;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.filters.IExtractFilter;
import sonar.core.handlers.inventories.handling.filters.SlotFilter;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.SonarHelper;

public class TileEntityBasicGreenhouse
extends TileEntityBuildingGreenhouse
implements IFlexibleGui {
    public static final SlotFilter resource_slots = new SlotFilter(null, new int[]{0, 1, 2, 3});
    public static final SlotFilter plant_slots = new SlotFilter(null, new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13});
    public int plants;
    public int lanterns;
    public int growTicks;
    public int growTick;

    public TileEntityBasicGreenhouse() {
        super(56, 18, 30, 14);
        this.storage.setCapacity(CalculatorConfig.BASIC_GREENHOUSE_STORAGE);
        this.storage.setMaxTransfer(CalculatorConfig.BASIC_GREENHOUSE_TRANSFER_RATE);
        this.inv.setSize(14);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> resource_slots.checkFilter(SLOT, FACE) ? Boolean.valueOf(this.checkInsert(SLOT, STACK, FACE)) : null, EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> plant_slots.checkFilter(SLOT, FACE) ? Boolean.valueOf(TileEntityBasicGreenhouse.isSeed(STACK)) : null, EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.dischargeSlot((int)4), EnumFilterType.INTERNAL);
        this.inv.getExtractFilters().put(IExtractFilter.BLOCK_EXTRACT, EnumFilterType.EXTERNAL);
        this.energyMode = EnergyMode.RECIEVE;
        this.type = 1;
        this.maxLevel = 100000;
        this.plantTick = 60;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.discharge(4);
    }

    @Override
    public ArrayList<BlockPos> getPlantArea() {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        int fX = this.forward.func_82601_c();
        int fZ = this.forward.func_82599_e();
        for (int Z = -1; Z <= 1; ++Z) {
            for (int X = -1; X <= 1; ++X) {
                coords.add(this.field_174879_c.func_177982_a(2 * fX + X, 0, 2 * fZ + Z));
            }
        }
        return coords;
    }

    @Override
    public void gasLevels() {
        int add;
        boolean day = this.field_145850_b.func_72935_r();
        if (day) {
            add = this.plants * 8 - this.lanterns * 50;
            this.addGas(-add);
        }
        if (!day) {
            add = this.plants * 2 + this.lanterns * 50;
            this.addGas(add);
        }
    }

    @Override
    public int getPlants() {
        this.plants = 0;
        for (int Z = -1; Z <= 1; ++Z) {
            for (int X = -1; X <= 1; ++X) {
                if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(X, 0, Z)).func_177230_c() instanceof IGrowable)) continue;
                ++this.plants;
            }
        }
        return this.plants;
    }

    @Override
    public int getLanterns() {
        this.lanterns = 0;
        for (int Z = -1; Z <= 1; ++Z) {
            for (int X = -1; X <= 1; ++X) {
                for (int Y = 0; Y <= 3; ++Y) {
                    BlockPos pos = this.field_174879_c.func_177982_a(this.forward.func_82601_c() * 2 + X, Y, this.forward.func_82599_e() * 2 + Z);
                    if (this.field_145850_b.func_180495_p(pos).func_177230_c() != Calculator.gas_lantern_on) continue;
                    ++this.lanterns;
                }
            }
        }
        return this.lanterns;
    }

    @Override
    public boolean hasRequiredStacks() {
        if (this.slots().get(0) != null && this.slots().get(1) != null && this.slots().get(2) != null && this.slots().get(3) != null && ((ItemStack)this.slots().get(0)).func_190916_E() >= this.requiredLogs && GreenhouseHelper.checkLog(Block.func_149634_a((Item)((ItemStack)this.slots().get(0)).func_77973_b())) && ((ItemStack)this.slots().get(1)).func_190916_E() >= this.requiredStairs && GreenhouseHelper.checkStairs(Block.func_149634_a((Item)((ItemStack)this.slots().get(1)).func_77973_b())) && ((ItemStack)this.slots().get(2)).func_190916_E() >= this.requiredGlass && GreenhouseHelper.checkGlass(Block.func_149634_a((Item)((ItemStack)this.slots().get(2)).func_77973_b()))) {
            return ((ItemStack)this.slots().get(3)).func_190916_E() >= this.requiredPlanks && GreenhouseHelper.checkPlanks(Block.func_149634_a((Item)((ItemStack)this.slots().get(3)).func_77973_b()));
        }
        return false;
    }

    @Override
    public void addFarmland() {
        for (int Z = -1; Z <= 1; ++Z) {
            for (int X = -1; X <= 1; ++X) {
                IBlockState state;
                Block block;
                BlockPos pos = this.field_174879_c.func_177982_a(2 * this.forward.func_82601_c() + X, 0, 2 * this.forward.func_82599_e() + Z);
                if (X == 0 && Z == 0) {
                    if (this.storage.getEnergyLevel() < (long)this.waterRF || !GreenhouseHelper.applyWater(this.field_145850_b, pos)) continue;
                    this.storage.modifyEnergyStored((long)(-this.waterRF));
                    continue;
                }
                if (this.storage.getEnergyLevel() >= (long)this.farmlandRF && GreenhouseHelper.applyFarmland(this.field_145850_b, pos)) {
                    this.storage.modifyEnergyStored((long)(-this.farmlandRF));
                }
                if ((block = (state = this.field_145850_b.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockAccess)this.field_145850_b, pos) || !GreenhouseHelper.r(this.field_145850_b, pos)) continue;
                this.field_145850_b.func_175698_g(pos);
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.planting = nbt.func_74762_e("planting");
        this.plants = nbt.func_74762_e("Plants");
        this.lanterns = nbt.func_74762_e("lanterns");
        this.levelTicks = nbt.func_74762_e("Level");
        this.plantTicks = nbt.func_74762_e("Plant");
        this.checkTicks = nbt.func_74762_e("Check");
        this.growTicks = nbt.func_74762_e("Grow");
        this.growTick = nbt.func_74762_e("GrowTick");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        nbt.func_74768_a("planting", this.planting);
        nbt.func_74768_a("Plants", this.plants);
        nbt.func_74768_a("lanterns", this.lanterns);
        nbt.func_74768_a("Level", this.levelTicks);
        nbt.func_74768_a("Check", this.checkTicks);
        nbt.func_74768_a("Plant", this.plantTicks);
        nbt.func_74768_a("Grow", this.growTicks);
        nbt.func_74768_a("GrowTick", this.growTick);
        return nbt;
    }

    @Override
    public ArrayList<TileEntityBuildingGreenhouse.BlockPlace> getStructure() {
        int s;
        int i;
        ArrayList<TileEntityBuildingGreenhouse.BlockPlace> blocks = new ArrayList<TileEntityBuildingGreenhouse.BlockPlace>();
        int hX = SonarHelper.getHorizontal((EnumFacing)this.forward).func_82601_c();
        int hZ = SonarHelper.getHorizontal((EnumFacing)this.forward).func_82599_e();
        int hoX = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d().func_82601_c();
        int hoZ = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d().func_82599_e();
        int fX = this.forward.func_82601_c();
        int fZ = this.forward.func_82599_e();
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        for (i = 1; i <= 2; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x, y + i, z, -1));
        }
        for (i = 0; i <= 2; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hX * 2, y + i, z + hZ * 2, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hoX * 2, y + i, z + hoZ * 2, -1));
        }
        for (i = 0; i <= 2; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hX, y + i, z + hZ, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hoX, y + i, z + hoZ, -1));
        }
        x = this.field_174879_c.func_177958_n() + this.forward.func_82601_c() * 4;
        y = this.field_174879_c.func_177956_o();
        z = this.field_174879_c.func_177952_p() + this.forward.func_82599_e() * 4;
        for (i = 0; i <= 2; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hX * 2, y + i, z + hZ * 2, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hoX * 2, y + i, z + hoZ * 2, -1));
        }
        for (i = 0; i <= 2; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hX, y + i, z + hZ, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hoX, y + i, z + hoZ, -1));
            if (i != 2) continue;
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x, y + i, z, -1));
        }
        x = this.field_174879_c.func_177958_n();
        y = this.field_174879_c.func_177956_o();
        z = this.field_174879_c.func_177952_p();
        for (i = 1; i <= 3; ++i) {
            if (i != 2) {
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hX * 2 + fX * i, y - 1, z + hZ * 2 + fZ * i, -1));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hoX * 2 + fX * i, y - 1, z + hoZ * 2 + fZ * i, -1));
                for (s = 0; s <= 1; ++s) {
                    blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hX * 2 + fX * i, y + s, z + hZ * 2 + fZ * i, -1));
                    blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.GLASS, x + hoX * 2 + fX * i, y + s, z + hoZ * 2 + fZ * i, -1));
                }
            }
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hX * 2 + fX * i, y + 2, z + hZ * 2 + fZ * i, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hoX * 2 + fX * i, y + 2, z + hoZ * 2 + fZ * i, -1));
        }
        for (int Y = 0; Y <= 1; ++Y) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hX * 2 + fX * 2, y + Y, z + hZ * 2 + fZ * 2, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.LOG, x + hoX * 2 + fX * 2, y + Y, z + hoZ * 2 + fZ * 2, -1));
        }
        for (i = -1; i <= 1; ++i) {
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hX * i, y + 3, z + hZ * i, -1));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + hX * i + fX * 4, y + 3, z + hZ * i + fZ * 4, -1));
        }
        for (i = -1; i <= 5; ++i) {
            for (s = 2; s <= 4; ++s) {
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hX * this.intValues(s, TileEntityBuildingGreenhouse.BlockType.STAIRS) + fX * i, y + s, z + hZ * this.intValues(s, TileEntityBuildingGreenhouse.BlockType.STAIRS) + fZ * i, this.type("r")));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hoX * this.intValues(s, TileEntityBuildingGreenhouse.BlockType.STAIRS) + fX * i, y + s, z + hoZ * this.intValues(s, TileEntityBuildingGreenhouse.BlockType.STAIRS) + fZ * i, this.type("l")));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.PLANKS, x + fX * i, y + 4, z + fZ * i, -1));
            }
        }
        for (i = -1; i <= 5; ++i) {
            if (i != -1 && i != 0 && i != 4 && i != 5) {
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hX + fX * i, y + 3, z + hZ + fZ * i, this.type("d")));
                blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hoX + fX * i, y + 3, z + hoZ + fZ * i, this.type("d2")));
                continue;
            }
            if (i == 0 || i == 4) continue;
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hX + fX * i, y + 3, z + hZ + fZ * i, this.type("d")));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hoX + fX * i, y + 3, z + hoZ + fZ * i, this.type("d2")));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hX * 2 + fX * i, y + 2, z + hZ * 2 + fZ * i, this.type("d")));
            blocks.add(new TileEntityBuildingGreenhouse.BlockPlace(TileEntityBuildingGreenhouse.BlockType.STAIRS, x + hoX * 2 + fX * i, y + 2, z + hoZ * 2 + fZ * i, this.type("d2")));
        }
        return blocks;
    }

    @Override
    public int[] getSlotsForType(TileEntityBuildingGreenhouse.BlockType type) {
        switch (type) {
            case LOG: {
                return new int[]{0};
            }
            case GLASS: {
                return new int[]{2};
            }
            case PLANKS: {
                return new int[]{3};
            }
            case STAIRS: {
                return new int[]{1};
            }
        }
        return new int[0];
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerBasicGreenhouse(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiBasicGreenhouse(player.field_71071_by, this);
    }
}

