/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.client.gui.misc.GuiFabricationChamber;
import sonar.calculator.mod.common.containers.ContainerFabricationChamber;
import sonar.calculator.mod.common.recipes.FabricationChamberRecipes;
import sonar.calculator.mod.common.tileentity.machines.TileEntityStorageChamber;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.BlockCoords;
import sonar.core.common.block.properties.SonarProperties;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.handlers.inventories.ItemStackHelper;
import sonar.core.handlers.inventories.SonarLargeInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.ItemTransferHelper;
import sonar.core.handlers.inventories.handling.filters.IInsertFilter;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeObject;

public class TileEntityFabricationChamber
extends TileEntityInventory
implements IFlexibleGui,
IByteBufTile {
    public ItemStack selected = ItemStack.field_190927_a;
    public final int fabricateTime = 200;
    public final int moveTime = 100;
    public SyncTagType.BOOLEAN canMove = new SyncTagType.BOOLEAN(0);
    public SyncTagType.BOOLEAN moved = new SyncTagType.BOOLEAN(1);
    public SyncTagType.INT currentFabricateTime = new SyncTagType.INT(2);
    public SyncTagType.INT currentMoveTime = new SyncTagType.INT(3);

    public TileEntityFabricationChamber() {
        this.syncList.addParts(new IDirtyPart[]{this.canMove, this.moved, this.currentFabricateTime, this.currentMoveTime});
        this.inv.setSize(1);
        this.inv.getInsertFilters().put(IInsertFilter.BLOCK_INSERT, EnumFilterType.EXTERNAL_INTERNAL);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (((Boolean)this.canMove.getObject()).booleanValue()) {
            if ((Integer)this.currentMoveTime.getObject() != 50 && (Integer)this.currentMoveTime.getObject() != 0) {
                if (!((Boolean)this.moved.getObject()).booleanValue()) {
                    this.currentMoveTime.increaseBy(1);
                } else {
                    this.currentMoveTime.decreaseBy(1);
                }
                if ((Integer)this.currentMoveTime.getObject() == 0) {
                    this.canMove.setObject((Object)false);
                }
            } else if ((Integer)this.currentMoveTime.getObject() == 50) {
                if ((Integer)this.currentFabricateTime.getObject() != 200) {
                    this.currentFabricateTime.increaseBy(1);
                    if (this.isClient() && ((Integer)this.currentFabricateTime.getObject() & 1) == 0 && ((Integer)this.currentFabricateTime.getObject() / 2 & 1) == 0) {
                        EnumFacing face = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)SonarProperties.FACING);
                        int fX = face.func_82601_c();
                        int n = face.func_82599_e();
                    }
                } else {
                    this.currentFabricateTime.setObject((Object)0);
                    this.currentMoveTime.decreaseBy(1);
                    this.moved.setObject((Object)true);
                    this.fabricate();
                }
            } else if ((Integer)this.currentMoveTime.getObject() == 0) {
                this.moved.setObject((Object)false);
                this.currentMoveTime.increaseBy(1);
            }
        }
    }

    public ArrayList<TileEntityStorageChamber> getChambers() {
        ArrayList<TileEntityStorageChamber> chambers = new ArrayList<TileEntityStorageChamber>();
        ArrayList connected = SonarHelper.getConnectedBlocks((Block)Calculator.storageChamber, Arrays.asList(EnumFacing.field_82609_l), (World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)256);
        for (BlockCoords chamber : connected) {
            TileEntity tile = chamber.getTileEntity(this.field_145850_b);
            if (!(tile instanceof TileEntityStorageChamber)) continue;
            chambers.add((TileEntityStorageChamber)tile);
        }
        return chambers;
    }

    public ArrayList<StoredItemStack> getAvailableCircuits(ArrayList<TileEntityStorageChamber> chambers) {
        ArrayList<StoredItemStack> circuits = new ArrayList<StoredItemStack>();
        for (TileEntityStorageChamber chamber : chambers) {
            for (SonarLargeInventory.InventoryLargeSlot slot : chamber.inv().slots) {
                StoredItemStack largeStack = slot.getLargeStack();
                if (largeStack.getItemStack().func_77973_b() != Calculator.circuitBoard) continue;
                ItemTransferHelper.addStackToList(circuits, (StoredItemStack)largeStack.copy());
            }
        }
        return circuits;
    }

    public void fabricate() {
        if (this.selected.func_190926_b() || this.isClient()) {
            return;
        }
        ItemStack selected = this.selected.func_77946_l();
        if (selected.func_190916_E() == 0) {
            selected.func_190917_f(1);
        }
        ArrayList<TileEntityStorageChamber> chambers = this.getChambers();
        ArrayList<StoredItemStack> available = this.getAvailableCircuits(chambers);
        ISonarRecipe recipe = FabricationChamberRecipes.instance().getRecipeFromOutputs(null, new Object[]{selected});
        if (recipe != null && recipe.matchingInputs(available.toArray())) {
            ItemStack current = (ItemStack)this.slots().get(0);
            boolean fabricated = false;
            if (current.func_190926_b()) {
                this.slots().set(0, selected.func_77946_l());
                fabricated = true;
            } else if (ItemStackHelper.equalStacksRegular((ItemStack)current, (ItemStack)selected) && current.func_190916_E() + selected.func_190916_E() <= this.func_70297_j_() && current.func_190916_E() + selected.func_190916_E() <= selected.func_77976_d()) {
                current.func_190917_f(selected.func_190916_E());
                fabricated = true;
            }
            if (fabricated) {
                List inputs = recipe.inputs();
                block0: for (ISonarRecipeObject input : inputs) {
                    ItemStack stack = ((ItemStack)input.getValue()).func_77946_l();
                    for (TileEntityStorageChamber chamber : chambers) {
                        IItemHandler handler = ItemTransferHelper.getItemHandler((ICapabilityProvider)chamber, (EnumFacing)EnumFacing.UP);
                        if (ItemTransferHelper.isInvalidItemHandler((IItemHandler)handler)) continue;
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            ItemStack extract = handler.extractItem(i, stack.func_190916_E(), true);
                            if (!extract.func_190926_b() && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)extract) && (stack = handler.extractItem(i, stack.func_190916_E(), false)).func_190926_b()) continue block0;
                        }
                    }
                }
                this.func_70296_d();
            }
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.selected = nbt.func_74764_b("selected") ? new ItemStack((NBTTagCompound)nbt.func_74781_a("selected")) : ItemStack.field_190927_a;
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE}) && !this.selected.func_190926_b()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.selected.func_77955_b(tag);
            nbt.func_74782_a("selected", (NBTBase)tag);
        }
        return nbt;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.selected);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.selected = ByteBufUtils.readItemStack((ByteBuf)buf);
                break;
            }
            case 1: {
                if (this.selected == null) break;
                ArrayList<TileEntityStorageChamber> chambers = this.getChambers();
                ArrayList<StoredItemStack> available = this.getAvailableCircuits(chambers);
                ISonarRecipe recipe = FabricationChamberRecipes.instance().getRecipeFromOutputs(null, new Object[]{this.selected.func_77946_l()});
                if (recipe == null || !recipe.matchingInputs(available.toArray()) || ((Boolean)this.canMove.getObject()).booleanValue()) break;
                this.canMove.setObject((Object)true);
                SonarCore.sendFullSyncAround((TileEntity)this, (int)64);
                this.func_70296_d();
            }
        }
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerFabricationChamber(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiFabricationChamber(player.field_71071_by, this);
    }
}

