/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.api.machines.ProcessType;
import sonar.calculator.mod.api.nutrition.IHealthProcessor;
import sonar.calculator.mod.api.nutrition.IHealthStore;
import sonar.calculator.mod.client.gui.machines.GuiHealthProcessor;
import sonar.calculator.mod.common.containers.ContainerHealthProcessor;
import sonar.calculator.mod.common.recipes.HealthProcessorRecipes;
import sonar.core.api.IFlexibleGui;
import sonar.core.common.tileentity.TileEntitySidedInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;

public class TileEntityHealthProcessor
extends TileEntitySidedInventory
implements IFlexibleGui,
IHealthProcessor {
    public SyncTagType.INT storedpoints = new SyncTagType.INT(0);
    public final int speed = 4;

    public TileEntityHealthProcessor() {
        this.sides.input = new int[]{0};
        this.sides.output = new int[]{1};
        this.inv.setSize(2);
        this.inv.getInsertFilters().put(SlotHelper.filterSlot((int)0, s -> this.isLoot((ItemStack)s) || s.func_77973_b() instanceof IHealthStore), EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.filterSlot((int)1, s -> s.func_77973_b() instanceof IHealthStore), EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getExtractFilters().put((SLOT, COUNT, FACE) -> SLOT != 1 || (Integer)this.storedpoints.getObject() == 0, EnumFilterType.EXTERNAL);
        this.syncList.addParts(new IDirtyPart[]{this.storedpoints});
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.loot((ItemStack)this.slots().get(0));
            this.charge((ItemStack)this.slots().get(1));
            this.func_70296_d();
        }
    }

    public void charge(ItemStack stack) {
        int max;
        IHealthStore module;
        int health;
        if (stack != null && (Integer)this.storedpoints.getObject() != 0 && stack.func_77973_b() instanceof IHealthStore && ((health = (module = (IHealthStore)stack.func_77973_b()).getHealthPoints(stack)) < (max = module.getMaxHealthPoints(stack)) || max == -1)) {
            if ((Integer)this.storedpoints.getObject() >= 4) {
                if (max == -1 || max >= health + 4) {
                    module.transferHealth(4, stack, ProcessType.ADD);
                    this.storedpoints.increaseBy(-4);
                } else {
                    module.transferHealth(max - health, stack, ProcessType.ADD);
                    this.storedpoints.increaseBy(-(max - health));
                }
            } else if ((Integer)this.storedpoints.getObject() <= 4) {
                if (max == -1 | max >= health + 4) {
                    module.transferHealth(4, stack, ProcessType.ADD);
                    this.storedpoints.setObject((Object)0);
                } else {
                    module.transferHealth(max - health, stack, ProcessType.ADD);
                    this.storedpoints.increaseBy(-(max - health));
                }
            }
        }
    }

    @Override
    public int getHealthPoints() {
        return (Integer)this.storedpoints.getObject();
    }

    private void loot(ItemStack stack) {
        if (!stack.func_190926_b()) {
            IHealthStore module;
            int health;
            int value = HealthProcessorRecipes.instance().getValue(null, new Object[]{stack});
            if (value > 0) {
                this.storedpoints.increaseBy(value);
                ((ItemStack)this.slots().get(0)).func_190918_g(1);
            }
            if (stack.func_77973_b() instanceof IHealthStore && (health = (module = (IHealthStore)stack.func_77973_b()).getHealthPoints(stack)) != 0) {
                if (health >= 4) {
                    module.transferHealth(4, stack, ProcessType.REMOVE);
                    this.storedpoints.increaseBy(4);
                }
                if (health <= 4) {
                    module.transferHealth(health, stack, ProcessType.REMOVE);
                    this.storedpoints.increaseBy(health);
                }
            }
        }
    }

    private boolean isLoot(ItemStack stack) {
        return HealthProcessorRecipes.instance().getValue(null, new Object[]{stack}) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        currenttip.add(FontHelper.translate((String)"points.health") + ": " + this.storedpoints);
        return currenttip;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerHealthProcessor(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiHealthProcessor(player.field_71071_by, this);
    }
}

