/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.api.machines.ProcessType;
import sonar.calculator.mod.api.nutrition.IHungerProcessor;
import sonar.calculator.mod.api.nutrition.IHungerStore;
import sonar.calculator.mod.client.gui.machines.GuiHungerProcessor;
import sonar.calculator.mod.common.containers.ContainerHungerProcessor;
import sonar.core.api.IFlexibleGui;
import sonar.core.common.tileentity.TileEntitySidedInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;

public class TileEntityHungerProcessor
extends TileEntitySidedInventory
implements IFlexibleGui,
IHungerProcessor {
    public SyncTagType.INT storedpoints = new SyncTagType.INT(0);
    public final int speed = 4;

    public TileEntityHungerProcessor() {
        this.sides.input = new int[]{0};
        this.sides.output = new int[]{1};
        this.inv.setSize(2);
        this.inv.getInsertFilters().put(SlotHelper.filterSlot((int)0, s -> s.func_77973_b() instanceof ItemFood || s.func_77973_b() instanceof IHungerStore), EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.filterSlot((int)1, s -> s.func_77973_b() instanceof IHungerStore), EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getExtractFilters().put((SLOT, COUNT, FACE) -> SLOT != 1 || (Integer)this.storedpoints.getObject() == 0, EnumFilterType.EXTERNAL);
        this.syncList.addParts(new IDirtyPart[]{this.storedpoints});
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.food((ItemStack)this.slots().get(0));
            this.charge((ItemStack)this.slots().get(1));
            this.func_70296_d();
        }
    }

    public void charge(ItemStack stack) {
        int max;
        IHungerStore module;
        int hunger;
        if (!stack.func_190926_b() && (Integer)this.storedpoints.getObject() != 0 && stack.func_77973_b() instanceof IHungerStore && ((hunger = (module = (IHungerStore)stack.func_77973_b()).getHungerPoints(stack)) < (max = module.getMaxHungerPoints(stack)) || max == -1)) {
            if ((Integer)this.storedpoints.getObject() >= 4) {
                if (max == -1 || max >= hunger + 4) {
                    module.transferHunger(4, stack, ProcessType.ADD);
                    this.storedpoints.increaseBy(-4);
                } else {
                    module.transferHunger(max - hunger, stack, ProcessType.ADD);
                    this.storedpoints.increaseBy(-(max - hunger));
                }
            } else if ((Integer)this.storedpoints.getObject() <= 4) {
                if (max == -1 | max >= hunger + 4) {
                    module.transferHunger(4, stack, ProcessType.ADD);
                    this.storedpoints.setObject((Object)0);
                } else {
                    module.transferHunger(max - hunger, stack, ProcessType.ADD);
                    this.storedpoints.increaseBy(-(max - hunger));
                }
            }
        }
    }

    private void food(ItemStack stack) {
        if (!stack.func_190926_b()) {
            IHungerStore module;
            int hunger;
            if (stack.func_77973_b() instanceof ItemFood) {
                ItemFood food = (ItemFood)stack.func_77973_b();
                this.storedpoints.increaseBy(food.func_150905_g(stack));
                ((ItemStack)this.slots().get(0)).func_190918_g(1);
            }
            if (stack.func_77973_b() instanceof IHungerStore && (hunger = (module = (IHungerStore)stack.func_77973_b()).getHungerPoints(stack)) != 0) {
                if (hunger >= 4) {
                    module.transferHunger(4, stack, ProcessType.REMOVE);
                    this.storedpoints.increaseBy(4);
                } else {
                    module.transferHunger(hunger, stack, ProcessType.REMOVE);
                    this.storedpoints.increaseBy(hunger);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        currenttip.add(FontHelper.translate((String)"points.hunger") + ": " + this.storedpoints);
        return currenttip;
    }

    @Override
    public int getHungerPoints() {
        return (Integer)this.storedpoints.getObject();
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerHungerProcessor(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiHungerProcessor(player.field_71071_by, this);
    }
}

