/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IFlawlessCalculator;
import sonar.calculator.mod.api.modules.IModule;
import sonar.calculator.mod.client.gui.misc.GuiModuleWorkstation;
import sonar.calculator.mod.common.containers.ContainerModuleWorkstation;
import sonar.calculator.mod.common.item.calculators.ModuleItemRegistry;
import sonar.calculator.mod.common.item.calculators.modules.EmptyModule;
import sonar.core.api.IFlexibleGui;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;

public class TileEntityModuleWorkstation
extends TileEntityInventory
implements IFlexibleGui {
    public boolean updateCalc;
    public boolean newCalc;

    public TileEntityModuleWorkstation() {
        this.inv.setSize(17);
        this.inv.slotLimit = 1;
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> 0 <= SLOT && SLOT < 16 ? Boolean.valueOf(this.isModule(STACK)) : null, EnumFilterType.INTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.filterSlot((int)16, s -> s.func_77973_b() instanceof IFlawlessCalculator), EnumFilterType.INTERNAL);
    }

    public boolean checkDrop(int slot, @Nonnull ItemStack stack) {
        return slot == 16;
    }

    public void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        if (slot != 16) {
            this.updateCalc = true;
        } else {
            ItemStack stack = this.func_70301_a(slot);
            if (stack.func_190926_b()) {
                for (int i = 0; i < 16; ++i) {
                    this.slots().set(i, ItemStack.field_190927_a);
                }
            } else {
                this.newCalc = true;
            }
        }
    }

    public void func_73660_a() {
        if (this.isClient() || !this.hasFlawlessCalculator()) {
            return;
        }
        super.func_73660_a();
        ItemStack stack = (ItemStack)this.slots().get(16);
        IFlawlessCalculator calc = (IFlawlessCalculator)stack.func_77973_b();
        if (this.newCalc) {
            ArrayList<IModule> modules = calc.getModules(stack);
            int i = 0;
            for (IModule module : modules) {
                Item item = (Item)ModuleItemRegistry.instance().getValue(module.getName());
                if (item != null) {
                    ItemStack moduleStack = new ItemStack(item, 1);
                    moduleStack.func_77982_d(calc.getModuleTag(stack, i));
                    if (!((ItemStack)this.slots().get(i)).func_190926_b()) {
                        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)((ItemStack)this.slots().get(i)));
                    }
                    this.slots().set(i, moduleStack);
                }
                ++i;
            }
            this.newCalc = false;
            this.updateCalc = false;
        } else if (this.updateCalc) {
            ArrayList modules = new ArrayList();
            for (int i = 0; i < 16; ++i) {
                EmptyModule module;
                ItemStack target = (ItemStack)this.slots().get(i);
                NBTTagCompound tag = new NBTTagCompound();
                IModule iModule = module = !target.func_190926_b() ? (IModule)Calculator.modules.getObject((String)ModuleItemRegistry.instance().getKey(target.func_77973_b())) : EmptyModule.EMPTY;
                if (module == null) {
                    module = EmptyModule.EMPTY;
                } else if (!target.func_190926_b()) {
                    tag = target.func_77978_p();
                }
                calc.addModule(stack, tag, module, i);
            }
            this.updateCalc = false;
        }
    }

    public boolean hasFlawlessCalculator() {
        return ((ItemStack)this.slots().get(16)).func_77973_b() instanceof IFlawlessCalculator;
    }

    public boolean isModule(ItemStack stack) {
        return !stack.func_190926_b() && ModuleItemRegistry.instance().getKey(stack.func_77973_b()) != null;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerModuleWorkstation(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiModuleWorkstation(player.field_71071_by, this);
    }
}

