/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IStability;
import sonar.calculator.mod.client.gui.machines.GuiStorageChamber;
import sonar.calculator.mod.common.containers.ContainerStorageChamber;
import sonar.core.api.IFlexibleGui;
import sonar.core.common.tileentity.TileEntityLargeInventory;
import sonar.core.handlers.inventories.SonarLargeInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;

public class TileEntityStorageChamber
extends TileEntityLargeInventory
implements IFlexibleGui {
    public CircuitType circuitType = CircuitType.None;

    public void func_73660_a() {
        super.func_73660_a();
    }

    public TileEntityStorageChamber() {
        super(14, 1024);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> SLOT == STACK.func_77960_j(), EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> {
            CircuitType type = TileEntityStorageChamber.getCircuitType(STACK);
            if (type != null) {
                return this.circuitType == CircuitType.None || this.circuitType == type;
            }
            return false;
        }, EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.default_external_extract_result = true;
        this.syncList.addParts(new IDirtyPart[]{this.inv});
    }

    public void onInventoryContentsChanged(int slot) {
        CircuitType type = CircuitType.None;
        for (SonarLargeInventory.InventoryLargeSlot largeSlot : this.inv.slots) {
            CircuitType slotType = TileEntityStorageChamber.getCircuitType(largeSlot.getLargeStack().getItemStack());
            if (slotType == null || slotType == CircuitType.None) continue;
            type = slotType;
            break;
        }
        this.circuitType = type;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC})) {
            this.circuitType = CircuitType.values()[nbt.func_74762_e("type")];
            if (this.circuitType == null) {
                this.circuitType = CircuitType.None;
            }
        }
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP})) {
            this.inv.readData(nbt, NBTHelper.SyncType.SAVE);
            this.circuitType = CircuitType.values()[nbt.func_74762_e("type")];
            if (this.circuitType == null) {
                this.circuitType = CircuitType.None;
            }
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC})) {
            nbt.func_74768_a("type", this.circuitType.ordinal());
        }
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP})) {
            this.inv.writeData(nbt, NBTHelper.SyncType.SAVE);
            nbt.func_74768_a("type", this.circuitType.ordinal());
        }
        return nbt;
    }

    public static CircuitType getCircuitType(ItemStack stack) {
        if (stack.func_77973_b() == Calculator.circuitBoard && stack.func_77973_b() instanceof IStability) {
            IStability stability = (IStability)stack.func_77973_b();
            if (stability.getStability(stack) && stack.func_77942_o()) {
                if (stack.func_77978_p().func_74767_n("Analysed")) {
                    return CircuitType.Stable;
                }
            } else {
                if (!stack.func_77942_o()) {
                    return CircuitType.Analysed;
                }
                if (stack.func_77978_p().func_74767_n("Analysed")) {
                    return CircuitType.Analysed;
                }
            }
        } else {
            if (stack.func_77973_b() == Calculator.circuitDamaged) {
                return CircuitType.Damaged;
            }
            if (stack.func_77973_b() == Calculator.circuitDirty) {
                return CircuitType.Dirty;
            }
        }
        return null;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerStorageChamber(player, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiStorageChamber(player, this);
    }

    public static enum CircuitType {
        Analysed,
        Stable,
        Damaged,
        Dirty,
        None;


        public boolean isProcessed() {
            return this == Analysed || this == Stable;
        }

        public boolean isStable() {
            return this == Stable;
        }
    }
}

