/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.network.packets;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.calculator.mod.api.machines.TeleportLink;
import sonar.calculator.mod.common.tileentity.misc.TileEntityTeleporter;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;

public class PacketTeleportLinks
extends PacketCoords {
    public List<TeleportLink> links;

    public PacketTeleportLinks() {
    }

    public PacketTeleportLinks(BlockPos pos, List<TeleportLink> links) {
        super(pos);
        this.links = links;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.links = new ArrayList<TeleportLink>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.links.add(i, TeleportLink.readFromBuf(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.links.size());
        for (TeleportLink link : this.links) {
            TeleportLink.writeToBuf(buf, link);
        }
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketTeleportLinks> {
        public IMessage processMessage(EntityPlayer player, MessageContext ctx, PacketTeleportLinks message, TileEntity target) {
            if (target instanceof TileEntityTeleporter) {
                TileEntityTeleporter teleporter = (TileEntityTeleporter)target;
                teleporter.links = message.links;
            }
            return null;
        }
    }
}

