/*
 * Decompiled with CFR 0.152.
 */
package sonar.core;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;
import sonar.core.SonarCore;
import sonar.core.registries.ISonarRegistryBlock;
import sonar.core.registries.ISonarRegistryItem;
import sonar.core.registries.SonarRegistryBlock;
import sonar.core.registries.SonarRegistryItem;

public class SonarRegister {
    public static <T extends Block> T addBlock(String modid, CreativeTabs tab, String name, T block) {
        block.func_149647_a(tab);
        return SonarRegister.addBlock(modid, name, block);
    }

    public static <T extends Block> T addBlock(String modid, String name, T block) {
        return SonarRegister.addBlock(modid, new SonarRegistryBlock<T>(block, name));
    }

    public static <T extends Block> T addBlock(String modid, CreativeTabs tab, ISonarRegistryBlock<T> block) {
        block.setCreativeTab(tab);
        return SonarRegister.addBlock(modid, block);
    }

    public static <T extends Block> T addBlock(String modid, ISonarRegistryBlock<T> block) {
        SonarRegister.setRegistryName(modid, block);
        return SonarCore.proxy.registerBlock(modid, block);
    }

    public static <T extends Item> T addItem(String modid, CreativeTabs tab, String name, T item) {
        item.func_77637_a(tab);
        return SonarRegister.addItem(modid, name, item);
    }

    public static <T extends Item> T addItem(String modid, String name, T item) {
        return SonarRegister.addItem(modid, new SonarRegistryItem<T>(item, name));
    }

    public static <T extends Item> T addItem(String modid, CreativeTabs tab, ISonarRegistryItem<T> item) {
        item.setCreativeTab(tab);
        return SonarRegister.addItem(modid, item);
    }

    public static <T extends Item> T addItem(String modid, ISonarRegistryItem<T> item) {
        SonarRegister.setRegistryName(modid, item);
        return SonarCore.proxy.registerItem(modid, item);
    }

    public static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String modid, String key) {
        GameRegistry.registerTileEntity(tileEntityClass, (String)key);
    }

    private static <T extends Block> void setRegistryName(String modid, ISonarRegistryBlock<T> block) {
        Block theBlock = (Block)block.getValue();
        SonarRegister.setRegistryName(modid, block.getRegistryName(), theBlock);
        block.setValue(theBlock);
    }

    private static void setRegistryName(String modid, String name, Block block) {
        block.func_149663_c(name);
        block.setRegistryName(modid, name);
    }

    private static <T extends Item> void setRegistryName(String modid, ISonarRegistryItem<T> item) {
        Item theItem = (Item)item.getValue();
        SonarRegister.setRegistryName(modid, item.getRegistryName(), theItem);
        item.setValue(theItem);
    }

    private static void setRegistryName(String modid, String name, Item item) {
        item.func_77655_b(name);
        item.setRegistryName(modid, name);
    }
}

