/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.renderers;

import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VertexData {
    private final VertexFormat format;
    private float x;
    private float y;
    private float z;
    private float u;
    private float v;
    private float r;
    private float g;
    private float b;
    private float a;
    private float n_X;
    private float n_Y;
    private float n_Z;

    public VertexData(VertexFormat format) {
        this.format = format;
    }

    public VertexData(VertexFormat format, float x, float y, float z) {
        this(format);
        this.setXYZ(x, y, z);
    }

    public VertexData(VertexFormat format, float x, float y, float z, float u, float v) {
        this(format, x, y, z);
        this.setUV(u, v);
    }

    public VertexData setXYZ(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public VertexData setUV(float u, float v) {
        this.u = u;
        this.v = v;
        return this;
    }

    public VertexData setRGB(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        return this;
    }

    public VertexData setRGBA(float r, float g, float b, float a) {
        this.a = a;
        return this.setRGB(r, g, b);
    }

    public VertexData setNormal(float x, float y, float z) {
        this.n_X = x;
        this.n_Y = y;
        this.n_Z = z;
        return this;
    }

    public void applyVertexData(UnpackedBakedQuad.Builder builder) {
        for (int index = 0; index < this.format.func_177345_h(); ++index) {
            this.applyVertexDataForType(index, this.format.func_177348_c(index).func_177375_c(), builder);
        }
    }

    private void applyVertexDataForType(int index, VertexFormatElement.EnumUsage type, UnpackedBakedQuad.Builder builder) {
        switch (type) {
            case POSITION: {
                builder.put(index, new float[]{this.x, this.y, this.z, 1.0f});
                break;
            }
            case UV: {
                builder.put(index, new float[]{this.u, this.v, 0.0f, 1.0f});
                break;
            }
            case COLOR: {
                builder.put(index, new float[]{this.r, this.g, this.b, this.a});
                break;
            }
            case NORMAL: {
                builder.put(index, new float[]{this.n_X, this.n_Y, this.n_Z, 0.0f});
                break;
            }
            case PADDING: {
                builder.put(index, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                break;
            }
            case GENERIC: {
                builder.put(index, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
            }
        }
    }
}

