/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import sonar.core.api.inventories.ISonarLargeInventory;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.handlers.inventories.SonarInventorySideWrapper;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.IInventoryWrapper;
import sonar.core.handlers.inventories.handling.filters.IExtractFilter;
import sonar.core.handlers.inventories.handling.filters.IInsertFilter;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncableListener;

public class SonarLargeInventory
implements ISonarLargeInventory {
    private NonNullList<IItemHandlerModifiable> sided_handlers = SonarInventorySideWrapper.initWrappers(this);
    private Map<IInsertFilter, EnumFilterType> insert_filters = new HashMap<IInsertFilter, EnumFilterType>();
    private Map<IExtractFilter, EnumFilterType> extract_filters = new HashMap<IExtractFilter, EnumFilterType>();
    public boolean default_external_insert_result = false;
    public boolean default_external_extract_result = false;
    public boolean default_internal_insert_result = true;
    public boolean default_internal_extract_result = true;
    public NonNullList<InventoryLargeSlot> slots;
    public long stackSize;
    protected IInventory wrapped_inv = null;
    private int[] defaultSlots = null;
    protected ISyncableListener listener;

    public SonarLargeInventory() {
        this(1, 64L);
    }

    public SonarLargeInventory(int size, long stackSize) {
        this.stackSize = stackSize;
        this.setSize(size);
    }

    @Override
    public IInventory getWrapperInventory() {
        return this.wrapped_inv == null ? (this.wrapped_inv = new IInventoryWrapper(this)) : this.wrapped_inv;
    }

    @Override
    public IItemHandlerModifiable getItemHandler(EnumFacing side) {
        return SonarInventorySideWrapper.getHandlerForSide(this.sided_handlers, side);
    }

    @Override
    public int[] getDefaultSlots() {
        if (this.defaultSlots == null) {
            this.defaultSlots = new int[this.getSlots()];
            for (int i = 0; i < this.defaultSlots.length; ++i) {
                this.defaultSlots[i] = i;
            }
        }
        return this.defaultSlots;
    }

    public void setSize(int size) {
        this.slots = NonNullList.func_191196_a();
        for (int i = 0; i < size; ++i) {
            this.slots.add((Object)new InventoryLargeSlot(this, i));
        }
    }

    public void setStackSize(int stackSize) {
        this.stackSize = stackSize;
    }

    public int getSlots() {
        return this.slots.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return ((InventoryLargeSlot)this.slots.get(slot)).getAccessStack();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.validateSlotIndex(slot);
        if (this.checkInsert(slot, stack, null, EnumFilterType.INTERNAL)) {
            return ((InventoryLargeSlot)this.slots.get(slot)).insertItem(stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        if (this.checkExtract(slot, amount, null, EnumFilterType.INTERNAL)) {
            return ((InventoryLargeSlot)this.slots.get(slot)).extractItem(amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public Map<IInsertFilter, EnumFilterType> getInsertFilters() {
        return this.insert_filters;
    }

    @Override
    public Map<IExtractFilter, EnumFilterType> getExtractFilters() {
        return this.extract_filters;
    }

    @Override
    public boolean checkInsert(int slot, @Nonnull ItemStack stack, @Nullable EnumFacing face, EnumFilterType internal) {
        boolean insert = internal.matches(EnumFilterType.INTERNAL) ? this.default_internal_insert_result : this.default_external_insert_result;
        return SlotHelper.checkInsert(slot, stack, face, internal, this, insert) && ((InventoryLargeSlot)this.slots.get(slot)).checkInsert(stack, face, internal);
    }

    @Override
    public boolean checkExtract(int slot, int count, @Nullable EnumFacing face, EnumFilterType internal) {
        boolean extract = internal.matches(EnumFilterType.INTERNAL) ? this.default_internal_extract_result : this.default_external_extract_result;
        return SlotHelper.checkExtract(slot, count, face, internal, this, extract) && ((InventoryLargeSlot)this.slots.get(slot)).checkExtract(count, face, internal);
    }

    @Override
    public boolean checkDrop(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        for (int i = 0; i < this.slots.size(); ++i) {
            InventoryLargeSlot slot = (InventoryLargeSlot)this.slots.get(i);
            if (slot.getStoredStack().func_190926_b() || !this.checkDrop(i, slot.getStoredStack())) continue;
            toDrop.addAll(slot.getDrops());
        }
        return toDrop;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        ((InventoryLargeSlot)this.slots.get(slot)).setStackInSlot(stack);
    }

    public int getSlotLimit(int slot) {
        return (int)Math.min(64L, this.stackSize);
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type.isType(NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC) && nbt.func_74764_b(this.getTagName())) {
            NBTTagList list = nbt.func_150295_c(this.getTagName(), 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                int b = compound.func_74762_e("Slot");
                if (b < 0 || b >= this.slots.size()) continue;
                ((InventoryLargeSlot)this.slots.get(b)).readData(compound, type);
            }
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type.isType(NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC)) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.slots.size(); ++i) {
                NBTTagCompound compound = new NBTTagCompound();
                ((InventoryLargeSlot)this.slots.get(i)).writeData(compound, type);
                if (compound.func_82582_d()) continue;
                compound.func_74768_a("Slot", i);
                list.func_74742_a((NBTBase)compound);
            }
            if (!list.func_82582_d()) {
                nbt.func_74782_a(this.getTagName(), (NBTBase)list);
            }
        }
        return nbt;
    }

    protected void onContentsChanged(int slot) {
        this.markChanged();
    }

    @Override
    public IDirtyPart setListener(ISyncableListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public ISyncableListener getListener() {
        return this.listener;
    }

    public void markChanged() {
        if (this.listener != null) {
            this.listener.markChanged(this);
        }
    }

    @Override
    public String getTagName() {
        return "Items";
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(this.getSyncTypes());
    }

    public NBTHelper.SyncType[] getSyncTypes() {
        return new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC};
    }

    @Override
    public long getStackSize(int slot) {
        return ((InventoryLargeSlot)this.slots.get(slot)).getActualStored();
    }

    @Override
    public StoredItemStack getStoredStack(int slot) {
        return ((InventoryLargeSlot)this.slots.get(slot)).getLargeStack();
    }

    public static class InventoryLargeSlot
    implements INBTSyncable {
        public final SonarLargeInventory inventory;
        public final int slot;
        private ItemStack stored_stack = ItemStack.field_190927_a;
        private ItemStack access_stack = ItemStack.field_190927_a;
        private long active_size = 0L;

        public InventoryLargeSlot(SonarLargeInventory inventory, int slot) {
            this.inventory = inventory;
            this.slot = slot;
        }

        private void updateState() {
            if (this.stored_stack.func_190926_b() || this.getActualStored() <= 0L) {
                this.stored_stack = ItemStack.field_190927_a;
                this.access_stack = ItemStack.field_190927_a;
                this.active_size = 0L;
            } else {
                this.active_size += (long)this.access_stack.func_190916_E();
                this.access_stack = ItemStack.field_190927_a;
                this.access_stack = this.createAccessStack();
                this.active_size -= (long)this.access_stack.func_190916_E();
            }
            this.inventory.markChanged();
        }

        private ItemStack createAccessStack() {
            long toFill = this.inventory.stackSize - this.getActualStored();
            if (toFill < (long)this.stored_stack.func_77976_d()) {
                ItemStack access = this.stored_stack.func_77946_l();
                access.func_190920_e(Math.min(this.stored_stack.func_77976_d(), this.inventory.getSlotLimit(this.slot)) - (int)toFill);
                return access;
            }
            return ItemStack.field_190927_a;
        }

        public long getActualStored() {
            return this.active_size + (long)this.access_stack.func_190916_E();
        }

        public StoredItemStack getLargeStack() {
            return new StoredItemStack(this.stored_stack, this.getActualStored());
        }

        public ItemStack getStoredStack() {
            return this.stored_stack;
        }

        public ItemStack getAccessStack() {
            return this.access_stack;
        }

        public List<ItemStack> getDrops() {
            int change;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (long drop = this.getActualStored(); drop > 0L; drop -= (long)change) {
                change = (int)Math.min((long)this.stored_stack.func_77976_d(), drop);
                ItemHandlerHelper.copyStackWithSize((ItemStack)this.stored_stack, (int)change);
            }
            return drops;
        }

        public void setStackInSlot(@Nonnull ItemStack stack) {
            if (this.stored_stack.func_190926_b() && !stack.func_190926_b()) {
                this.stored_stack = stack.func_77946_l();
            }
            this.access_stack = stack;
            this.updateState();
            this.inventory.onContentsChanged(this.slot);
        }

        @Override
        public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
            this.stored_stack = new ItemStack(nbt);
            this.active_size = nbt.func_74763_f("stored");
            this.access_stack = ItemStack.field_190927_a;
            this.updateState();
        }

        @Override
        public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
            this.stored_stack.func_77955_b(nbt);
            nbt.func_74772_a("stored", this.getActualStored());
            return nbt;
        }

        private void doExtract(int extract) {
            this.active_size -= (long)extract;
            this.updateState();
            this.inventory.onContentsChanged(this.slot);
        }

        private void doInsert(int insert) {
            this.active_size += (long)insert;
            this.updateState();
            this.inventory.onContentsChanged(this.slot);
        }

        @Nonnull
        public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b() || !this.stored_stack.func_190926_b() && !StoredItemStack.isEqualStack(stack, this.stored_stack)) {
                return stack;
            }
            int canInsert = Math.min(stack.func_190916_E(), (int)Math.min(Integer.MAX_VALUE, this.inventory.stackSize - this.getActualStored()));
            if (canInsert != 0) {
                if (!simulate) {
                    if (this.stored_stack.func_190926_b()) {
                        this.stored_stack = stack.func_77946_l();
                    }
                    this.doInsert(canInsert);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)this.stored_stack, (int)(stack.func_190916_E() - canInsert));
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int amount, boolean simulate) {
            if (this.getActualStored() <= 0L || amount <= 0 || this.stored_stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int canExtract = (int)Math.min((long)Math.min(amount, this.stored_stack.func_77976_d()), this.getActualStored());
            ItemStack extracted = ItemHandlerHelper.copyStackWithSize((ItemStack)this.stored_stack, (int)canExtract);
            if (!simulate) {
                this.doExtract(canExtract);
            }
            return extracted;
        }

        public boolean checkInsert(@Nonnull ItemStack stack, @Nullable EnumFacing face, EnumFilterType internal) {
            return this.stored_stack.func_190926_b() || StoredItemStack.isEqualStack(stack, this.stored_stack) && this.inventory.stackSize > this.getActualStored();
        }

        public boolean checkExtract(int count, @Nullable EnumFacing face, EnumFilterType internal) {
            return this.getActualStored() > 0L;
        }
    }
}

