/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories.handling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import sonar.core.handlers.inventories.handling.ITransferMethod;
import sonar.core.handlers.inventories.handling.SlotIterator;
import sonar.core.helpers.ListHelper;

public class ItemTransferHandler {
    public final List<IItemHandler> sources = new ArrayList<IItemHandler>();
    public final List<IItemHandler> destinations = new ArrayList<IItemHandler>();
    public ITransferMethod method;
    public Predicate<ItemStack> filter;

    public ItemTransferHandler setMethod(ITransferMethod method) {
        this.method = method;
        return this;
    }

    public ItemTransferHandler setFilter(Predicate<ItemStack> filter) {
        this.filter = filter;
        return this;
    }

    public void transfer() {
        this.method.transfer();
    }

    public ItemTransferHandler addSource(IItemHandler source) {
        ListHelper.addWithCheck(this.sources, source);
        this.method.onSourceAdded(source);
        return this;
    }

    public ItemTransferHandler removeSource(IItemHandler source) {
        this.sources.remove(source);
        this.method.onSourceRemoved(source);
        return this;
    }

    public ItemTransferHandler addDestination(IItemHandler destination) {
        ListHelper.addWithCheck(this.destinations, destination);
        this.method.onDestinationAdded(destination);
        return this;
    }

    public ItemTransferHandler removeDestination(IItemHandler destination) {
        this.destinations.remove(destination);
        this.method.onDestinationRemoved(destination);
        return this;
    }

    public void clear() {
        this.sources.clear();
        this.destinations.clear();
    }

    public static Iterator<Integer> getSlotIterator(IItemHandler handler) {
        return new SlotIterator(handler);
    }

    public static Iterator<IItemHandler> getItemHandlerIterator(final List<IItemHandler> handlers) {
        if (handlers.size() == 1) {
            return new Iterator<IItemHandler>(){

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public IItemHandler next() {
                    return (IItemHandler)handlers.get(0);
                }
            };
        }
        return handlers.iterator();
    }
}

