/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.planting.agricraft;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.util.MethodResult;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.SonarCore;
import sonar.core.api.asm.ASMFertiliser;
import sonar.core.api.planting.ISonarFertiliser;
import sonar.core.helpers.SonarHelper;

@ASMFertiliser(modid="agricraft", priority=0)
public class AgricraftFertiliser
implements ISonarFertiliser {
    @Override
    public boolean canFertilise(World world, BlockPos pos, IBlockState state) {
        IAgriCrop agriCrop = SonarHelper.getTile(world, pos, IAgriCrop.class);
        if (agriCrop != null) {
            Optional agriFertilizer = AgriApi.getFertilizerRegistry().valueOf((Object)new ItemStack(Items.field_151100_aR, 1, 15));
            return agriFertilizer.isPresent() && agriCrop.acceptsFertilizer((IAgriFertilizer)agriFertilizer.get());
        }
        return false;
    }

    @Override
    public boolean canGrow(World world, BlockPos pos, IBlockState state) {
        IAgriCrop agriCrop = SonarHelper.getTile(world, pos, IAgriCrop.class);
        return agriCrop != null && agriCrop.isFertile();
    }

    @Override
    public boolean grow(World world, BlockPos pos, IBlockState state) {
        IAgriCrop agriCrop = SonarHelper.getTile(world, pos, IAgriCrop.class);
        Optional agriFertilizer = AgriApi.getFertilizerRegistry().valueOf((Object)new ItemStack(Items.field_151100_aR, 1, 15));
        if (agriCrop != null && agriFertilizer.isPresent()) {
            MethodResult result = agriCrop.onApplyFertilizer((IAgriFertilizer)agriFertilizer.get(), SonarCore.rand);
            return result == MethodResult.SUCCESS;
        }
        return false;
    }
}

