/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalinnovation.gui.client;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.init.CoreProps;
import cofh.core.util.helpers.SecurityHelper;
import cofh.thermalinnovation.gui.container.ContainerMagnetFilter;
import cofh.thermalinnovation.item.ItemMagnet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class GuiMagnetFilter
extends GuiContainerCore {
    String texturePath;
    int level;
    boolean secure;
    UUID playerName;
    int filterIndex;
    private ElementButton buttonList;
    private ElementButton buttonOre;
    private ElementButton buttonMeta;
    private ElementButton buttonNbt;

    public GuiMagnetFilter(InventoryPlayer inventory, ContainerMagnetFilter container) {
        super((Container)container);
        this.level = ItemMagnet.getLevel(container.getFilterStack());
        this.secure = SecurityHelper.isSecure((ItemStack)container.getFilterStack());
        this.playerName = SecurityHelper.getID((EntityPlayer)inventory.field_70458_d);
        this.filterIndex = ItemMagnet.getLevel(container.getFilterStack());
        this.texture = CoreProps.TEXTURE_FILTER[this.filterIndex];
        this.texturePath = this.texture.toString();
        this.name = container.getInventoryName();
        this.field_146291_p = false;
        this.field_146999_f = 176;
        this.generateInfo("tab.thermalinnovation.magnet.filter");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.myInfo.isEmpty()) {
            this.addTab((TabBase)new TabInfo((GuiContainerCore)this, this.myInfo));
        }
        this.buttonList = new ElementButton((GuiContainerCore)this, 119, 20, "FilterList", 176, 0, 176, 20, 20, 20, this.texturePath);
        this.buttonOre = new ElementButton((GuiContainerCore)this, 145, 20, "FilterOre", 216, 0, 216, 20, 20, 20, this.texturePath);
        this.buttonMeta = new ElementButton((GuiContainerCore)this, 119, 46, "FilterMeta", 176, 60, 176, 80, 20, 20, this.texturePath);
        this.buttonNbt = new ElementButton((GuiContainerCore)this, 145, 46, "FilterNbt", 216, 60, 216, 80, 20, 20, this.texturePath);
        this.addElement((ElementBase)this.buttonList);
        this.addElement((ElementBase)this.buttonOre);
        this.addElement((ElementBase)this.buttonMeta);
        this.addElement((ElementBase)this.buttonNbt);
        this.updateButtons();
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        ContainerMagnetFilter container = (ContainerMagnetFilter)this.field_147002_h;
        int flag = 0;
        switch (buttonName) {
            case "FilterList": {
                flag = 0;
                break;
            }
            case "FilterOre": {
                flag = 1;
                break;
            }
            case "FilterMeta": {
                flag = 3;
                break;
            }
            case "FilterNbt": {
                flag = 2;
            }
        }
        GuiMagnetFilter.playClickSound((float)(container.getFlag(flag) ? 0.5f : 0.8f));
        container.setFlag(flag, !container.getFlag(flag));
        this.updateButtons();
    }

    private void updateButtons() {
        ContainerMagnetFilter container = (ContainerMagnetFilter)this.field_147002_h;
        int x = container.getFlag(0) ? 176 : 196;
        this.buttonList.setSheetX(x);
        this.buttonList.setHoverX(x);
        this.buttonList.setToolTip("info.cofh.filter.list." + (container.getFlag(0) ? "on" : "off"));
        x = container.getFlag(1) ? 216 : 236;
        this.buttonOre.setSheetX(x);
        this.buttonOre.setHoverX(x);
        this.buttonOre.setToolTip("info.cofh.filter.oreDict." + (container.getFlag(1) ? "on" : "off"));
        x = container.getFlag(3) ? 176 : 196;
        this.buttonMeta.setSheetX(x);
        this.buttonMeta.setHoverX(x);
        this.buttonMeta.setToolTip("info.cofh.filter.metadata." + (container.getFlag(3) ? "on" : "off"));
        x = container.getFlag(2) ? 216 : 236;
        this.buttonNbt.setSheetX(x);
        this.buttonNbt.setHoverX(x);
        this.buttonNbt.setToolTip("info.cofh.filter.nbt." + (container.getFlag(2) ? "on" : "off"));
    }
}

