/*
 * Decompiled with CFR 0.152.
 */
package nc.capability.radiation;

import nc.capability.radiation.DefaultRadiationResistanceProvider;
import nc.capability.radiation.EntityRadsProvider;
import nc.capability.radiation.IDefaultRadiationResistance;
import nc.capability.radiation.IEntityRads;
import nc.capability.radiation.IRadiationSource;
import nc.capability.radiation.RadiationSourceProvider;
import nc.config.NCConfig;
import nc.radiation.RadSources;
import nc.radiation.RadWorlds;
import nc.radiation.RadiationArmor;
import nc.util.ItemInfo;
import nc.util.OreDictHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RadiationCapabilityHandler {
    @SubscribeEvent
    public void attachEntityRadiationCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(IEntityRads.CAPABILITY_ENTITY_RADS_NAME, (ICapabilityProvider)new EntityRadsProvider(NCConfig.max_player_rads));
        } else if (event.getObject() instanceof EntityLivingBase) {
            event.addCapability(IEntityRads.CAPABILITY_ENTITY_RADS_NAME, (ICapabilityProvider)new EntityRadsProvider(50.0 * (double)((EntityLivingBase)event.getObject()).func_110143_aJ()));
        }
    }

    @SubscribeEvent
    public void attachChunkRadiationCapability(AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE_NAME, (ICapabilityProvider)new RadiationSourceProvider());
    }

    @SubscribeEvent
    public void attachWorldRadiationCapability(AttachCapabilitiesEvent<World> event) {
        int dim = ((World)event.getObject()).field_73011_w.getDimension();
        if (RadWorlds.BACKGROUND_MAP.containsKey(dim)) {
            event.addCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE_NAME, (ICapabilityProvider)new RadiationSourceProvider(RadWorlds.BACKGROUND_MAP.get(dim)));
            return;
        }
    }

    @SubscribeEvent
    public void attachStackRadiationCapability(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.func_190926_b()) {
            return;
        }
        ItemInfo itemInfo = new ItemInfo(stack);
        if (RadSources.STACK_MAP.containsKey(itemInfo)) {
            event.addCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE_NAME, (ICapabilityProvider)new RadiationSourceProvider(RadSources.STACK_MAP.get(itemInfo)));
            return;
        }
        for (String oreName : OreDictHelper.getOreNames(stack)) {
            if (!RadSources.ORE_MAP.containsKey(oreName)) continue;
            event.addCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE_NAME, (ICapabilityProvider)new RadiationSourceProvider(RadSources.ORE_MAP.get(oreName)));
            return;
        }
    }

    @SubscribeEvent
    public void attachArmorDefaultRadiationResistanceCapability(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.func_190926_b()) {
            return;
        }
        ItemInfo itemInfo = new ItemInfo(stack);
        if (RadiationArmor.ARMOR_STACK_RESISTANCE_MAP.containsKey(itemInfo)) {
            event.addCapability(IDefaultRadiationResistance.CAPABILITY_DEFAULT_RADIATION_RESISTANCE_NAME, (ICapabilityProvider)new DefaultRadiationResistanceProvider(RadiationArmor.ARMOR_STACK_RESISTANCE_MAP.get(itemInfo)));
            return;
        }
    }
}

