/*
 * Decompiled with CFR 0.152.
 */
package nc.energy;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla")})
public class Storage
implements IEnergyStorage,
ITeslaConsumer,
ITeslaProducer,
ITeslaHolder,
INBTSerializable<NBTTagCompound> {
    public long maxReceive;
    public long maxExtract;
    public long energyStored;
    public long energyCapacity;

    public Storage(int capacity) {
        this(capacity, capacity, capacity);
    }

    public Storage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public Storage(int capacity, int maxReceive, int maxExtract) {
        this.energyCapacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public long getStoredPower() {
        return this.getEnergyStored();
    }

    public long getCapacity() {
        return this.getMaxEnergyStored();
    }

    public long takePower(long power, boolean simulated) {
        long energyExtracted = Math.min(this.energyStored, Math.min(this.maxExtract, Math.min(Integer.MAX_VALUE, power)));
        if (!simulated) {
            this.energyStored -= energyExtracted;
        }
        return energyExtracted;
    }

    public long givePower(long power, boolean simulated) {
        long energyReceived = Math.min(this.energyCapacity - this.energyStored, Math.min(this.maxReceive, power));
        if (!simulated) {
            this.energyStored += energyReceived;
        }
        return energyReceived;
    }

    public int getEnergyStored() {
        return (int)Math.min(this.energyStored, Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.energyCapacity, Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public int receiveEnergy(int maxReceive, boolean simulated) {
        long energyReceived = Math.min(this.energyCapacity - this.energyStored, Math.min(this.maxReceive, (long)maxReceive));
        if (!simulated) {
            this.energyStored += energyReceived;
        }
        return (int)energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulated) {
        long energyExtracted = Math.min(this.energyStored, Math.min(this.maxExtract, (long)maxExtract));
        if (!simulated) {
            this.energyStored -= energyExtracted;
        }
        return (int)energyExtracted;
    }

    public void changeEnergyStored(int energy) {
        this.energyStored += (long)energy;
        if (this.energyStored > this.energyCapacity) {
            this.energyStored = this.energyCapacity;
        } else if (this.energyStored < 0L) {
            this.energyStored = 0L;
        }
    }

    public void setEnergyStored(int energy) {
        this.energyStored = energy;
        if (this.energyStored > this.energyCapacity) {
            this.energyStored = this.energyCapacity;
        } else if (this.energyStored < 0L) {
            this.energyStored = 0L;
        }
    }

    public void setStorageCapacity(int newCapacity) {
        if ((long)newCapacity == this.energyCapacity || newCapacity <= 0) {
            return;
        }
        this.energyCapacity = newCapacity;
        if ((long)newCapacity < this.energyStored) {
            this.setEnergyStored(newCapacity);
        }
    }

    public void setMaxTransfer(int newMaxTransfer) {
        if (newMaxTransfer < 0) {
            return;
        }
        if ((long)newMaxTransfer != this.maxReceive) {
            this.maxReceive = newMaxTransfer;
        }
        if ((long)newMaxTransfer != this.maxExtract) {
            this.maxExtract = newMaxTransfer;
        }
    }

    public void setMaxReceive(int newMaxReceive) {
        if ((long)newMaxReceive == this.maxReceive || newMaxReceive < 0) {
            return;
        }
        this.maxReceive = newMaxReceive;
    }

    public void setMaxExtract(int newMaxExtract) {
        if ((long)newMaxExtract == this.maxExtract || newMaxExtract < 0) {
            return;
        }
        this.maxReceive = newMaxExtract;
    }

    public NBTTagCompound serializeNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readAll(nbt);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energyStored < 0L) {
            this.energyStored = 0L;
        }
        nbt.func_74772_a("Energy", this.energyStored);
        return nbt;
    }

    public final NBTTagCompound writeAll(NBTTagCompound nbt) {
        NBTTagCompound energyTag = new NBTTagCompound();
        this.writeToNBT(energyTag);
        nbt.func_74782_a("energyStorage", (NBTBase)energyTag);
        return nbt;
    }

    public Storage readFromNBT(NBTTagCompound nbt) {
        this.energyStored = nbt.func_74763_f("Energy");
        if (this.energyStored > this.energyCapacity) {
            this.energyStored = this.energyCapacity;
        }
        return this;
    }

    public final void readAll(NBTTagCompound nbt) {
        if (nbt.func_74764_b("energyStorage")) {
            this.readFromNBT(nbt.func_74775_l("energyStorage"));
        }
    }
}

