/*
 * Decompiled with CFR 0.152.
 */
package nc.item.energy;

import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import javax.annotation.Nullable;
import nc.item.NCItem;
import nc.item.energy.ElectricItemManager;
import nc.item.energy.IChargableItem;
import nc.item.energy.ItemEnergyCapabilityProvider;
import nc.tile.internal.energy.EnergyConnection;
import nc.util.InfoHelper;
import nc.util.UnitHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2")})
public class ItemEnergy
extends NCItem
implements ISpecialElectricItem,
IChargableItem {
    private int capacity;
    private int maxTransfer;
    private final EnergyConnection energyConnection;
    private final int energyTier;

    public ItemEnergy(String name, int capacity, int energyTier, EnergyConnection connection, String ... tooltip) {
        this(name, capacity, capacity, energyTier, connection, tooltip);
    }

    public ItemEnergy(String name, int capacity, int maxTransfer, int energyTier, EnergyConnection connection, String ... tooltip) {
        super(name, tooltip);
        this.capacity = capacity;
        this.maxTransfer = maxTransfer;
        this.energyConnection = connection;
        this.energyTier = energyTier;
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return ElectricItemManager.getElectricItemManager(this);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        InfoHelper.infoLine(tooltip, TextFormatting.LIGHT_PURPLE, "Energy Stored: " + UnitHelper.prefix((long)this.getEnergyStored(stack), (long)this.getMaxEnergyStored(stack), 5, "RF"));
        InfoHelper.infoLine(tooltip, TextFormatting.WHITE, "EU Power Tier: " + this.getEnergyTier(stack));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("energy")) {
            return false;
        }
        return stack.func_77978_p().func_74762_e("energy") > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - MathHelper.func_151237_a((double)((double)this.getEnergyStored(stack) / (double)this.capacity), (double)0.0, (double)1.0);
    }

    @Override
    public int getEnergyStored(ItemStack stack) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("energy")) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("energy");
    }

    @Override
    public void setEnergyStored(ItemStack stack, int amount) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("energy")) {
            stack.func_77978_p().func_74768_a("energy", amount);
        }
    }

    @Override
    public int getMaxEnergyStored(ItemStack stack) {
        return this.capacity;
    }

    @Override
    public int getMaxTransfer(ItemStack stack) {
        return this.maxTransfer;
    }

    @Override
    public boolean canReceive(ItemStack stack) {
        return this.energyConnection.canReceive();
    }

    @Override
    public boolean canExtract(ItemStack stack) {
        return this.energyConnection.canExtract();
    }

    @Override
    public EnergyConnection getEnergyConnection(ItemStack stack) {
        return this.energyConnection;
    }

    @Override
    public int getEnergyTier(ItemStack stack) {
        return this.energyTier;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("energy") && nbt.func_74764_b("capacity") && nbt.func_74764_b("maxReceive") && nbt.func_74764_b("maxExtract")) {
            return new ItemEnergyCapabilityProvider(stack, nbt, this.energyTier);
        }
        return new ItemEnergyCapabilityProvider(stack, this.getEnergyStored(stack), this.capacity, this.maxTransfer, this.energyTier);
    }
}

