/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.cuboidal;

import nc.multiblock.MultiblockBase;
import nc.multiblock.cuboidal.CuboidalMultiblockTileBase;
import nc.multiblock.network.MultiblockUpdatePacket;
import nc.multiblock.validation.IMultiblockValidator;
import nc.multiblock.validation.ValidationError;
import nc.util.NCMath;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class CuboidalMultiblockBase<PACKET extends MultiblockUpdatePacket>
extends MultiblockBase<PACKET> {
    protected CuboidalMultiblockBase(World world) {
        super(world);
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            validatorCallback.setLastError(ValidationError.VALIDATION_ERROR_TOO_FEW_PARTS);
            return false;
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int minX = minimumCoord.func_177958_n();
        int minY = minimumCoord.func_177956_o();
        int minZ = minimumCoord.func_177952_p();
        int maxX = maximumCoord.func_177958_n();
        int maxY = maximumCoord.func_177956_o();
        int maxZ = maximumCoord.func_177952_p();
        int deltaX = maxX - minX + 1;
        int deltaY = maxY - minY + 1;
        int deltaZ = maxZ - minZ + 1;
        int maxXSize = this.getMaximumXSize();
        int maxYSize = this.getMaximumYSize();
        int maxZSize = this.getMaximumZSize();
        int minXSize = this.getMinimumXSize();
        int minYSize = this.getMinimumYSize();
        int minZSize = this.getMinimumZSize();
        if (maxXSize > 0 && deltaX > maxXSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_large", null, maxXSize, "X");
            return false;
        }
        if (maxYSize > 0 && deltaY > maxYSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_large", null, maxYSize, "Y");
            return false;
        }
        if (maxZSize > 0 && deltaZ > maxZSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_large", null, maxZSize, "Z");
            return false;
        }
        if (deltaX < minXSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_small", null, minXSize, "X");
            return false;
        }
        if (deltaY < minYSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_small", null, minYSize, "Y");
            return false;
        }
        if (deltaZ < minZSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_small", null, minZSize, "Z");
            return false;
        }
        Class<?> myClass = this.getClass();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    boolean isPartValid;
                    CuboidalMultiblockTileBase part;
                    TileEntity te = this.WORLD.func_175625_s(new BlockPos(x, y, z));
                    if (te instanceof CuboidalMultiblockTileBase) {
                        part = (CuboidalMultiblockTileBase)te;
                        if (!myClass.equals(part.getMultiblockType())) {
                            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.invalid_part", new BlockPos(x, y, z), x, y, z);
                            return false;
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minX) {
                        ++extremes;
                    }
                    if (y == minY) {
                        ++extremes;
                    }
                    if (z == minZ) {
                        ++extremes;
                    }
                    if (x == maxX) {
                        ++extremes;
                    }
                    if (y == maxY) {
                        ++extremes;
                    }
                    if (z == maxZ) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        boolean bl = isPartValid = part != null ? part.isGoodForFrame(validatorCallback) : this.isBlockGoodForFrame(this.WORLD, x, y, z, validatorCallback);
                        if (isPartValid) continue;
                        if (null == validatorCallback.getLastError()) {
                            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.invalid_part_for_frame", new BlockPos(x, y, z), x, y, z);
                        }
                        return false;
                    }
                    if (extremes == 1) {
                        if (y == maxY) {
                            boolean bl = isPartValid = part != null ? part.isGoodForTop(validatorCallback) : this.isBlockGoodForTop(this.WORLD, x, y, z, validatorCallback);
                            if (isPartValid) continue;
                            if (null == validatorCallback.getLastError()) {
                                validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.invalid_part_for_top", new BlockPos(x, y, z), x, y, z);
                            }
                            return false;
                        }
                        if (y == minY) {
                            boolean bl = isPartValid = part != null ? part.isGoodForBottom(validatorCallback) : this.isBlockGoodForBottom(this.WORLD, x, y, z, validatorCallback);
                            if (isPartValid) continue;
                            if (null == validatorCallback.getLastError()) {
                                validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.invalid_part_for_bottom", new BlockPos(x, y, z), x, y, z);
                            }
                            return false;
                        }
                        boolean bl = isPartValid = part != null ? part.isGoodForSides(validatorCallback) : this.isBlockGoodForSides(this.WORLD, x, y, z, validatorCallback);
                        if (isPartValid) continue;
                        if (null == validatorCallback.getLastError()) {
                            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.invalid_part_for_sides", new BlockPos(x, y, z), x, y, z);
                        }
                        return false;
                    }
                    boolean bl = isPartValid = part != null ? part.isGoodForInterior(validatorCallback) : this.isBlockGoodForInterior(this.WORLD, x, y, z, validatorCallback);
                    if (isPartValid) continue;
                    if (null == validatorCallback.getLastError()) {
                        validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.reactor.invalid_part_for_interior", new BlockPos(x, y, z), x, y, z);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    protected BlockPos getMinimumInteriorCoord() {
        return new BlockPos(this.getMinimumCoord().func_177958_n() + 1, this.getMinimumCoord().func_177956_o() + 1, this.getMinimumCoord().func_177952_p() + 1);
    }

    protected BlockPos getMaximumInteriorCoord() {
        return new BlockPos(this.getMaximumCoord().func_177958_n() - 1, this.getMaximumCoord().func_177956_o() - 1, this.getMaximumCoord().func_177952_p() - 1);
    }

    public int getMinInteriorX() {
        return this.getMinimumInteriorCoord().func_177958_n();
    }

    public int getMinInteriorY() {
        return this.getMinimumInteriorCoord().func_177956_o();
    }

    public int getMinInteriorZ() {
        return this.getMinimumInteriorCoord().func_177952_p();
    }

    public int getMaxInteriorX() {
        return this.getMaximumInteriorCoord().func_177958_n();
    }

    public int getMaxInteriorY() {
        return this.getMaximumInteriorCoord().func_177956_o();
    }

    public int getMaxInteriorZ() {
        return this.getMaximumInteriorCoord().func_177952_p();
    }

    public BlockPos getExtremeInteriorCoord(boolean maxX, boolean maxY, boolean maxZ) {
        return new BlockPos(maxX ? this.getMaxInteriorX() : this.getMinInteriorX(), maxY ? this.getMaxInteriorY() : this.getMinInteriorY(), maxZ ? this.getMaxInteriorZ() : this.getMinInteriorZ());
    }

    public int getExteriorLengthX() {
        return Math.abs(this.getMaximumCoord().func_177958_n() - this.getMinimumCoord().func_177958_n()) + 1;
    }

    public int getExteriorLengthY() {
        return Math.abs(this.getMaximumCoord().func_177956_o() - this.getMinimumCoord().func_177956_o()) + 1;
    }

    public int getExteriorLengthZ() {
        return Math.abs(this.getMaximumCoord().func_177952_p() - this.getMinimumCoord().func_177952_p()) + 1;
    }

    public int getInteriorLengthX() {
        return this.getExteriorLengthX() - 2;
    }

    public int getInteriorLengthY() {
        return this.getExteriorLengthY() - 2;
    }

    public int getInteriorLengthZ() {
        return this.getExteriorLengthZ() - 2;
    }

    public int getInteriorLength(EnumFacing dir) {
        switch (dir) {
            case DOWN: {
                return this.getInteriorLengthY();
            }
            case UP: {
                return this.getInteriorLengthY();
            }
            case NORTH: {
                return this.getInteriorLengthZ();
            }
            case SOUTH: {
                return this.getInteriorLengthZ();
            }
            case WEST: {
                return this.getInteriorLengthX();
            }
            case EAST: {
                return this.getInteriorLengthX();
            }
        }
        return this.getInteriorLengthY();
    }

    protected abstract int getMinimumInteriorLength();

    protected abstract int getMaximumInteriorLength();

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return NCMath.hollowCube(this.getMinimumInteriorLength() + 2);
    }

    @Override
    protected int getMinimumXSize() {
        return this.getMinimumInteriorLength() + 2;
    }

    @Override
    protected int getMinimumYSize() {
        return this.getMinimumInteriorLength() + 2;
    }

    @Override
    protected int getMinimumZSize() {
        return this.getMinimumInteriorLength() + 2;
    }

    @Override
    protected int getMaximumXSize() {
        return this.getMaximumInteriorLength() + 2;
    }

    @Override
    protected int getMaximumYSize() {
        return this.getMaximumInteriorLength() + 2;
    }

    @Override
    protected int getMaximumZSize() {
        return this.getMaximumInteriorLength() + 2;
    }

    public Iterable<BlockPos.MutableBlockPos> getWallMinX() {
        return BlockPos.func_177975_b((BlockPos)this.getExtremeCoord(false, false, false), (BlockPos)this.getExtremeCoord(false, true, true));
    }

    public Iterable<BlockPos.MutableBlockPos> getWallMaxX() {
        return BlockPos.func_177975_b((BlockPos)this.getExtremeCoord(true, false, false), (BlockPos)this.getExtremeCoord(true, true, true));
    }

    public Iterable<BlockPos.MutableBlockPos> getWallMinY() {
        return BlockPos.func_177975_b((BlockPos)this.getExtremeCoord(false, false, false), (BlockPos)this.getExtremeCoord(true, false, true));
    }

    public Iterable<BlockPos.MutableBlockPos> getWallMaxY() {
        return BlockPos.func_177975_b((BlockPos)this.getExtremeCoord(false, true, false), (BlockPos)this.getExtremeCoord(true, true, true));
    }

    public Iterable<BlockPos.MutableBlockPos> getWallMinZ() {
        return BlockPos.func_177975_b((BlockPos)this.getExtremeCoord(false, false, false), (BlockPos)this.getExtremeCoord(true, true, false));
    }

    public Iterable<BlockPos.MutableBlockPos> getWallMaxZ() {
        return BlockPos.func_177975_b((BlockPos)this.getExtremeCoord(false, false, true), (BlockPos)this.getExtremeCoord(true, true, true));
    }

    public Iterable<BlockPos.MutableBlockPos> getWallMin(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.getWallMinX();
            }
            case Y: {
                return this.getWallMinY();
            }
            case Z: {
                return this.getWallMinZ();
            }
        }
        return BlockPos.func_177975_b((BlockPos)this.getExtremeCoord(false, false, false), (BlockPos)this.getExtremeCoord(false, false, false));
    }

    public Iterable<BlockPos.MutableBlockPos> getWallMax(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.getWallMaxX();
            }
            case Y: {
                return this.getWallMaxY();
            }
            case Z: {
                return this.getWallMaxZ();
            }
        }
        return BlockPos.func_177975_b((BlockPos)this.getExtremeCoord(true, true, true), (BlockPos)this.getExtremeCoord(true, true, true));
    }

    public boolean isInMinWall(EnumFacing.Axis axis, BlockPos pos) {
        switch (axis) {
            case X: {
                return pos.func_177958_n() == this.getMinX();
            }
            case Y: {
                return pos.func_177956_o() == this.getMinY();
            }
            case Z: {
                return pos.func_177952_p() == this.getMinZ();
            }
        }
        return false;
    }

    public boolean isInMaxWall(EnumFacing.Axis axis, BlockPos pos) {
        switch (axis) {
            case X: {
                return pos.func_177958_n() == this.getMaxX();
            }
            case Y: {
                return pos.func_177956_o() == this.getMaxY();
            }
            case Z: {
                return pos.func_177952_p() == this.getMaxZ();
            }
        }
        return false;
    }

    public boolean isInWall(EnumFacing side, BlockPos pos) {
        switch (side) {
            case DOWN: {
                return pos.func_177956_o() == this.getMinY();
            }
            case UP: {
                return pos.func_177956_o() == this.getMaxY();
            }
            case NORTH: {
                return pos.func_177952_p() == this.getMinZ();
            }
            case SOUTH: {
                return pos.func_177952_p() == this.getMaxZ();
            }
            case WEST: {
                return pos.func_177958_n() == this.getMinX();
            }
            case EAST: {
                return pos.func_177958_n() == this.getMaxX();
            }
        }
        return false;
    }

    public BlockPos getMinimumInteriorPlaneCoord(EnumFacing side, int depth, int uCushion, int vCushion) {
        switch (side) {
            case DOWN: {
                return this.getExtremeInteriorCoord(false, false, false).func_177967_a(EnumFacing.UP, depth).func_177967_a(EnumFacing.SOUTH, uCushion).func_177967_a(EnumFacing.EAST, vCushion);
            }
            case UP: {
                return this.getExtremeInteriorCoord(false, true, false).func_177967_a(EnumFacing.DOWN, depth).func_177967_a(EnumFacing.SOUTH, uCushion).func_177967_a(EnumFacing.EAST, vCushion);
            }
            case NORTH: {
                return this.getExtremeInteriorCoord(false, false, false).func_177967_a(EnumFacing.SOUTH, depth).func_177967_a(EnumFacing.EAST, uCushion).func_177967_a(EnumFacing.UP, vCushion);
            }
            case SOUTH: {
                return this.getExtremeInteriorCoord(false, false, true).func_177967_a(EnumFacing.NORTH, depth).func_177967_a(EnumFacing.EAST, uCushion).func_177967_a(EnumFacing.UP, vCushion);
            }
            case WEST: {
                return this.getExtremeInteriorCoord(false, false, false).func_177967_a(EnumFacing.EAST, depth).func_177967_a(EnumFacing.UP, uCushion).func_177967_a(EnumFacing.SOUTH, vCushion);
            }
            case EAST: {
                return this.getExtremeInteriorCoord(true, false, false).func_177967_a(EnumFacing.WEST, depth).func_177967_a(EnumFacing.UP, uCushion).func_177967_a(EnumFacing.SOUTH, vCushion);
            }
        }
        return this.getExtremeInteriorCoord(false, false, false);
    }

    public BlockPos getMaximumInteriorPlaneCoord(EnumFacing side, int depth, int uCushion, int vCushion) {
        switch (side) {
            case DOWN: {
                return this.getExtremeInteriorCoord(true, false, true).func_177967_a(EnumFacing.UP, depth).func_177967_a(EnumFacing.NORTH, uCushion).func_177967_a(EnumFacing.WEST, vCushion);
            }
            case UP: {
                return this.getExtremeInteriorCoord(true, true, true).func_177967_a(EnumFacing.DOWN, depth).func_177967_a(EnumFacing.NORTH, uCushion).func_177967_a(EnumFacing.WEST, vCushion);
            }
            case NORTH: {
                return this.getExtremeInteriorCoord(true, true, false).func_177967_a(EnumFacing.SOUTH, depth).func_177967_a(EnumFacing.WEST, uCushion).func_177967_a(EnumFacing.DOWN, vCushion);
            }
            case SOUTH: {
                return this.getExtremeInteriorCoord(true, true, true).func_177967_a(EnumFacing.NORTH, depth).func_177967_a(EnumFacing.WEST, uCushion).func_177967_a(EnumFacing.DOWN, vCushion);
            }
            case WEST: {
                return this.getExtremeInteriorCoord(false, true, true).func_177967_a(EnumFacing.EAST, depth).func_177967_a(EnumFacing.DOWN, uCushion).func_177967_a(EnumFacing.NORTH, vCushion);
            }
            case EAST: {
                return this.getExtremeInteriorCoord(true, true, true).func_177967_a(EnumFacing.WEST, depth).func_177967_a(EnumFacing.DOWN, uCushion).func_177967_a(EnumFacing.NORTH, vCushion);
            }
        }
        return this.getExtremeInteriorCoord(true, true, true);
    }

    public Iterable<BlockPos.MutableBlockPos> getInteriorPlaneMinX(int depth, int minUCushion, int minVCushion, int maxUCushion, int maxVCushion) {
        return BlockPos.func_177975_b((BlockPos)this.getMinimumInteriorPlaneCoord(EnumFacing.WEST, depth, minUCushion, minVCushion), (BlockPos)this.getMaximumInteriorPlaneCoord(EnumFacing.WEST, depth, maxUCushion, maxVCushion));
    }

    public Iterable<BlockPos.MutableBlockPos> getInteriorPlaneMaxX(int depth, int minUCushion, int minVCushion, int maxUCushion, int maxVCushion) {
        return BlockPos.func_177975_b((BlockPos)this.getMinimumInteriorPlaneCoord(EnumFacing.EAST, depth, minUCushion, minVCushion), (BlockPos)this.getMaximumInteriorPlaneCoord(EnumFacing.EAST, depth, maxUCushion, maxVCushion));
    }

    public Iterable<BlockPos.MutableBlockPos> getInteriorPlaneMinY(int depth, int minUCushion, int minVCushion, int maxUCushion, int maxVCushion) {
        return BlockPos.func_177975_b((BlockPos)this.getMinimumInteriorPlaneCoord(EnumFacing.DOWN, depth, minUCushion, minVCushion), (BlockPos)this.getMaximumInteriorPlaneCoord(EnumFacing.DOWN, depth, maxUCushion, maxVCushion));
    }

    public Iterable<BlockPos.MutableBlockPos> getInteriorPlaneMaxY(int depth, int minUCushion, int minVCushion, int maxUCushion, int maxVCushion) {
        return BlockPos.func_177975_b((BlockPos)this.getMinimumInteriorPlaneCoord(EnumFacing.UP, depth, minUCushion, minVCushion), (BlockPos)this.getMaximumInteriorPlaneCoord(EnumFacing.UP, depth, maxUCushion, maxVCushion));
    }

    public Iterable<BlockPos.MutableBlockPos> getInteriorPlaneMinZ(int depth, int minUCushion, int minVCushion, int maxUCushion, int maxVCushion) {
        return BlockPos.func_177975_b((BlockPos)this.getMinimumInteriorPlaneCoord(EnumFacing.NORTH, depth, minUCushion, minVCushion), (BlockPos)this.getMaximumInteriorPlaneCoord(EnumFacing.NORTH, depth, maxUCushion, maxVCushion));
    }

    public Iterable<BlockPos.MutableBlockPos> getInteriorPlaneMaxZ(int depth, int minUCushion, int minVCushion, int maxUCushion, int maxVCushion) {
        return BlockPos.func_177975_b((BlockPos)this.getMinimumInteriorPlaneCoord(EnumFacing.SOUTH, depth, minUCushion, minVCushion), (BlockPos)this.getMaximumInteriorPlaneCoord(EnumFacing.SOUTH, depth, maxUCushion, maxVCushion));
    }

    public Iterable<BlockPos.MutableBlockPos> getInteriorPlane(EnumFacing side, int depth, int minUCushion, int minVCushion, int maxUCushion, int maxVCushion) {
        switch (side) {
            case DOWN: {
                return this.getInteriorPlaneMinY(depth, minUCushion, minVCushion, maxUCushion, maxVCushion);
            }
            case UP: {
                return this.getInteriorPlaneMaxY(depth, minUCushion, minVCushion, maxUCushion, maxVCushion);
            }
            case NORTH: {
                return this.getInteriorPlaneMinZ(depth, minUCushion, minVCushion, maxUCushion, maxVCushion);
            }
            case SOUTH: {
                return this.getInteriorPlaneMaxZ(depth, minUCushion, minVCushion, maxUCushion, maxVCushion);
            }
            case WEST: {
                return this.getInteriorPlaneMinX(depth, minUCushion, minVCushion, maxUCushion, maxVCushion);
            }
            case EAST: {
                return this.getInteriorPlaneMaxX(depth, minUCushion, minVCushion, maxUCushion, maxVCushion);
            }
        }
        return BlockPos.func_177975_b((BlockPos)this.getExtremeInteriorCoord(false, false, false), (BlockPos)this.getExtremeInteriorCoord(false, false, false));
    }
}

