/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.moltensalt.tile;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import nc.config.NCConfig;
import nc.multiblock.BeefyTileBase;
import nc.multiblock.IMultiblockPart;
import nc.multiblock.MultiblockControllerBase;
import nc.multiblock.cuboidal.CuboidalMultiblockControllerBase;
import nc.multiblock.fission.moltensalt.container.ContainerSaltFissionController;
import nc.multiblock.fission.moltensalt.network.SaltFissionHeatBufferUpdatePacket;
import nc.multiblock.fission.moltensalt.tile.TileSaltFissionController;
import nc.multiblock.fission.moltensalt.tile.TileSaltFissionHeater;
import nc.multiblock.fission.moltensalt.tile.TileSaltFissionVent;
import nc.multiblock.fission.moltensalt.tile.TileSaltFissionVessel;
import nc.multiblock.validation.IMultiblockValidator;
import nc.network.PacketHandler;
import nc.tile.internal.HeatBuffer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SaltFissionController
extends CuboidalMultiblockControllerBase {
    private Set<TileSaltFissionController> controllers = new HashSet<TileSaltFissionController>();
    private Set<TileSaltFissionVent> vents = new HashSet<TileSaltFissionVent>();
    private Set<TileSaltFissionVessel> vessels = new HashSet<TileSaltFissionVessel>();
    private Set<TileSaltFissionHeater> heaters = new HashSet<TileSaltFissionHeater>();
    private Set<EntityPlayer> update_players = new HashSet<EntityPlayer>();
    private TileSaltFissionController controller;
    private int redstone_signal = 0;
    private int update_count = 0;
    private int rate_multiplier;
    private int process_time;
    private int cooling;
    private int heating;
    private int cell_count;
    private int efficiency;
    private int heat_multiplier;
    private final HeatBuffer heatBuffer = new HeatBuffer(25000L);
    private static final int BASE_MAX_HEAT = 25000;

    public SaltFissionController(World world) {
        super(world);
    }

    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return (int)(Math.pow(NCConfig.salt_fission_min_size + 2, 3.0) - Math.pow(NCConfig.salt_fission_min_size, 3.0));
    }

    protected int getMaximumXSize() {
        return NCConfig.salt_fission_max_size;
    }

    protected int getMaximumZSize() {
        return NCConfig.salt_fission_max_size;
    }

    protected int getMaximumYSize() {
        return NCConfig.salt_fission_max_size;
    }

    public HeatBuffer getHeatBuffer() {
        return this.heatBuffer;
    }

    public int getRedstoneSignal() {
        return this.redstone_signal;
    }

    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.syncDataFrom(data, BeefyTileBase.SyncReason.FullSync);
    }

    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileSaltFissionController) {
            this.controllers.add((TileSaltFissionController)newPart);
        }
        if (newPart instanceof TileSaltFissionVent) {
            this.vents.add((TileSaltFissionVent)newPart);
        }
        if (newPart instanceof TileSaltFissionVessel) {
            this.vessels.add((TileSaltFissionVessel)newPart);
        }
        if (newPart instanceof TileSaltFissionHeater) {
            this.heaters.add((TileSaltFissionHeater)newPart);
        }
    }

    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof TileSaltFissionController) {
            this.controllers.remove(oldPart);
        }
        if (oldPart instanceof TileSaltFissionVent) {
            this.vents.remove(oldPart);
        }
        if (oldPart instanceof TileSaltFissionVessel) {
            this.vessels.remove(oldPart);
        }
        if (oldPart instanceof TileSaltFissionHeater) {
            this.heaters.remove(oldPart);
        }
    }

    public Set<TileSaltFissionController> getControllers() {
        return this.controllers;
    }

    public Set<TileSaltFissionVent> getVents() {
        return this.vents;
    }

    public Set<TileSaltFissionVessel> getVessels() {
        return this.vessels;
    }

    public Set<TileSaltFissionHeater> getHeaters() {
        return this.heaters;
    }

    public int getNoControllers() {
        return this.getControllers().size();
    }

    public int getNoVents() {
        return this.getVents().size();
    }

    public int getNoVessels() {
        return this.getVessels().size();
    }

    public int getNoHeaters() {
        return this.getHeaters().size();
    }

    protected void onMachineAssembled() {
        Iterator<TileSaltFissionController> iterator = this.controllers.iterator();
        while (iterator.hasNext()) {
            TileSaltFissionController contr;
            this.controller = contr = iterator.next();
        }
        this.calculate();
    }

    protected void onMachineRestored() {
        this.calculate();
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
    }

    protected boolean isBlockGoodForInterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return true;
    }

    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.controllers.size() == 0) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.salt_fission.no_controller", new Object[0]);
            return false;
        }
        if (this.controllers.size() > 1) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.salt_fission.too_many_controllers", new Object[0]);
            return false;
        }
        return super.isMachineWhole(validatorCallback);
    }

    protected void onAssimilate(MultiblockControllerBase assimilated) {
        SaltFissionController newController = (SaltFissionController)assimilated;
        this.heatBuffer.mergeHeatBuffers(newController.getHeatBuffer());
    }

    protected void onAssimilated(MultiblockControllerBase assimilator) {
    }

    protected boolean updateServer() {
        if (this.update_count % 10 == 0) {
            SaltFissionHeatBufferUpdatePacket packet = this.getHeatBufferUpdatePacket();
            for (EntityPlayer player : this.update_players) {
                PacketHandler.instance.sendTo((IMessage)packet, (EntityPlayerMP)player);
            }
            this.update_count = 0;
        }
        ++this.update_count;
        return true;
    }

    protected void updateClient() {
    }

    public void calculate() {
    }

    protected void syncDataFrom(NBTTagCompound data, BeefyTileBase.SyncReason syncReason) {
        this.heatBuffer.readFromNBT(data);
    }

    protected void syncDataTo(NBTTagCompound data, BeefyTileBase.SyncReason syncReason) {
        this.heatBuffer.writeToNBT(data);
    }

    protected void sendIndividualUpdate(EntityPlayer player) {
        if (this.WORLD.field_72995_K) {
            return;
        }
        PacketHandler.instance.sendTo((IMessage)this.getHeatBufferUpdatePacket(), (EntityPlayerMP)player);
    }

    protected SaltFissionHeatBufferUpdatePacket getHeatBufferUpdatePacket() {
        return new SaltFissionHeatBufferUpdatePacket((TileEntity)this.controller, this.heatBuffer.getHeatStored(), this.heatBuffer.getHeatCapacity());
    }

    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.update_players.add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    public void onPacket(long capacity, long stored) {
        this.getHeatBuffer().setHeatCapacity(capacity);
        this.getHeatBuffer().setHeatStored(stored);
    }

    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.update_players.remove(playerToRemove);
    }

    public Container getContainer(EntityPlayer player) {
        return new ContainerSaltFissionController(player, this.controller);
    }

    Block getBlock(int x, int y, int z) {
        return this.WORLD.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
    }

    protected boolean isBlockGoodForBottom(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        validatorCallback.setLastError("nuclearcraft.multiblock_validation.salt_fission.invalid_casing", new Object[]{x, y, z, this.getBlock(x, y, z).func_149732_F()});
        return false;
    }

    protected boolean isBlockGoodForFrame(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        validatorCallback.setLastError("nuclearcraft.multiblock_validation.salt_fission.invalid_casing", new Object[]{x, y, z, this.getBlock(x, y, z).func_149732_F()});
        return false;
    }

    protected boolean isBlockGoodForSides(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        validatorCallback.setLastError("nuclearcraft.multiblock_validation.salt_fission.invalid_casing", new Object[]{x, y, z, this.getBlock(x, y, z).func_149732_F()});
        return false;
    }

    protected boolean isBlockGoodForTop(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        validatorCallback.setLastError("nuclearcraft.multiblock_validation.salt_fission.invalid_casing", new Object[]{x, y, z, this.getBlock(x, y, z).func_149732_F()});
        return false;
    }
}

