/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.heatExchanger.block;

import nc.block.property.ISidedFluid;
import nc.multiblock.heatExchanger.HeatExchangerTubeType;
import nc.multiblock.heatExchanger.block.BlockHeatExchangerPartBase;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerTube;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.util.Lang;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHeatExchangerTube
extends BlockHeatExchangerPartBase
implements ISidedFluid {
    private static EnumFacing placementSide = null;
    private final HeatExchangerTubeType tubeType;

    public BlockHeatExchangerTube(HeatExchangerTubeType tubeType) {
        super("heat_exchanger_tube_" + tubeType.toString());
        this.tubeType = tubeType;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        switch (this.tubeType) {
            case COPPER: {
                return new TileHeatExchangerTube.Copper();
            }
            case HARD_CARBON: {
                return new TileHeatExchangerTube.HardCarbon();
            }
            case THERMOCONDUCTING: {
                return new TileHeatExchangerTube.Thermoconducting();
            }
        }
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return this.createFluidBlockState(this);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getActualFluidState(state, world, pos);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND || player == null) {
            return false;
        }
        if (player.func_184614_ca().func_190926_b() && world.func_175625_s(pos) instanceof ITileFluid) {
            TextFormatting color;
            String message;
            ITileFluid tube = (ITileFluid)world.func_175625_s(pos);
            EnumFacing side = player.func_70093_af() ? facing.func_176734_d() : facing;
            tube.toggleFluidConnection(side);
            FluidConnection connection = tube.getFluidConnection(side);
            String string = message = player.func_70093_af() ? "nc.block.fluid_toggle_opposite" : "nc.block.fluid_toggle";
            TextFormatting textFormatting = connection == FluidConnection.IN ? TextFormatting.DARK_PURPLE : (connection == FluidConnection.OUT ? TextFormatting.DARK_GREEN : (color = connection == FluidConnection.BOTH ? TextFormatting.WHITE : TextFormatting.GRAY));
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise(message) + " " + color + Lang.localise("nc.block.exchanger_tube_fluid_side." + connection.func_176610_l())));
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        placementSide = null;
        if (placer != null && placer.func_70093_af()) {
            placementSide = facing.func_176734_d();
        }
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placementSide == null) {
            return;
        }
        BlockPos from = pos.func_177972_a(placementSide);
        if (world.func_175625_s(pos) instanceof TileHeatExchangerTube && world.func_175625_s(from) instanceof TileHeatExchangerTube) {
            TileHeatExchangerTube tube = (TileHeatExchangerTube)world.func_175625_s(pos);
            TileHeatExchangerTube other = (TileHeatExchangerTube)world.func_175625_s(from);
            tube.setFluidConnections((FluidConnection[])other.getFluidConnections().clone());
            tube.markAndRefresh();
        }
    }
}

