/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.heatExchanger.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.heatExchanger.HeatExchanger;
import nc.multiblock.heatExchanger.HeatExchangerTubeType;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerPartBase;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerVent;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.IngredientSorption;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.passive.ITilePassive;
import nc.tile.processor.IFluidProcessor;
import nc.util.GasHelper;
import nc.util.RecipeHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileHeatExchangerTube
extends TileHeatExchangerPartBase
implements IFluidProcessor,
ITileFluid {
    private static final FluidConnection PRODUCT_OUT = FluidConnection.IN;
    private static final FluidConnection FLUID_OUT = FluidConnection.OUT;
    private static final FluidConnection DEFAULT = FluidConnection.BOTH;
    private static final FluidConnection DISABLED = FluidConnection.NON;
    @Nonnull
    private final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(32000, TankSorption.IN, RecipeHelper.validFluids(NCRecipes.Type.HEAT_EXCHANGER).get(0)), new Tank(64000, TankSorption.OUT, new ArrayList<String>())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(FluidConnection.NON);
    @Nonnull
    private FluidTileWrapper[] fluidSides;
    @Nonnull
    private GasTileWrapper gasWrapper;
    public final int fluidInputSize = 1;
    public final int fluidOutputSize = 1;
    public final int defaultProcessTime = 16000;
    public double baseProcessTime = 16000.0;
    private int fluidToHold;
    public double time;
    public boolean isProcessing;
    public boolean canProcessInputs;
    public double speedMultiplier = 0.0;
    private int inputTemperature = 0;
    private int outputTemperature = 0;
    private EnumFacing flowDir = null;
    public final NCRecipes.Type recipeType = NCRecipes.Type.HEAT_EXCHANGER;
    protected ProcessorRecipe recipe;
    private final double conductivity;
    protected int tubeCount;

    private TileHeatExchangerTube(HeatExchangerTubeType tubeType) {
        super(CuboidalPartPositionType.INTERIOR);
        this.fluidSides = ITileFluid.getDefaultFluidSides(this);
        this.gasWrapper = new GasTileWrapper(this);
        this.conductivity = tubeType.getConductivity();
    }

    @Override
    public void onMachineAssembled(HeatExchanger controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    public int checkPosition() {
        if (!this.isMultiblockAssembled() || !this.canProcessInputs) {
            this.speedMultiplier = 0.0;
            return 0;
        }
        int adjCount = 0;
        double speedCount = 0.0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            double mult = this.getTubeSpeedMultiplier(dir);
            speedCount += mult;
            if (!(mult > 0.0)) continue;
            ++adjCount;
        }
        this.speedMultiplier = speedCount;
        return adjCount;
    }

    private double getTubeSpeedMultiplier(EnumFacing dir) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
        if (!(tile instanceof TileHeatExchangerTube)) {
            return 0.0;
        }
        TileHeatExchangerTube tube = (TileHeatExchangerTube)tile;
        if (!tube.canProcessInputs || this.requiresContraflow(tube) && !this.isContraflow(tube)) {
            return 0.0;
        }
        if (!this.canConnectFluid(dir) || !tube.canConnectFluid(dir.func_176734_d())) {
            return this.conductivityMult() * (double)(this.isHeating() != tube.isHeating() ? tube.getAbsRecipeTempDiff() : -this.getAbsInputTempDiff(tube));
        }
        return 0.0;
    }

    private boolean isContraflow(TileHeatExchangerTube tube) {
        if (this.flowDir == null || tube.flowDir == null) {
            return !(this.flowDir == null ^ tube.flowDir == null);
        }
        return this.flowDir.func_176745_a() != tube.flowDir.func_176745_a();
    }

    private boolean requiresContraflow(TileHeatExchangerTube tube) {
        return this.inputTemperature > tube.inputTemperature ^ this.outputTemperature > tube.outputTemperature;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.isProcessing = this.isProcessing();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateTube();
    }

    public void updateTube() {
        if (!this.field_145850_b.field_72995_K) {
            this.setIsHeatExchangerOn();
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            boolean shouldUpdate = false;
            this.tickTube();
            if (this.isProcessing) {
                this.process();
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
            }
            if (this.tubeCount == 0) {
                this.pushFluid();
                this.refreshRecipe();
                this.refreshActivity();
            }
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void tickTube() {
        ++this.tubeCount;
        this.tubeCount %= NCConfig.machine_update_rate / 4;
    }

    @Override
    public void refreshRecipe() {
        if (this.recipe == null || !this.recipe.matchingInputs(new ArrayList<ItemStack>(), this.getFluidInputs())) {
            this.recipe = (ProcessorRecipe)this.getRecipeHandler().getRecipeFromInputs(new ArrayList<ItemStack>(), this.getFluidInputs());
        }
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs(false);
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs(true);
    }

    public double getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    private int getAbsRecipeTempDiff() {
        return Math.abs(this.inputTemperature - this.outputTemperature);
    }

    private int getAbsInputTempDiff(TileHeatExchangerTube tube) {
        return Math.abs(this.inputTemperature - tube.inputTemperature);
    }

    private double conductivityMult() {
        return this.isHeating() ? this.conductivity : 1.0 / this.conductivity;
    }

    private boolean isHeating() {
        return this.inputTemperature < this.outputTemperature;
    }

    public boolean setRecipeStats() {
        if (this.recipe == null) {
            this.baseProcessTime = 16000.0;
            this.inputTemperature = 0;
            this.outputTemperature = 0;
            return false;
        }
        this.baseProcessTime = this.recipe.getHeatExchangerProcessTime(16000.0);
        this.fluidToHold = this.getFluidToHold();
        this.inputTemperature = this.recipe.getHeatExchangerInputTemperature();
        this.outputTemperature = this.recipe.getHeatExchangerOutputTemperature();
        return true;
    }

    private int getFluidToHold() {
        return Math.min(8000, this.getFluidIngredients().get(0).getMaxStackSize() * NCConfig.machine_update_rate / 4);
    }

    public boolean isProcessing() {
        return this.readyToProcess() && this.isHeatExchangerOn;
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.isMultiblockAssembled();
    }

    public boolean canProcessInputs(boolean justProduced) {
        if (!this.setRecipeStats()) {
            return false;
        }
        if (!justProduced && this.time >= this.baseProcessTime) {
            return true;
        }
        return this.canProduceProducts();
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize() <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.tanks.get(j + 1).isEmpty()) continue;
            if (!this.tanks.get(j + 1).getFluid().isFluidEqual(fluidProduct.getStack())) {
                return false;
            }
            if (this.tanks.get(j + 1).getFluidAmount() + fluidProduct.getMaxStackSize() <= this.tanks.get(j + 1).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void process() {
        this.time = Math.max(0.0, this.time + this.getSpeedMultiplier());
        if (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        this.time = !this.setRecipeStats() ? 0.0 : MathHelper.func_151237_a((double)(this.time - oldProcessTime), (double)0.0, (double)this.baseProcessTime);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
    }

    public void produceProducts() {
        if (this.recipe == null) {
            return;
        }
        List<Integer> fluidInputOrder = this.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            int fluidIngredientStackSize = this.getFluidIngredients().get(fluidInputOrder.get(i)).getMaxStackSize();
            if (fluidIngredientStackSize > 0) {
                this.tanks.get(i).changeFluidAmount(-fluidIngredientStackSize);
            }
            if (this.tanks.get(i).getFluidAmount() > 0) continue;
            this.tanks.get(i).setFluidStored(null);
        }
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize() <= 0) continue;
            if (this.tanks.get(j + 1).isEmpty()) {
                this.tanks.get(j + 1).setFluidStored(fluidProduct.getNextStack());
                continue;
            }
            if (!this.tanks.get(j + 1).getFluid().isFluidEqual(fluidProduct.getStack())) continue;
            this.tanks.get(j + 1).changeFluidAmount(fluidProduct.getNextStackSize());
        }
    }

    @Override
    public ProcessorRecipeHandler getRecipeHandler() {
        return this.recipeType.getRecipeHandler();
    }

    @Override
    public ProcessorRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public List<Tank> getFluidInputs() {
        return this.tanks.subList(0, 1);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipe.fluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipe.fluidProducts();
    }

    @Override
    public List<Integer> getFluidInputOrder() {
        ArrayList<Integer> fluidInputOrder = new ArrayList<Integer>();
        List<IFluidIngredient> fluidIngredients = this.recipe.fluidIngredients();
        for (int i = 0; i < 1; ++i) {
            int position = -1;
            for (int j = 0; j < fluidIngredients.size(); ++j) {
                if (!fluidIngredients.get(j).matches((Object)this.getFluidInputs().get(i), IngredientSorption.INPUT)) continue;
                position = j;
                break;
            }
            if (position == -1) {
                return AbstractRecipeHandler.INVALID;
            }
            fluidInputOrder.add(position);
        }
        return fluidInputOrder;
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Override
    public boolean alternativeFluidToggle() {
        return true;
    }

    @Override
    public void toggleFluidConnection(@Nonnull EnumFacing side) {
        ITileFluid.super.toggleFluidConnection(side);
        this.updateFlowDir();
    }

    public void updateFlowDir() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            FluidConnection thisConnection = this.getFluidConnection(side);
            if (thisConnection == DISABLED) continue;
            TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
            if (tile instanceof TileHeatExchangerVent) {
                if (thisConnection == DEFAULT) {
                    this.flowDir = side.func_176734_d();
                    return;
                }
                if (thisConnection != PRODUCT_OUT) continue;
                this.flowDir = side;
                return;
            }
            if (!(tile instanceof TileHeatExchangerTube)) continue;
            TileHeatExchangerTube tube = (TileHeatExchangerTube)tile;
            FluidConnection tubeConnection = tube.getFluidConnection(side.func_176734_d());
            if ((thisConnection != FLUID_OUT || tubeConnection != DEFAULT) && (thisConnection != PRODUCT_OUT || tubeConnection != DEFAULT && tubeConnection != FLUID_OUT)) continue;
            this.flowDir = side;
            return;
        }
        this.flowDir = null;
    }

    @Override
    public void pushFluidToSide(@Nonnull EnumFacing side) {
        block8: {
            TileEntity tile;
            FluidConnection thisConnection;
            block5: {
                FluidConnection tubeConnection;
                TileHeatExchangerTube tube;
                block6: {
                    block7: {
                        thisConnection = this.getFluidConnection(side);
                        if (thisConnection == DISABLED) {
                            return;
                        }
                        tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
                        if (!(tile instanceof TileHeatExchangerTube)) break block5;
                        tube = (TileHeatExchangerTube)tile;
                        tubeConnection = tube.getFluidConnection(side.func_176734_d());
                        if (thisConnection != FLUID_OUT) break block6;
                        if (tubeConnection != DEFAULT) break block7;
                        this.pushInputFluid(tube);
                        this.pushProduct(tube);
                        break block8;
                    }
                    if (tubeConnection != PRODUCT_OUT) break block8;
                    this.pushInputFluid(tube);
                    break block8;
                }
                if (thisConnection != PRODUCT_OUT || tubeConnection != DEFAULT && tubeConnection != FLUID_OUT) break block8;
                this.pushProduct(tube);
                break block8;
            }
            if (thisConnection == PRODUCT_OUT) {
                IFluidHandler adjStorage;
                if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
                    return;
                }
                IFluidHandler iFluidHandler = adjStorage = tile == null ? null : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                if (adjStorage == null) {
                    return;
                }
                for (int i = 0; i < this.getTanks().size(); ++i) {
                    if (this.getTanks().get(i).getFluid() == null || !this.getTanks().get(i).canDrain()) continue;
                    this.getTanks().get(i).drainInternal(adjStorage.fill(this.getTanks().get(i).drainInternal(this.getTanks().get(i).getCapacity(), false), true), true);
                }
            }
        }
    }

    public void pushInputFluid(TileHeatExchangerTube other) {
        if (this.getTanks().get(0).getFluidAmount() > other.getTanks().get(0).getFluidAmount()) {
            this.getTanks().get(0).drainInternal(other.getTanks().get(0).fillInternal(this.getTanks().get(0).drainInternal(this.getTanks().get(0).getFluidAmount() - this.fluidToHold, false), true), true);
        }
    }

    public void pushProduct(TileHeatExchangerTube other) {
        this.getTanks().get(1).drainInternal(other.getTanks().get(1).fillInternal(this.getTanks().get(1).drainInternal(this.getTanks().get(1).getCapacity(), false), true), true);
    }

    @Override
    public boolean getTanksShared() {
        return false;
    }

    @Override
    public void setTanksShared(boolean shared) {
    }

    @Override
    public boolean getEmptyUnusableTankInputs() {
        return false;
    }

    @Override
    public void setEmptyUnusableTankInputs(boolean emptyUnusableTankInputs) {
    }

    @Override
    public boolean getVoidExcessFluidOutputs() {
        return false;
    }

    @Override
    public void setVoidExcessFluidOutputs(boolean voidExcessFluidOutputs) {
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        this.writeFluidConnections(nbt);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        nbt.func_74780_a("speedMultiplier", this.speedMultiplier);
        nbt.func_74768_a("fluidToHold", this.fluidToHold);
        nbt.func_74768_a("inputTemperature", this.inputTemperature);
        nbt.func_74768_a("outputTemperature", this.outputTemperature);
        nbt.func_74768_a("flowDir", this.flowDir == null ? -1 : this.flowDir.func_176745_a());
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.readFluidConnections(nbt);
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        this.speedMultiplier = nbt.func_74769_h("speedMultiplier");
        this.fluidToHold = nbt.func_74762_e("fluidToHold");
        this.inputTemperature = nbt.func_74762_e("inputTemperature");
        this.outputTemperature = nbt.func_74762_e("outputTemperature");
        this.flowDir = nbt.func_74762_e("flowDir") == -1 ? null : EnumFacing.field_82609_l[nbt.func_74762_e("flowDir")];
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            side = this.nonNullSide(side);
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.getFluidSide(side) != null;
            }
            if (ModCheck.mekanismLoaded() && GasHelper.isGasCapability(capability)) {
                return this.getGasWrapper() != null;
            }
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            side = this.nonNullSide(side);
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this.getFluidSide(side);
            }
            if (ModCheck.mekanismLoaded() && GasHelper.isGasCapability(capability)) {
                return (T)this.getGasWrapper();
            }
        }
        return super.getCapability(capability, side);
    }

    public static class Thermoconducting
    extends TileHeatExchangerTube {
        public Thermoconducting() {
            super(HeatExchangerTubeType.THERMOCONDUCTING);
        }
    }

    public static class HardCarbon
    extends TileHeatExchangerTube {
        public HardCarbon() {
            super(HeatExchangerTubeType.HARD_CARBON);
        }
    }

    public static class Copper
    extends TileHeatExchangerTube {
        public Copper() {
            super(HeatExchangerTubeType.COPPER);
        }
    }
}

