/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.saltFission.tile;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.saltFission.SaltFissionReactor;
import nc.multiblock.saltFission.tile.TileSaltFissionPartBase;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.util.GasHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileSaltFissionRetriever
extends TileSaltFissionPartBase
implements ITileFluid {
    @Nonnull
    private final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1296, TankSorption.OUT, null)});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(FluidConnection.OUT);
    @Nonnull
    private FluidTileWrapper[] fluidSides = ITileFluid.getDefaultFluidSides(this);
    @Nonnull
    private GasTileWrapper gasWrapper = new GasTileWrapper(this);
    protected int retrieverCount;

    public TileSaltFissionRetriever() {
        super(CuboidalPartPositionType.WALL);
    }

    @Override
    public void onMachineAssembled(SaltFissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.retrieverCount == 0) {
                this.pushFluid();
            }
            this.tickRetriever();
        }
    }

    public void tickRetriever() {
        ++this.retrieverCount;
        this.retrieverCount %= NCConfig.machine_update_rate / 2;
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Override
    public boolean getTanksShared() {
        return false;
    }

    @Override
    public void setTanksShared(boolean shared) {
    }

    @Override
    public boolean getEmptyUnusableTankInputs() {
        return false;
    }

    @Override
    public void setEmptyUnusableTankInputs(boolean emptyUnusableTankInputs) {
    }

    @Override
    public boolean getVoidExcessFluidOutputs() {
        return false;
    }

    @Override
    public void setVoidExcessFluidOutputs(boolean voidExcessFluidOutputs) {
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        this.writeFluidConnections(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.readFluidConnections(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            side = this.nonNullSide(side);
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.getFluidSide(side) != null;
            }
            if (ModCheck.mekanismLoaded() && GasHelper.isGasCapability(capability)) {
                return this.getGasWrapper() != null;
            }
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            side = this.nonNullSide(side);
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this.getFluidSide(side);
            }
            if (ModCheck.mekanismLoaded() && GasHelper.isGasCapability(capability)) {
                return (T)this.getGasWrapper();
            }
        }
        return super.getCapability(capability, side);
    }
}

