/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.util.ItemInfo;
import nc.util.RegistryHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RadSources {
    public static final List<String> ORE_BLACKLIST = new ArrayList<String>();
    public static final List<ItemStack> STACK_BLACKLIST = new ArrayList<ItemStack>();
    public static final Map<String, Double> ORE_MAP = new HashMap<String, Double>();
    public static final Map<ItemInfo, Double> STACK_MAP = new HashMap<ItemInfo, Double>();
    private static final double INGOT = 1.0;
    private static final double NUGGET = 0.1111111111111111;
    private static final double HALF = 0.5;
    private static final double THIRD = 0.5;
    private static final double SMALL = 0.25;
    private static final double GEAR = 4.0;
    private static final double BLOCK = 9.0;
    private static final double SLAB = 4.5;
    private static final List<String> MATERIAL_INGOT_NAME_LIST = Lists.newArrayList((Object[])new String[]{"ingot", "dust", "dustDirty", "clump", "shard", "crystal", "crushed", "crushedPurified", "plate", "blockSheetmetal"});
    private static final List<String> MATERIAL_NUGGET_NAME_LIST = Lists.newArrayList((Object[])new String[]{"tinyDust", "dustTiny", "nugget"});
    private static final List<String> MATERIAL_HALF_NAME_LIST = Lists.newArrayList((Object[])new String[]{"rod, slabSheetmetal"});
    private static final List<String> MATERIAL_THIRD_NAME_LIST = Lists.newArrayList((Object[])new String[]{"coin"});
    private static final List<String> MATERIAL_SMALL_NAME_LIST = Lists.newArrayList((Object[])new String[]{"smallDust", "dustSmall", "ore"});
    private static final List<String> MATERIAL_GEAR_NAME_LIST = Lists.newArrayList((Object[])new String[]{"gear"});
    private static final List<String> MATERIAL_BLOCK_NAME_LIST = Lists.newArrayList((Object[])new String[]{"block", "plateDense"});
    private static final List<String> MATERIAL_SLAB_NAME_LIST = Lists.newArrayList((Object[])new String[]{"slab"});
    private static final List<String> ISOTOPE_INGOT_NAME_LIST = Lists.newArrayList((Object[])new String[]{"ingot"});
    private static final List<String> ISOTOPE_NUGGET_NAME_LIST = Lists.newArrayList((Object[])new String[]{"nugget"});
    private static final List<String> ISOTOPE_BLOCK_NAME_LIST = Lists.newArrayList((Object[])new String[]{"block"});
    public static final double THORIUM = 1.5E-6;
    public static final double URANIUM = 3.85E-10;
    public static final double PLUTONIUM = 4.2E-5;
    public static final double THORIUM_230 = 1.35E-5;
    public static final double THORIUM_232 = 7.15E-11;
    public static final double URANIUM_233 = 6.3E-6;
    public static final double URANIUM_235 = 1.45E-9;
    public static final double URANIUM_238 = 2.25E-10;
    public static final double NEPTUNIUM_236 = 6.5E-6;
    public static final double NEPTUNIUM_237 = 4.7E-7;
    public static final double PLUTONIUM_238 = 0.0115;
    public static final double PLUTONIUM_239 = 4.15E-5;
    public static final double PLUTONIUM_241 = 0.0715;
    public static final double PLUTONIUM_242 = 2.7E-6;
    public static final double AMERICIUM_241 = 0.00235;
    public static final double AMERICIUM_242 = 0.0071;
    public static final double AMERICIUM_243 = 1.4E-4;
    public static final double CURIUM_243 = 0.0345;
    public static final double CURIUM_245 = 1.2E-4;
    public static final double CURIUM_246 = 2.15E-4;
    public static final double CURIUM_247 = 6.45E-8;
    public static final double BERKELIUM_247 = 7.25E-4;
    public static final double BERKELIUM_248 = 0.00325;
    public static final double CALIFORNIUM_249 = 0.00285;
    public static final double CALIFORNIUM_250 = 0.0765;
    public static final double CALIFORNIUM_251 = 0.00115;
    public static final double CALIFORNIUM_252 = 0.38;
    public static final double TBU = RadSources.getFuelRadiation(7.15E-11, 9, 1.35E-5, 0);
    public static final double LEU_233 = RadSources.getFuelRadiation(2.25E-10, 8, 6.3E-6, 1);
    public static final double HEU_233 = RadSources.getFuelRadiation(2.25E-10, 5, 6.3E-6, 4);
    public static final double LEU_235 = RadSources.getFuelRadiation(2.25E-10, 8, 1.45E-9, 1);
    public static final double HEU_235 = RadSources.getFuelRadiation(2.25E-10, 5, 1.45E-9, 4);
    public static final double LEN_236 = RadSources.getFuelRadiation(4.7E-7, 8, 6.5E-6, 1);
    public static final double HEN_236 = RadSources.getFuelRadiation(4.7E-7, 5, 6.5E-6, 4);
    public static final double LEP_239 = RadSources.getFuelRadiation(2.7E-6, 8, 4.15E-5, 1);
    public static final double HEP_239 = RadSources.getFuelRadiation(2.7E-6, 5, 4.15E-5, 4);
    public static final double LEP_241 = RadSources.getFuelRadiation(2.7E-6, 8, 0.0715, 1);
    public static final double HEP_241 = RadSources.getFuelRadiation(2.7E-6, 5, 0.0715, 4);
    public static final double MOX_239 = RadSources.getFuelRadiation(2.25E-10, 8, 4.15E-5, 1);
    public static final double MOX_241 = RadSources.getFuelRadiation(2.25E-10, 8, 0.0715, 1);
    public static final double LEA_242 = RadSources.getFuelRadiation(1.4E-4, 8, 0.0071, 1);
    public static final double HEA_242 = RadSources.getFuelRadiation(1.4E-4, 5, 0.0071, 4);
    public static final double LECm_243 = RadSources.getFuelRadiation(2.15E-4, 8, 0.0345, 1);
    public static final double HECm_243 = RadSources.getFuelRadiation(2.15E-4, 5, 0.0345, 4);
    public static final double LECm_245 = RadSources.getFuelRadiation(2.15E-4, 8, 1.2E-4, 1);
    public static final double HECm_245 = RadSources.getFuelRadiation(2.15E-4, 5, 1.2E-4, 4);
    public static final double LECm_247 = RadSources.getFuelRadiation(2.15E-4, 8, 6.45E-8, 1);
    public static final double HECm_247 = RadSources.getFuelRadiation(2.15E-4, 5, 6.45E-8, 4);
    public static final double LEB_248 = RadSources.getFuelRadiation(7.25E-4, 8, 0.00325, 1);
    public static final double HEB_248 = RadSources.getFuelRadiation(7.25E-4, 5, 0.00325, 4);
    public static final double LECf_249 = RadSources.getFuelRadiation(0.38, 8, 0.00285, 1);
    public static final double HECf_249 = RadSources.getFuelRadiation(0.38, 5, 0.00285, 4);
    public static final double LECf_251 = RadSources.getFuelRadiation(0.38, 8, 0.00115, 1);
    public static final double HECf_251 = RadSources.getFuelRadiation(0.38, 5, 0.00115, 4);

    private static void addToOreMap(String ore, Double radiation) {
        if (ORE_BLACKLIST.contains(ore)) {
            return;
        }
        ORE_MAP.put(ore, radiation);
    }

    private static void addToStackMap(ItemStack stack, Double radiation) {
        for (ItemStack blacklisted : STACK_BLACKLIST) {
            if (!stack.func_77969_a(blacklisted)) continue;
            return;
        }
        STACK_MAP.put(new ItemInfo(stack), radiation);
    }

    public static void init() {
        ItemStack stack;
        for (String oreInfo : NCConfig.radiation_ores_blacklist) {
            ORE_BLACKLIST.add(oreInfo);
        }
        for (String itemInfo : NCConfig.radiation_items_blacklist) {
            stack = RegistryHelper.itemStackFromRegistry(itemInfo);
            if (stack == null) continue;
            STACK_BLACKLIST.add(stack);
        }
        for (String blockInfo : NCConfig.radiation_blocks_blacklist) {
            stack = RegistryHelper.blockStackFromRegistry(blockInfo);
            if (stack == null) continue;
            STACK_BLACKLIST.add(stack);
        }
    }

    public static void init2() {
        RadSources.putMaterial(1.5E-6, "Thorium");
        RadSources.putMaterial(3.85E-10, "Uranium", "Yellorium");
        RadSources.putMaterial(4.2E-5, "Plutonium", "Blutonium");
        RadSources.putIsotope(1.35E-5, "Thorium230");
        RadSources.putIsotope(7.15E-11, "Thorium232");
        RadSources.putIsotope(6.3E-6, "Uranium233");
        RadSources.putMaterial(1.45E-9, "Uranium235");
        RadSources.putMaterial(2.25E-10, "Uranium238", "Cyanite");
        RadSources.putIsotope(6.5E-6, "Neptunium236");
        RadSources.putIsotope(4.7E-7, "Neptunium237");
        RadSources.putIsotope(0.0115, "Plutonium238");
        RadSources.putIsotope(4.15E-5, "Plutonium239");
        RadSources.putIsotope(0.0715, "Plutonium241");
        RadSources.putIsotope(2.7E-6, "Plutonium242");
        RadSources.putIsotope(0.00235, "Americium241");
        RadSources.putIsotope(0.0071, "Americium242");
        RadSources.putIsotope(1.4E-4, "Americium243");
        RadSources.putIsotope(0.0345, "Curium243");
        RadSources.putIsotope(1.2E-4, "Curium245");
        RadSources.putIsotope(2.15E-4, "Curium246");
        RadSources.putIsotope(6.45E-8, "Curium247");
        RadSources.putIsotope(7.25E-4, "Berkelium247");
        RadSources.putIsotope(0.00325, "Berkelium248");
        RadSources.putIsotope(0.00285, "Californium249");
        RadSources.putIsotope(0.0765, "Californium250");
        RadSources.putIsotope(0.00115, "Californium251");
        RadSources.putIsotope(0.38, "Californium252");
        RadSources.putFuel(7.15E-11, 9, 1.35E-5, 0, "TBU");
        RadSources.putFuel(2.25E-10, 6.3E-6, "U233");
        RadSources.putFuel(2.25E-10, 1.45E-9, "U235");
        RadSources.putFuel(4.7E-7, 6.5E-6, "N236");
        RadSources.putFuel(2.7E-6, 4.15E-5, "P239");
        RadSources.putFuel(2.7E-6, 0.0715, "P241");
        RadSources.putFuel(2.25E-10, 8, 4.15E-5, 1, "MOX239");
        RadSources.putFuel(2.25E-10, 8, 0.0715, 1, "MOX241");
        RadSources.putFuel(1.4E-4, 0.0071, "A242");
        RadSources.putFuel(2.15E-4, 0.0345, "Cm243");
        RadSources.putFuel(2.15E-4, 1.2E-4, "Cm245");
        RadSources.putFuel(2.15E-4, 6.45E-8, "Cm247");
        RadSources.putFuel(7.25E-4, 0.00325, "B248");
        RadSources.putFuel(0.38, 0.00285, "Cf249");
        RadSources.putFuel(0.38, 0.00115, "Cf251");
        RadSources.putDepletedFuel(6.3E-6, 16, 1.45E-9, 8, 6.5E-6, 8, 4.7E-7, 32, "TBU");
        RadSources.putDepletedFuel(2.25E-10, 40, 4.7E-7, 8, 4.15E-5, 8, 0.0715, 8, "LEU235");
        RadSources.putDepletedFuel(2.25E-10, 20, 4.7E-7, 16, 4.15E-5, 4, 2.7E-6, 24, "HEU235");
        RadSources.putDepletedFuel(4.15E-5, 4, 0.0715, 4, 2.7E-6, 32, 1.4E-4, 24, "LEU233");
        RadSources.putDepletedFuel(6.5E-6, 32, 4.7E-7, 8, 2.7E-6, 16, 1.4E-4, 8, "HEU233");
        RadSources.putDepletedFuel(4.7E-7, 4, 2.7E-6, 32, 0.0071, 8, 1.4E-4, 20, "LEN236");
        RadSources.putDepletedFuel(2.25E-10, 16, 0.0115, 8, 4.15E-5, 8, 2.7E-6, 32, "HEN236");
        RadSources.putDepletedFuel(2.25E-10, 40, 2.7E-6, 12, 1.4E-4, 8, 0.0345, 4, "MOX239");
        RadSources.putDepletedFuel(4.15E-5, 8, 2.7E-6, 24, 0.0345, 4, 2.15E-4, 28, "LEP239");
        RadSources.putDepletedFuel(0.00235, 8, 0.0071, 24, 1.2E-4, 8, 2.15E-4, 24, "HEP239");
        RadSources.putDepletedFuel(2.7E-6, 4, 0.0071, 4, 1.4E-4, 8, 2.15E-4, 48, "LEP241");
        RadSources.putDepletedFuel(0.00235, 8, 1.2E-4, 8, 2.15E-4, 24, 6.45E-8, 24, "HEP241");
        RadSources.putDepletedFuel(2.25E-10, 40, 0.0715, 8, 2.7E-6, 8, 2.15E-4, 8, "MOX241");
        RadSources.putDepletedFuel(0.0345, 8, 1.2E-4, 8, 2.15E-4, 40, 6.45E-8, 8, "LEA242");
        RadSources.putDepletedFuel(1.2E-4, 16, 2.15E-4, 32, 6.45E-8, 8, 7.25E-4, 8, "HEA242");
        RadSources.putDepletedFuel(2.15E-4, 32, 7.25E-4, 16, 0.00325, 8, 0.00285, 8, "LECm243");
        RadSources.putDepletedFuel(2.15E-4, 24, 7.25E-4, 24, 0.00325, 8, 0.00285, 8, "HECm243");
        RadSources.putDepletedFuel(7.25E-4, 40, 0.00325, 8, 0.00285, 4, 0.38, 12, "LECm245");
        RadSources.putDepletedFuel(7.25E-4, 48, 0.00325, 4, 0.00285, 4, 0.00115, 8, "HECm245");
        RadSources.putDepletedFuel(7.25E-4, 20, 0.00325, 4, 0.00115, 8, 0.38, 32, "LECm247");
        RadSources.putDepletedFuel(0.00325, 8, 0.00285, 8, 0.00115, 24, 0.38, 24, "HECm247");
        RadSources.putDepletedFuel(0.00285, 4, 0.00115, 4, 0.38, 28, 0.38, 28, "LEB248");
        RadSources.putDepletedFuel(0.0765, 8, 0.00115, 8, 0.38, 24, 0.38, 24, "HEB248");
        RadSources.putDepletedFuel(0.0765, 16, 0.00115, 8, 0.38, 20, 0.38, 20, "LECf249");
        RadSources.putDepletedFuel(0.0765, 32, 0.00115, 16, 0.38, 8, 0.38, 8, "HECf249");
        RadSources.putDepletedFuel(0.00115, 4, 0.38, 20, 0.38, 20, 0.38, 20, "LECf251");
        RadSources.putDepletedFuel(0.00115, 16, 0.38, 16, 0.38, 16, 0.38, 16, "HECf251");
        RadSources.put(9.0E-10, "plateDU");
        RadSources.put(5.625E-11, NCBlocks.rtg_uranium);
        RadSources.put(0.002875, NCBlocks.rtg_plutonium);
        RadSources.put(5.875E-4, NCBlocks.rtg_americium);
        RadSources.put(0.019125, NCBlocks.rtg_californium);
        RadSources.put(3.0375E-5, NCBlocks.helium_collector);
        RadSources.put(2.43E-4, NCBlocks.helium_collector_compact);
        RadSources.put(0.001944, NCBlocks.helium_collector_dense);
    }

    private static void putMaterial(double radiation, String ... ores) {
        for (String ore : ores) {
            for (String suffix : new String[]{"", "Oxide"}) {
                for (String prefix : MATERIAL_INGOT_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 1.0);
                }
                for (String prefix : MATERIAL_NUGGET_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 0.1111111111111111);
                }
                for (String prefix : MATERIAL_HALF_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 0.5);
                }
                for (String prefix : MATERIAL_THIRD_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 0.5);
                }
                for (String prefix : MATERIAL_SMALL_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 0.25);
                }
                for (String prefix : MATERIAL_GEAR_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 4.0);
                }
                for (String prefix : MATERIAL_BLOCK_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 9.0);
                }
                for (String prefix : MATERIAL_SLAB_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 4.5);
                }
            }
        }
    }

    private static void putIsotope(double radiation, String ... ores) {
        for (String ore : ores) {
            for (String suffix : new String[]{"", "Base", "Oxide"}) {
                for (String prefix : ISOTOPE_INGOT_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 1.0);
                }
                for (String prefix : ISOTOPE_NUGGET_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 0.1111111111111111);
                }
                for (String prefix : ISOTOPE_BLOCK_NAME_LIST) {
                    RadSources.addToOreMap(prefix + ore + suffix, radiation * 9.0);
                }
            }
        }
    }

    public static double getFuelRadiation(double rad1, int amount1, double rad2, int amount2) {
        return (rad1 * (double)amount1 + rad2 * (double)amount2) * 1.0;
    }

    private static void putFuel(double rad1, int amount1, double rad2, int amount2, String ore) {
        double radiation = RadSources.getFuelRadiation(rad1, amount1, rad2, amount2);
        RadSources.addToOreMap("fuel" + ore, radiation);
        RadSources.addToOreMap("fuel" + ore + "Oxide", radiation);
        RadSources.addToOreMap("fuelRod" + ore, radiation);
        RadSources.addToOreMap("fuelRod" + ore + "Oxide", radiation);
    }

    private static void putFuel(double fertile, double fissile, String ore) {
        RadSources.putFuel(fertile, 8, fissile, 1, "LE" + ore);
        RadSources.putFuel(fertile, 5, fissile, 4, "HE" + ore);
    }

    public static double getDepletedFuelRadiation(double rad1, int amount1, double rad2, int amount2, double rad3, int amount3, double rad4, int amount4) {
        return (rad1 * (double)amount1 + rad2 * (double)amount2 + rad3 * (double)amount3 + rad4 * (double)amount4) * 0.1111111111111111;
    }

    private static void putDepletedFuel(double rad1, int amount1, double rad2, int amount2, double rad3, int amount3, double rad4, int amount4, String ore) {
        double radiation = RadSources.getDepletedFuelRadiation(rad1, amount1, rad2, amount2, rad3, amount3, rad4, amount4);
        RadSources.addToOreMap("depletedFuel" + ore, radiation);
        RadSources.addToOreMap("depletedFuel" + ore + "Oxide", radiation);
        RadSources.addToOreMap("depletedFuelRod" + ore, radiation);
        RadSources.addToOreMap("depletedFuelRod" + ore + "Oxide", radiation);
    }

    private static void put(double radiation, String ... ores) {
        for (String ore : ores) {
            RadSources.addToOreMap(ore, radiation);
        }
    }

    private static void put(double radiation, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            RadSources.addToStackMap(stack, radiation);
        }
    }

    private static void put(double radiation, Item ... items) {
        for (Item item : items) {
            RadSources.addToStackMap(new ItemStack(item), radiation);
        }
    }

    private static void put(double radiation, Block ... blocks) {
        for (Block block : blocks) {
            RadSources.addToStackMap(new ItemStack(block), radiation);
        }
    }

    public static void postInit() {
        ItemStack stack;
        int scorePos;
        for (String oreInfo : NCConfig.radiation_ores) {
            scorePos = oreInfo.lastIndexOf(95);
            if (scorePos == -1) continue;
            RadSources.addToOreMap(oreInfo.substring(0, scorePos), Double.parseDouble(oreInfo.substring(scorePos + 1)));
        }
        for (String itemInfo : NCConfig.radiation_items) {
            scorePos = itemInfo.lastIndexOf(95);
            if (scorePos == -1 || (stack = RegistryHelper.itemStackFromRegistry(itemInfo.substring(0, scorePos))) == null) continue;
            RadSources.addToStackMap(stack, Double.parseDouble(itemInfo.substring(scorePos + 1)));
        }
        for (String blockInfo : NCConfig.radiation_blocks) {
            scorePos = blockInfo.lastIndexOf(95);
            if (scorePos == -1 || (stack = RegistryHelper.blockStackFromRegistry(blockInfo.substring(0, scorePos))) == null) continue;
            RadSources.addToStackMap(stack, Double.parseDouble(blockInfo.substring(scorePos + 1)));
        }
    }
}

