/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.config.NCConfig;
import nc.init.NCArmor;
import nc.init.NCItems;
import nc.recipe.vanilla.CraftingRecipeHandler;
import nc.util.ArmorHelper;
import nc.util.ItemInfo;
import nc.util.RegistryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RadiationArmor {
    public static final List<Item> ARMOR_ITEM_SHIELDING_BLACKLIST = new ArrayList<Item>();
    public static final List<ItemStack> ARMOR_STACK_SHIELDING_LIST = new ArrayList<ItemStack>();
    public static final Map<ItemInfo, Double> ARMOR_STACK_RESISTANCE_MAP = new HashMap<ItemInfo, Double>();

    public static void init() {
        ARMOR_ITEM_SHIELDING_BLACKLIST.add((Item)NCArmor.helm_hazmat);
        ARMOR_ITEM_SHIELDING_BLACKLIST.add((Item)NCArmor.chest_hazmat);
        ARMOR_ITEM_SHIELDING_BLACKLIST.add((Item)NCArmor.legs_hazmat);
        ARMOR_ITEM_SHIELDING_BLACKLIST.add((Item)NCArmor.boots_hazmat);
        for (String itemInfo : NCConfig.radiation_shielding_item_blacklist) {
            Item item = RegistryHelper.getItem(itemInfo);
            if (item == null) continue;
            ARMOR_ITEM_SHIELDING_BLACKLIST.add(item);
        }
        for (String stackInfo : NCConfig.radiation_shielding_custom_stacks) {
            ItemStack stack = RegistryHelper.itemStackFromRegistry(stackInfo);
            if (stack == null) continue;
            ARMOR_STACK_SHIELDING_LIST.add(stack);
        }
    }

    public static void postInit() {
        for (String stackInfo : NCConfig.radiation_shielding_default_levels) {
            int scorePos = stackInfo.lastIndexOf(95);
            if (scorePos == -1) continue;
            ItemStack stack = RegistryHelper.itemStackFromRegistry(stackInfo.substring(0, scorePos));
            if (stack == null || stack.func_190926_b() || !ArmorHelper.isArmor(stack.func_77973_b(), NCConfig.radiation_horse_armor_public)) {
                return;
            }
            ARMOR_STACK_RESISTANCE_MAP.put(new ItemInfo(stack), Double.parseDouble(stackInfo.substring(scorePos + 1)));
        }
    }

    public static ItemStack armorWithRadResistance(Item armor, double resistance) {
        return RadiationArmor.armorWithRadResistance(new ItemStack(armor), resistance);
    }

    public static ItemStack armorWithRadResistance(ItemStack armor, double resistance) {
        ItemStack stack = armor.func_77946_l();
        if (!ArmorHelper.isArmor(armor.func_77973_b(), true)) {
            return stack;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74780_a("ncRadiationResistance", resistance);
        return stack;
    }

    public static void addArmorShieldingRecipes(Item item) {
        CraftingRecipeHandler.addShapelessArmorUpgradeOreRecipe(RadiationArmor.armorWithRadResistance(item, NCConfig.radiation_shielding_level[0]), item, new ItemStack(NCItems.rad_shielding, 1, 0));
        CraftingRecipeHandler.addShapelessArmorUpgradeOreRecipe(RadiationArmor.armorWithRadResistance(item, NCConfig.radiation_shielding_level[1]), item, new ItemStack(NCItems.rad_shielding, 1, 1));
        CraftingRecipeHandler.addShapelessArmorUpgradeOreRecipe(RadiationArmor.armorWithRadResistance(item, NCConfig.radiation_shielding_level[2]), item, new ItemStack(NCItems.rad_shielding, 1, 2));
    }

    public static void addArmorShieldingRecipes(ItemStack stack) {
        CraftingRecipeHandler.addShapelessArmorUpgradeOreRecipe(RadiationArmor.armorWithRadResistance(stack, NCConfig.radiation_shielding_level[0]), stack, new ItemStack(NCItems.rad_shielding, 1, 0));
        CraftingRecipeHandler.addShapelessArmorUpgradeOreRecipe(RadiationArmor.armorWithRadResistance(stack, NCConfig.radiation_shielding_level[1]), stack, new ItemStack(NCItems.rad_shielding, 1, 1));
        CraftingRecipeHandler.addShapelessArmorUpgradeOreRecipe(RadiationArmor.armorWithRadResistance(stack, NCConfig.radiation_shielding_level[2]), stack, new ItemStack(NCItems.rad_shielding, 1, 2));
    }
}

