/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import nc.capability.radiation.IEntityRads;
import nc.capability.radiation.IRadiationSource;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.network.PacketHandler;
import nc.network.radiation.PlayerRadsUpdatePacket;
import nc.radiation.RadBiomes;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.Lang;
import nc.util.RadiationHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class RadiationHandler {
    private Random rand = new Random();
    public static final DamageSource FATAL_RADS = new DamageSource("fatal_rads").func_76348_h().func_151518_m();
    private static final String RAD_X_WORE_OFF = Lang.localise("message.nuclearcraft.rad_x_wore_off");
    private static final int WORLD_TICK_RATE = NCConfig.radiation_world_tick_rate;
    private static final int PLAYER_TICK_RATE = NCConfig.radiation_player_tick_rate;
    private static final List<int[]> ADJACENT_COORDS = Lists.newArrayList((Object[])new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}});

    @SubscribeEvent
    public void updatePlayerRadiation(TickEvent.PlayerTickEvent event) {
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (!NCConfig.radiation_require_counter && event.phase == TickEvent.Phase.START && event.side == Side.CLIENT) {
            this.playGeigerSound(event.player);
        }
        if (event.phase != TickEvent.Phase.START || event.player.field_70170_p.func_82737_E() % (long)PLAYER_TICK_RATE != 0L) {
            return;
        }
        if (event.side == Side.SERVER && event.player instanceof EntityPlayerMP) {
            double previousResistance;
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            if (!player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
                return;
            }
            IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
            if (playerRads == null) {
                return;
            }
            Chunk chunk = player.field_70170_p.func_72964_e((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
            double previousImmunityTime = playerRads.getRadiationImmunityTime();
            if (previousImmunityTime > 0.0) {
                playerRads.setRadiationImmunityTime(previousImmunityTime - (double)PLAYER_TICK_RATE);
            }
            double radiationLevel = RadiationHelper.transferRadsToPlayer((ICapabilityProvider)player.field_70170_p, (EntityPlayer)player, playerRads, PLAYER_TICK_RATE) + RadiationHelper.transferRadsToPlayer((ICapabilityProvider)chunk, (EntityPlayer)player, playerRads, PLAYER_TICK_RATE) + RadiationHelper.transferRadsFromInventoryToPlayer((EntityPlayer)player, playerRads, chunk, PLAYER_TICK_RATE);
            playerRads.setRadiationLevel(radiationLevel);
            if (!player.func_184812_l_() && playerRads.isFatal()) {
                player.func_70097_a(FATAL_RADS, Float.MAX_VALUE);
            }
            if ((previousResistance = playerRads.getRadiationResistance()) > 0.0) {
                double radXDecayRate = Math.max(previousResistance, NCConfig.radiation_rad_x_amount) / NCConfig.radiation_rad_x_lifetime;
                playerRads.setRadiationResistance(previousResistance - radXDecayRate * (double)PLAYER_TICK_RATE);
                if (playerRads.getRadiationResistance() == 0.0) {
                    playerRads.setRadXWoreOff(true);
                }
            } else {
                playerRads.setRadXWoreOff(false);
            }
            if (playerRads.getRadawayBuffer() > 0.0) {
                playerRads.setTotalRads(playerRads.getTotalRads() - NCConfig.radiation_radaway_rate * (double)PLAYER_TICK_RATE, false);
                playerRads.setRadawayBuffer(playerRads.getRadawayBuffer() - NCConfig.radiation_radaway_rate * (double)PLAYER_TICK_RATE);
            }
            if (playerRads.getRadawayCooldown() > 0.0) {
                playerRads.setRadawayCooldown(playerRads.getRadawayCooldown() - (double)PLAYER_TICK_RATE);
            }
            if (playerRads.getRadXCooldown() > 0.0) {
                playerRads.setRadXCooldown(playerRads.getRadXCooldown() - (double)PLAYER_TICK_RATE);
            }
            PacketHandler.instance.sendTo((IMessage)new PlayerRadsUpdatePacket(playerRads), player);
            if (!player.func_184812_l_()) {
                RadiationHelper.applySymptoms((EntityLivingBase)player, playerRads, Math.max(PLAYER_TICK_RATE, 18));
            }
        } else {
            EntityPlayer player = event.player;
            if (!player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
                return;
            }
            IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
            if (playerRads == null) {
                return;
            }
            if (playerRads.getRadXWoreOff()) {
                player.func_184185_a(SoundHandler.chems_wear_off, 0.5f, 1.0f);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + RAD_X_WORE_OFF));
            }
        }
    }

    @SubscribeEvent
    public void updateChunkRadiation(TickEvent.WorldTickEvent event) {
        Chunk chunk;
        IRadiationSource chunkRadiation;
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (event.phase != TickEvent.Phase.START || event.side == Side.CLIENT || event.world.func_82737_E() % (long)WORLD_TICK_RATE != 0L || !(event.world instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)event.world;
        ChunkProviderServer chunkProvider = world.func_72863_F();
        HashSet loadedChunks = new HashSet(chunkProvider.func_189548_a());
        for (Object entity : new HashSet(world.field_72996_f)) {
            IEntityRads entityRads;
            EntityLiving entityLiving;
            Chunk chunk2 = world.func_72964_e((int)((Entity)entity).field_70165_t >> 4, (int)((Entity)entity).field_70161_v >> 4);
            if (entity instanceof EntityPlayer) {
                RadiationHelper.transferRadsFromInventoryToChunkBuffer(((EntityPlayer)entity).field_71071_by, chunk2);
                continue;
            }
            if (entity instanceof EntityItem) {
                ItemStack stack = ((EntityItem)entity).func_92059_d();
                if (stack.func_190926_b()) continue;
                RadiationHelper.transferRadiationFromStackToChunkBuffer(stack, chunk2);
                continue;
            }
            if (!(entity instanceof EntityLiving) || !(entityLiving = (EntityLiving)entity).hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null) || (entityRads = (IEntityRads)entityLiving.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) == null) continue;
            RadiationHelper.transferRadsFromSourceToEntity((ICapabilityProvider)world, entityLiving, entityRads, WORLD_TICK_RATE);
            RadiationHelper.transferRadsFromSourceToEntity((ICapabilityProvider)chunk2, entityLiving, entityRads, WORLD_TICK_RATE);
            if (entityLiving instanceof EntityMob) {
                if (NCConfig.radiation_mob_buffs) {
                    RadiationHelper.applyMobBuffs(entityLiving, entityRads, Math.max(WORLD_TICK_RATE, 40));
                }
            } else if (NCConfig.radiation_passive_debuffs) {
                if (entityRads.isFatal()) {
                    entityLiving.func_70097_a(FATAL_RADS, 1000.0f);
                }
                RadiationHelper.applySymptoms((EntityLivingBase)entityLiving, entityRads, Math.max(WORLD_TICK_RATE, 40));
            }
            entityRads.setRadiationLevel(entityRads.getRadiationLevel() * (1.0 - NCConfig.radiation_decay_rate));
        }
        HashSet tileSet = new HashSet(world.field_147482_g);
        for (TileEntity tile : tileSet) {
            Chunk chunk3 = world.func_175726_f(tile.func_174877_v());
            RadiationHelper.transferRadiationFromSourceToChunkBuffer((ICapabilityProvider)tile, chunk3);
        }
        BiomeProvider biomeProvider = world.func_72959_q();
        for (Chunk chunk3 : loadedChunks) {
            if (chunk3 == null || !chunk3.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
                return;
            }
            chunkRadiation = (IRadiationSource)chunk3.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
            if (chunkRadiation == null) {
                return;
            }
            Double biomeRadiation = RadBiomes.BIOME_MAP.get(chunk3.func_177411_a(new BlockPos(8, 8, 8), biomeProvider));
            if (biomeRadiation == null) continue;
            RadiationHelper.addToChunkBuffer(chunkRadiation, (double)biomeRadiation);
        }
        for (TileEntity tile : tileSet) {
            if (!(tile instanceof ITileRadiationEnvironment)) continue;
            chunk = world.func_175726_f(tile.func_174877_v());
            if (chunk == null || !chunk.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
                return;
            }
            IRadiationSource chunkRadiation2 = (IRadiationSource)chunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
            if (chunkRadiation2 == null) {
                return;
            }
            ((ITileRadiationEnvironment)tile).setCurrentChunkBuffer(chunkRadiation2.getRadiationBuffer());
        }
        for (TileEntity tile : tileSet) {
            if (!(tile instanceof ITileRadiationEnvironment)) continue;
            chunk = world.func_175726_f(tile.func_174877_v());
            RadiationHelper.addFractionToChunkBuffer(chunk, (ITileRadiationEnvironment)tile);
        }
        for (Chunk chunk3 : loadedChunks) {
            if (chunk3 == null || !chunk3.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
                return;
            }
            chunkRadiation = (IRadiationSource)chunk3.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
            if (chunkRadiation == null) {
                return;
            }
            double changeRate = chunkRadiation.getRadiationLevel() < chunkRadiation.getRadiationBuffer() || chunkRadiation.getRadiationBuffer() < 0.0 ? NCConfig.radiation_spread_rate : NCConfig.radiation_decay_rate;
            double buffer = Math.max(0.0, chunkRadiation.getRadiationBuffer());
            chunkRadiation.setRadiationLevel(chunkRadiation.getRadiationLevel() + (buffer - chunkRadiation.getRadiationLevel()) * changeRate);
            chunkRadiation.setRadiationBuffer(0.0);
        }
        for (Chunk chunk3 : loadedChunks) {
            RadiationHelper.spreadRadiationFromChunk(chunk3, this.getRandomAdjacentChunk(chunkProvider, chunk3));
        }
    }

    private Chunk getRandomAdjacentChunk(ChunkProviderServer chunkProvider, Chunk chunk) {
        if (chunkProvider == null || chunk == null) {
            return null;
        }
        int x = chunk.func_76632_l().field_77276_a;
        int z = chunk.func_76632_l().field_77275_b;
        Collections.shuffle(ADJACENT_COORDS);
        for (int[] pos : ADJACENT_COORDS) {
            Chunk adjChunk;
            if (!chunkProvider.func_73149_a(x + pos[0], z + pos[1]) || (adjChunk = chunkProvider.func_186026_b(x + pos[0], z + pos[1])) == null) continue;
            return adjChunk;
        }
        return null;
    }

    private void playGeigerSound(EntityPlayer player) {
        if (player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            IEntityRads entityRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
            if (entityRads == null) {
                return;
            }
            if (!entityRads.isRadiationUndetectable()) {
                double soundChance = Math.cbrt(entityRads.getRadiationLevel() / 200.0);
                for (int i = 0; i < 2; ++i) {
                    if (!(this.rand.nextDouble() < soundChance)) continue;
                    player.func_184185_a(SoundHandler.geiger_tick, 0.6f + this.rand.nextFloat() * 0.2f, 0.92f + this.rand.nextFloat() * 0.16f);
                }
            }
        }
    }
}

