/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IFluidIngredient;
import net.minecraftforge.fluids.FluidStack;

public class FluidArrayIngredient
implements IFluidIngredient {
    public List<IFluidIngredient> ingredientList;
    public List<FluidStack> cachedStackList = new ArrayList<FluidStack>();

    public FluidArrayIngredient(IFluidIngredient ... ingredients) {
        this(Lists.newArrayList((Object[])ingredients));
    }

    public FluidArrayIngredient(List<IFluidIngredient> ingredientList) {
        this.ingredientList = ingredientList;
        ingredientList.forEach(input -> this.cachedStackList.add(input.getStack()));
    }

    @Override
    public FluidStack getStack() {
        if (this.cachedStackList == null || this.cachedStackList.isEmpty() || this.cachedStackList.get(0) == null) {
            return null;
        }
        return this.cachedStackList.get(0).copy();
    }

    @Override
    public String getIngredientName() {
        return this.ingredientList.get(0).getIngredientName();
    }

    @Override
    public String getIngredientNamesConcat() {
        String names = "";
        for (IFluidIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getIngredientName();
        }
        return names.substring(2);
    }

    @Override
    public int getMaxStackSize() {
        return this.ingredientList.get(0).getMaxStackSize();
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        for (IFluidIngredient ingredient : this.ingredientList) {
            ingredient.setMaxStackSize(stackSize);
        }
        for (FluidStack stack : this.cachedStackList) {
            stack.amount = stackSize;
        }
    }

    @Override
    public List<FluidStack> getInputStackList() {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        this.ingredientList.forEach(ingredient -> ingredient.getInputStackList().forEach(obj -> stacks.add((FluidStack)obj)));
        return stacks;
    }

    @Override
    public List<FluidStack> getOutputStackList() {
        if (this.cachedStackList == null || this.cachedStackList.isEmpty()) {
            return new ArrayList<FluidStack>();
        }
        return Lists.newArrayList((Object[])new FluidStack[]{this.getStack()});
    }

    @Override
    public boolean matches(Object object, IngredientSorption sorption) {
        for (IFluidIngredient ingredient : this.ingredientList) {
            if (!ingredient.matches(object, sorption)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.cachedStackList != null && !this.cachedStackList.isEmpty();
    }
}

