/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IItemIngredient;
import net.minecraft.item.ItemStack;

public class ItemArrayIngredient
implements IItemIngredient {
    public List<IItemIngredient> ingredientList;
    public List<ItemStack> cachedStackList = new ArrayList<ItemStack>();

    public ItemArrayIngredient(IItemIngredient ... ingredients) {
        this(Lists.newArrayList((Object[])ingredients));
    }

    public ItemArrayIngredient(List<IItemIngredient> ingredientList) {
        this.ingredientList = ingredientList;
        ingredientList.forEach(input -> this.cachedStackList.add(input.getStack()));
    }

    @Override
    public ItemStack getStack() {
        if (this.cachedStackList == null || this.cachedStackList.isEmpty() || this.cachedStackList.get(0) == null) {
            return null;
        }
        return this.cachedStackList.get(0).func_77946_l();
    }

    @Override
    public String getIngredientName() {
        return this.ingredientList.get(0).getIngredientName();
    }

    @Override
    public String getIngredientNamesConcat() {
        String names = "";
        for (IItemIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getIngredientName();
        }
        return names.substring(2);
    }

    @Override
    public int getMaxStackSize() {
        return this.ingredientList.get(0).getMaxStackSize();
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        for (IItemIngredient ingredient : this.ingredientList) {
            ingredient.setMaxStackSize(stackSize);
        }
        for (ItemStack stack : this.cachedStackList) {
            stack.func_190920_e(stackSize);
        }
    }

    @Override
    public List<ItemStack> getInputStackList() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.ingredientList.forEach(ingredient -> ingredient.getInputStackList().forEach(obj -> stacks.add((ItemStack)obj)));
        return stacks;
    }

    @Override
    public List<ItemStack> getOutputStackList() {
        if (this.cachedStackList == null || this.cachedStackList.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getStack()});
    }

    @Override
    public boolean matches(Object object, IngredientSorption sorption) {
        for (IItemIngredient ingredient : this.ingredientList) {
            if (!ingredient.matches(object, sorption)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.cachedStackList != null && !this.cachedStackList.isEmpty() && this.cachedStackList.get(0) != null;
    }
}

