/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.OreIngredient;
import nc.util.OreDictHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;

public class AlloyFurnaceRecipes
extends ProcessorRecipeHandler {
    public AlloyFurnaceRecipes() {
        super("alloy_furnace", 2, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addAlloyIngotIngotRecipes("Copper", 3, "Tin", 1, "Bronze", 4, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Iron", 1, "Graphite", 1, "Steel", 1, 1.0, 1.0);
        this.addAlloyIngotCoalRecipes("Iron", 1, 2, "Steel", 1, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Steel", 1, "Boron", 1, "Ferroboron", 2, 1.0, 1.5);
        this.addAlloyIngotIngotRecipes("Ferroboron", 1, "Lithium", 1, "Tough", 2, 1.5, 1.5);
        this.addAlloyIngotGemRecipes("Graphite", 2, "Diamond", 1, "HardCarbon", 2, 1.0, 2.0);
        this.addAlloyIngotIngotRecipes("Magnesium", 1, "Boron", 2, "MagnesiumDiboride", 3, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Lithium", 1, "ManganeseDioxide", 1, "LithiumManganeseDioxide", 2, 1.5, 1.0);
        this.addAlloyIngotIngotRecipes("Copper", 3, "Silver", 1, "Shibuichi", 4, 1.5, 0.5);
        this.addAlloyIngotIngotRecipes("Tin", 3, "Silver", 1, "TinSilver", 4, 1.5, 0.5);
        this.addAlloyIngotIngotRecipes("Lead", 3, "Platinum", 1, "LeadPlatinum", 4, 1.5, 0.5);
        this.addAlloyIngotIngotRecipes("Tough", 1, "HardCarbon", 1, "Extreme", 1, 2.0, 2.0);
        this.addAlloyIngotGemRecipes("Extreme", 1, "BoronArsenide", 1, "Thermoconducting", 2, 1.5, 1.5);
        this.addAlloyIngotIngotRecipes("Zirconium", 7, "Tin", 1, "Zircaloy", 8, 4.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"itemSilicon", "ingotSilicon"}), Lists.newArrayList((Object[])new String[]{"ingotGraphite", "dustGraphite"}), this.oreStack("ingotSiliconCarbide", 2), 2.0, 2.0);
        this.addAlloyIngotIngotRecipes("Iron", 15, "CarbonManganese", 1, "HSLASteel", 16, 8.0, 2.0);
        this.addAlloyIngotIngotRecipes("Aluminum", 3, "Copper", 1, "AluminumBrass", 4, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Aluminium", 3, "Copper", 1, "AluminumBrass", 4, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Cobalt", 1, "Ardite", 1, "Manyullyn", 1, 2.0, 2.0);
        this.addAlloyIngotIngotRecipes("Gold", 1, "Silver", 1, "Electrum", 2, 1.0, 0.5);
        this.addAlloyIngotIngotRecipes("Iron", 2, "Nickel", 1, "Invar", 3, 1.0, 1.5);
        this.addAlloyIngotIngotRecipes("Copper", 1, "Nickel", 1, "Constantan", 2, 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotSteel", "dustSteel"}), Lists.newArrayList((Object[])new String[]{"itemSilicon", "ingotSilicon"}), "ingotElectricalSteel", 1.5, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotGold", "dustGold"}), this.oreStack("dustEnergetic", 2), "ingotEnergeticAlloy", 1.0, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotEnergeticAlloy", "dustEnergeticAlloy"}), Lists.newArrayList((Object[])new Object[]{Items.field_151079_bi, "dustEnder"}), "ingotVibrantAlloy", 1.5, 2.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"itemSilicon", "ingotSilicon"}), "dustRedstone", "ingotRedstoneAlloy", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotIron", "dustIron"}), "dustRedstone", "ingotConductiveIron", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotIron", "dustIron"}), Lists.newArrayList((Object[])new Object[]{Items.field_151079_bi, "dustEnder"}), "ingotPulsatingIron", 1.5, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotSteel", "dustSteel"}), "obsidian", "ingotDarkSteel", 1.5, 2.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotGold", "dustGold"}), Blocks.field_150425_aM, "ingotSoularium", 1.5, 0.5);
        this.addRecipe(this.oreStackList(Lists.newArrayList((Object[])new String[]{"ingotLead", "dustLead"}), 2), Lists.newArrayList((Object[])new String[]{"ingotIron", "dustIron"}), this.oreStack("ingotConstructionAlloy", 3), 1.0, 1.0);
        this.addRecipe("ingotDarkSteel", this.oreStack("dustDimensional", 2), "ingotEndSteel", 2.0, 2.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"gemDiamond", "dustDiamond"}), this.oreStack("nuggetPulsatingIron", 8), "itemPulsatingCrystal", 1.0, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"gemEmerald", "dustEmerald"}), this.oreStack("nuggetVibrantAlloy", 8), "itemVibrantCrystal", 1.0, 1.5);
        this.addAlloyIngotIngotRecipes("Copper", 3, "Zinc", 1, "Brass", 4, 1.0, 1.0);
        this.addAlloyIngotDustRecipes("Gold", 1, "Redstone", 2, "ingotRedmetal", 1, 1.0, 1.0);
        this.addAlloyIngotFuelRecipes("Iron", 2, "Coke", 1, "Steel", 2, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Aluminum", 7, "Titanium", 3, "TitaniumAluminide", 3, 3.0, 1.0);
        this.addAlloyIngotIngotRecipes("Aluminium", 7, "Titanium", 3, "TitaniumAluminide", 3, 3.0, 1.0);
        this.addAlloyIngotIngotRecipes("Titanium", 1, "Iridium", 1, "TitaniumIridium", 2, 1.5, 2.0);
    }

    public void addAlloyIngotIngotRecipes(String in1, int inSize1, String in2, int inSize2, String out, int outSize, double time, double power) {
        this.addAlloyRecipes(in1, inSize1, in2, inSize2, out, outSize, time, power, OreDictHelper.NUGGET_VOLUME_TYPES, OreDictHelper.INGOT_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES, OreDictHelper.NUGGET_VOLUME_TYPES, OreDictHelper.INGOT_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES);
    }

    public void addAlloyIngotDustRecipes(String in1, int inSize1, String in2, int inSize2, String out, int outSize, double time, double power) {
        this.addAlloyRecipes(in1, inSize1, in2, inSize2, out, outSize, time, power, OreDictHelper.NUGGET_VOLUME_TYPES, OreDictHelper.INGOT_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES, OreDictHelper.TINYDUST_VOLUME_TYPES, OreDictHelper.DUST_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES);
    }

    public void addAlloyIngotFuelRecipes(String in1, int inSize1, String in2, int inSize2, String out, int outSize, double time, double power) {
        this.addAlloyRecipes(in1, inSize1, in2, inSize2, out, outSize, time, power, OreDictHelper.NUGGET_VOLUME_TYPES, OreDictHelper.INGOT_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES, OreDictHelper.TINYDUST_VOLUME_TYPES, OreDictHelper.FUEL_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES);
    }

    public void addAlloyIngotGemRecipes(String in1, int inSize1, String in2, int inSize2, String out, int outSize, double time, double power) {
        this.addAlloyRecipes(in1, inSize1, in2, inSize2, out, outSize, time, power, OreDictHelper.NUGGET_VOLUME_TYPES, OreDictHelper.INGOT_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES, OreDictHelper.TINYDUST_VOLUME_TYPES, OreDictHelper.GEM_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES);
    }

    public void addAlloyRecipes(String in1, int inSize1, String in2, int inSize2, String out, int outSize, double time, double power, List<String> inNuggets1, List<String> inIngots1, List<String> inBlocks1, List<String> inNuggets2, List<String> inIngots2, List<String> inBlocks2) {
        this.addRecipe(this.typeStackList(in1, inIngots1, inSize1), this.typeStackList(in2, inIngots2, inSize2), this.oreStack("ingot" + out, outSize), time, power);
        this.addRecipe(this.typeStackList(in1, inNuggets1, inSize1), this.typeStackList(in2, inNuggets2, inSize2), this.oreStack("nugget" + out, outSize), time / 9.0, power);
        this.addRecipe(this.typeStackList(in1, inBlocks1, inSize1), this.typeStackList(in2, inBlocks2, inSize2), this.oreStack("block" + out, outSize), time * 9.0, power);
    }

    public void addAlloyIngotCoalRecipes(String in1, int inSize1, int inSize2, String out, int outSize, double time, double power) {
        this.addRecipe(this.typeStackList(in1, OreDictHelper.INGOT_VOLUME_TYPES, inSize1), this.typeStackList("", OreDictHelper.COAL_TYPES, inSize2), this.oreStack("ingot" + out, outSize), time, power);
        this.addRecipe(this.typeStackList(in1, OreDictHelper.NUGGET_VOLUME_TYPES, inSize1), this.typeStackList("Coal", OreDictHelper.TINYDUST_VOLUME_TYPES, inSize2), this.oreStack("nugget" + out, outSize), time / 9.0, power);
        this.addRecipe(this.typeStackList(in1, OreDictHelper.BLOCK_VOLUME_TYPES, inSize1), this.typeStackList("Coal", OreDictHelper.BLOCK_VOLUME_TYPES, inSize2), this.oreStack("block" + out, outSize), time * 9.0, power);
    }

    private ArrayList<OreIngredient> typeStackList(String type, List<String> forms, int size) {
        ArrayList<OreIngredient> list = new ArrayList<OreIngredient>();
        for (String form : forms) {
            list.add(this.oreStack(form + type, size));
        }
        return list;
    }
}

