/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nc.init.NCItems;
import nc.recipe.ProcessorRecipeHandler;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import net.minecraft.init.Items;
import net.minecraftforge.fluids.FluidRegistry;

public class IngotFormerRecipes
extends ProcessorRecipeHandler {
    private static final List<String> CASTING_BLACKLIST = Arrays.asList("glass", "coal", "redstone", "glowstone", "prismarine", "obsidian", "silicon");

    public IngotFormerRecipes() {
        super("ingot_former", 0, 1, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addIngotFormingRecipes();
        this.addIngotFormingRecipe("thorium", "ThoriumOxide");
        this.addIngotFormingRecipe("uranium", "UraniumOxide");
        this.addIngotFormingRecipe("hard_carbon", "HardCarbon");
        this.addIngotFormingRecipe("manganese_dioxide", "ManganeseDioxide");
        this.addRecipe(this.fluidStack("bas", 666), "gemBoronArsenide", 2.0, 2.0);
        if (OreDictHelper.oreExists("ingotObsidian")) {
            this.addRecipe(this.fluidStack("obsidian", 72), "ingotObsidian", 0.5, 2.0);
        } else {
            this.addRecipe(this.fluidStack("obsidian", 288), "obsidian", 2.0, 2.0);
        }
        this.addRecipe(this.fluidStack("redstone", 100), "ingotRedstone", 0.25, 1.0);
        this.addRecipe(this.fluidStack("glowstone", 250), "ingotGlowstone", 0.25, 1.0);
        this.addRecipe(this.fluidStack("coal", 100), "ingotGraphite", 0.5, 1.0);
        this.addRecipe(this.fluidStack("prismarine", 144), "gemPrismarine", 1.0, 1.0);
        if (OreDictHelper.oreExists("ingotSilicon")) {
            this.addRecipe(this.fluidStack("silicon", 144), "ingotSilicon", 1.0, 1.0);
        } else {
            this.addRecipe(this.fluidStack("silicon", 144), "itemSilicon", 1.0, 1.0);
        }
        this.addIngotFormingRecipe("Manyullyn");
        this.addIngotFormingRecipe("Alubrass");
        this.addIngotFormingRecipe("Pigiron");
        this.addIngotFormingRecipe("Brass");
        this.addIngotFormingRecipe("Bronze");
        this.addIngotFormingRecipe("Electrum");
        this.addIngotFormingRecipe("Steel");
        this.addRecipe(this.fluidStack("brine", 15), "dustSalt", 0.25, 0.5);
        this.addRecipe(this.fluidStack("cocoa_butter", 144), NCItems.cocoa_butter, 0.5, 0.5);
        this.addRecipe(this.fluidStack("unsweetened_chocolate", 144), NCItems.unsweetened_chocolate, 0.5, 0.5);
        this.addRecipe(this.fluidStack("dark_chocolate", 144), NCItems.dark_chocolate, 0.5, 0.5);
        this.addRecipe(this.fluidStack("milk_chocolate", 144), NCItems.milk_chocolate, 0.5, 0.5);
        this.addRecipe(this.fluidStack("sugar", 144), Items.field_151102_aT, 0.5, 0.5);
        this.addRecipe(this.fluidStack("gelatin", 144), NCItems.gelatin, 0.5, 0.5);
        this.addRecipe(this.fluidStack("marshmallow", 144), NCItems.marshmallow, 0.5, 0.5);
        this.addIsotopeFormingRecipes("Thorium", 230);
        this.addIngotFormingRecipe("fuel_tbu", "Thorium232Base");
        this.addIsotopeFormingRecipes("Uranium", 233, 235, 238);
        this.addIsotopeFormingRecipes("Neptunium", 236, 237);
        this.addIsotopeFormingRecipes("Plutonium", 238, 239, 241, 242);
        this.addIsotopeFormingRecipes("Americium", 241, 242, 243);
        this.addIsotopeFormingRecipes("Curium", 243, 245, 246, 247);
        this.addIsotopeFormingRecipes("Berkelium", 247, 248);
        this.addIsotopeFormingRecipes("Californium", 249, 250, 251, 252);
        this.addRecipe(this.fluidStack("depleted_fuel_tbu", 1024), "depletedFuelTBU", 7.111111111111111, 1.0);
        this.addFissionFuelFormingRecipes("uranium", "eu", 233, 235);
        this.addFissionFuelFormingRecipes("neptunium", "en", 236);
        this.addFissionFuelFormingRecipes("plutonium", "ep", 239, 241);
        this.addFissionFuelFormingRecipes("americium", "ea", 242);
        this.addFissionFuelFormingRecipes("curium", "ec", "m", 243, 245, 247);
        this.addFissionFuelFormingRecipes("berkelium", "eb", 248);
        this.addFissionFuelFormingRecipes("californium", "ec", "f", 249, 251);
    }

    public void addIngotFormingRecipe(String fluid, String metal) {
        this.addRecipe(this.fluidStack(fluid.toLowerCase(), 144), "ingot" + metal, 1.0, 1.0);
    }

    public void addIngotFormingRecipe(String metal) {
        this.addIngotFormingRecipe(metal, metal);
    }

    public void addIsotopeFormingRecipes(String element, int ... types) {
        for (int type : types) {
            this.addIngotFormingRecipe(element.toLowerCase() + "_" + type, element + type + "Base");
        }
    }

    public void addFissionFuelFormingRecipes(String element, String suffix, String suffixExtra, int ... types) {
        for (int type : types) {
            this.addRecipe(this.fluidStack("fuel_l" + suffix + suffixExtra + "_" + type, 1296), "fuelL" + suffix.toUpperCase() + suffixExtra + type, 9.0, 1.0);
            this.addRecipe(this.fluidStack("fuel_h" + suffix + suffixExtra + "_" + type, 1296), "fuelH" + suffix.toUpperCase() + suffixExtra + type, 9.0, 1.0);
            this.addRecipe(this.fluidStack("depleted_fuel_l" + suffix + suffixExtra + "_" + type, 1024), "depletedFuelL" + suffix.toUpperCase() + suffixExtra + type, 7.111111111111111, 1.0);
            this.addRecipe(this.fluidStack("depleted_fuel_h" + suffix + suffixExtra + "_" + type, 1024), "depletedFuelH" + suffix.toUpperCase() + suffixExtra + type, 7.111111111111111, 1.0);
        }
    }

    public void addFissionFuelFormingRecipes(String element, String suffix, int ... types) {
        this.addFissionFuelFormingRecipes(element, suffix, "", types);
    }

    public void addIngotFormingRecipes() {
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().keySet());
        for (String fluidName : fluidList) {
            if (CASTING_BLACKLIST.contains(fluidName)) continue;
            String materialName = StringHelper.capitalize(fluidName);
            String ingot = "ingot" + materialName;
            String gem = "gem" + materialName;
            if (OreDictHelper.oreExists(ingot)) {
                this.addRecipe(this.fluidStack(fluidName, 144), ingot, 1.0, 1.0);
                continue;
            }
            if (!OreDictHelper.oreExists(gem)) continue;
            this.addRecipe(this.fluidStack(fluidName, 666), gem, 1.0, 1.0);
        }
    }
}

