/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energy.battery;

import nc.config.NCConfig;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energy.IEnergySpread;
import nc.tile.energy.ITileEnergy;
import nc.tile.energy.TileEnergy;
import nc.tile.energy.battery.BatteryType;
import nc.tile.energy.battery.IBattery;
import nc.tile.internal.energy.EnergyConnection;
import nc.util.BlockFinder;
import net.minecraft.init.Blocks;

public class TileBattery
extends TileEnergy
implements IBattery,
IInterfaceable,
IEnergySpread {
    private final BatteryType type;
    private BlockFinder finder;
    protected int batteryCount;

    public TileBattery(BatteryType type) {
        super(type.getCapacity(), type.getMaxTransfer(), ITileEnergy.energyConnectionAll(EnergyConnection.IN));
        this.type = type;
    }

    @Override
    public void onAdded() {
        this.finder = new BlockFinder(this.field_174879_c, this.field_145850_b, this.func_145832_p());
        super.onAdded();
        this.batteryCount = -1;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldUpdate = false;
            this.pushEnergy();
            if (this.batteryCount == 0) {
                this.spreadEnergy();
                if (this.findAdjacentComparator()) {
                    shouldUpdate = true;
                }
            }
            this.tickBattery();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public boolean findAdjacentComparator() {
        return this.finder.adjacent(this.field_174879_c, 1, Blocks.field_150441_bU, Blocks.field_150455_bV);
    }

    public void tickBattery() {
        ++this.batteryCount;
        this.batteryCount %= NCConfig.machine_update_rate;
    }

    @Override
    public int getEUSourceTier() {
        return this.type.getEnergyTier();
    }

    @Override
    public int getEUSinkTier() {
        return this.type.getEnergyTier();
    }

    @Override
    public boolean hasConfigurableEnergyConnections() {
        return true;
    }

    public static class LithiumIonBatteryElite
    extends TileBattery {
        public LithiumIonBatteryElite() {
            super(BatteryType.LITHIUM_ION_BATTERY_ELITE);
        }
    }

    public static class LithiumIonBatteryDU
    extends TileBattery {
        public LithiumIonBatteryDU() {
            super(BatteryType.LITHIUM_ION_BATTERY_DU);
        }
    }

    public static class LithiumIonBatteryAdvanced
    extends TileBattery {
        public LithiumIonBatteryAdvanced() {
            super(BatteryType.LITHIUM_ION_BATTERY_ADVANCED);
        }
    }

    public static class LithiumIonBatteryBasic
    extends TileBattery {
        public LithiumIonBatteryBasic() {
            super(BatteryType.LITHIUM_ION_BATTERY_BASIC);
        }
    }

    public static class VoltaicPileElite
    extends TileBattery {
        public VoltaicPileElite() {
            super(BatteryType.VOLTAIC_PILE_ELITE);
        }
    }

    public static class VoltaicPileDU
    extends TileBattery {
        public VoltaicPileDU() {
            super(BatteryType.VOLTAIC_PILE_DU);
        }
    }

    public static class VoltaicPileAdvanced
    extends TileBattery {
        public VoltaicPileAdvanced() {
            super(BatteryType.VOLTAIC_PILE_ADVANCED);
        }
    }

    public static class VoltaicPileBasic
    extends TileBattery {
        public VoltaicPileBasic() {
            super(BatteryType.VOLTAIC_PILE_BASIC);
        }
    }
}

