/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.fluid;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.config.NCConfig;
import nc.tile.ITile;
import nc.tile.fluid.IFluidSpread;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.passive.ITilePassive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public interface ITileFluid
extends ITile {
    @Nonnull
    public List<Tank> getTanks();

    default public boolean isNextToFill(FluidStack resource, int tankNumber) {
        if (!this.getTanksShared()) {
            return true;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (i == tankNumber || !this.getTanks().get(i).canFill() || this.getTanks().get(i).getFluid() == null || !this.getTanks().get(i).getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    default public void clearTank(int tankNumber) {
        if (tankNumber < this.getTanks().size()) {
            this.getTanks().get(tankNumber).setFluidStored(null);
        }
    }

    @Nonnull
    public FluidConnection[] getFluidConnections();

    public void setFluidConnections(@Nonnull FluidConnection[] var1);

    @Nonnull
    default public FluidConnection getFluidConnection(@Nonnull EnumFacing side) {
        return this.getFluidConnections()[side.func_176745_a()];
    }

    default public void setFluidConnection(@Nonnull FluidConnection connection, @Nonnull EnumFacing side) {
        this.getFluidConnections()[side.func_176745_a()] = connection;
    }

    default public void toggleFluidConnection(@Nonnull EnumFacing side) {
        this.setFluidConnection(this.alternativeFluidToggle() ? this.getFluidConnection(side).nextAlt() : this.getFluidConnection(side).next(), side);
        this.markAndRefresh();
    }

    default public boolean alternativeFluidToggle() {
        return false;
    }

    default public boolean canConnectFluid(@Nonnull EnumFacing side) {
        return this.getFluidConnection(side).canConnect();
    }

    public static FluidConnection[] fluidConnectionAll(@Nonnull FluidConnection connection) {
        FluidConnection[] array = new FluidConnection[6];
        for (int i = 0; i < 6; ++i) {
            array[i] = connection;
        }
        return array;
    }

    default public boolean hasConfigurableFluidConnections() {
        return false;
    }

    @Nonnull
    default public IFluidTankProperties[] getTankProperties(EnumFacing side) {
        if (this.getTanks().isEmpty()) {
            return EmptyFluidHandler.EMPTY_TANK_PROPERTIES_ARRAY;
        }
        IFluidTankProperties[] properties = new IFluidTankProperties[this.getTanks().size()];
        for (int i = 0; i < this.getTanks().size(); ++i) {
            properties[i] = this.getTanks().get(i).getFluidTankProperties();
        }
        return properties;
    }

    default public int fill(FluidStack resource, boolean doFill, EnumFacing side) {
        if (this.getTanks().isEmpty() || !this.getFluidConnection(side).canFill()) {
            return 0;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (!this.getTanks().get(i).canFillFluidType(resource) || !this.isNextToFill(resource, i) || this.getTanks().get(i).getFluidAmount() >= this.getTanks().get(i).getCapacity() || this.getTanks().get(i).getFluid() != null && !this.getTanks().get(i).getFluid().isFluidEqual(resource)) continue;
            return this.getTanks().get(i).fill(resource, doFill);
        }
        return 0;
    }

    default public FluidStack drain(FluidStack resource, boolean doDrain, EnumFacing side) {
        if (this.getTanks().isEmpty() || !this.getFluidConnection(side).canDrain()) {
            return null;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (!this.getTanks().get(i).canDrain() || this.getTanks().get(i).getFluidAmount() <= 0 || !resource.isFluidEqual(this.getTanks().get(i).getFluid()) || this.getTanks().get(i).drain(resource, false) == null) continue;
            return this.getTanks().get(i).drain(resource, doDrain);
        }
        return null;
    }

    default public FluidStack drain(int maxDrain, boolean doDrain, EnumFacing side) {
        if (this.getTanks().isEmpty() || !this.getFluidConnection(side).canDrain()) {
            return null;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (!this.getTanks().get(i).canDrain() || this.getTanks().get(i).getFluidAmount() <= 0 || this.getTanks().get(i).drain(maxDrain, false) == null) continue;
            return this.getTanks().get(i).drain(maxDrain, doDrain);
        }
        return null;
    }

    @Nonnull
    public FluidTileWrapper[] getFluidSides();

    @Nonnull
    default public FluidTileWrapper getFluidSide(@Nonnull EnumFacing side) {
        return side == null ? this.getFluidSides()[0] : this.getFluidSides()[side.func_176745_a()];
    }

    @Nonnull
    public static FluidTileWrapper[] getDefaultFluidSides(@Nonnull ITileFluid tile) {
        return new FluidTileWrapper[]{new FluidTileWrapper(tile, EnumFacing.DOWN), new FluidTileWrapper(tile, EnumFacing.UP), new FluidTileWrapper(tile, EnumFacing.NORTH), new FluidTileWrapper(tile, EnumFacing.SOUTH), new FluidTileWrapper(tile, EnumFacing.WEST), new FluidTileWrapper(tile, EnumFacing.EAST)};
    }

    @Nonnull
    public GasTileWrapper getGasWrapper();

    default public void pushFluid() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.getTanks().isEmpty()) {
                return;
            }
            this.pushFluidToSide(side);
        }
    }

    default public void spreadFluid() {
        if (!NCConfig.passive_permeation) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.getTanks().isEmpty()) {
                return;
            }
            this.spreadFluidToSide(side);
        }
    }

    default public void pushFluidToSide(@Nonnull EnumFacing side) {
        if (!this.getFluidConnection(side).canDrain()) {
            return;
        }
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile == null) {
            return;
        }
        if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
            return;
        }
        IFluidHandler adjStorage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjStorage == null) {
            return;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (this.getTanks().get(i).getFluid() == null || !this.getTanks().get(i).canDrain()) continue;
            this.getTanks().get(i).drain(adjStorage.fill(this.getTanks().get(i).drain(this.getTanks().get(i).getCapacity(), false), true), true);
        }
    }

    default public void spreadFluidToSide(@Nonnull EnumFacing side) {
        if (!this.getFluidConnection(side).canConnect()) {
            return;
        }
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile == null) {
            return;
        }
        if (!(tile instanceof IFluidSpread)) {
            return;
        }
        if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
            return;
        }
        IFluidHandler adjStorage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjStorage == null) {
            return;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (this.getTanks().get(i).getFluid() == null || !this.getTanks().get(i).canDistribute()) continue;
            int maxDrain = this.getTanks().get(i).getFluidAmount() / 2;
            FluidStack stack = adjStorage.getTankProperties()[0].getContents();
            if (stack != null) {
                maxDrain -= stack.amount / 2;
            }
            if (maxDrain <= 0) continue;
            this.getTanks().get(i).drainInternal(adjStorage.fill(this.getTanks().get(i).drainInternal(maxDrain, false), true), true);
        }
    }

    default public NBTTagCompound writeTanks(NBTTagCompound nbt) {
        if (!this.getTanks().isEmpty()) {
            for (int i = 0; i < this.getTanks().size(); ++i) {
                nbt.func_74768_a("fluidAmount" + i, this.getTanks().get(i).getFluidAmount());
                nbt.func_74778_a("fluidName" + i, this.getTanks().get(i).getFluidName());
            }
        }
        return nbt;
    }

    default public void readTanks(NBTTagCompound nbt) {
        if (!this.getTanks().isEmpty()) {
            for (int i = 0; i < this.getTanks().size(); ++i) {
                if (nbt.func_74779_i("fluidName" + i) == "nullFluid" || nbt.func_74762_e("fluidAmount" + i) == 0) {
                    this.getTanks().get(i).setFluidStored(null);
                    continue;
                }
                this.getTanks().get(i).setFluidStored(FluidRegistry.getFluid((String)nbt.func_74779_i("fluidName" + i)), nbt.func_74762_e("fluidAmount" + i));
            }
        }
    }

    default public NBTTagCompound writeFluidConnections(NBTTagCompound nbt) {
        for (int i = 0; i < 6; ++i) {
            nbt.func_74768_a("fluidConnections" + i, this.getFluidConnections()[i].ordinal());
        }
        return nbt;
    }

    default public void readFluidConnections(NBTTagCompound nbt) {
        if (this.hasConfigurableFluidConnections()) {
            for (int i = 0; i < 6; ++i) {
                if (!nbt.func_74764_b("fluidConnections" + i)) continue;
                this.getFluidConnections()[i] = FluidConnection.values()[nbt.func_74762_e("fluidConnections" + i)];
            }
        }
    }

    public boolean getTanksShared();

    public void setTanksShared(boolean var1);

    public boolean getEmptyUnusableTankInputs();

    public void setEmptyUnusableTankInputs(boolean var1);

    public boolean getVoidExcessFluidOutputs();

    public void setVoidExcessFluidOutputs(boolean var1);

    default public boolean hasFluidSideCapability(@Nullable EnumFacing side) {
        return side == null || this.getFluidConnection(side).canConnect();
    }
}

