/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.List;
import java.util.Random;
import java.util.Set;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.ModCheck;
import nc.block.tile.generator.BlockFissionController;
import nc.block.tile.generator.BlockFissionControllerNewFixed;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.init.NCBlocks;
import nc.network.tile.FissionUpdatePacket;
import nc.recipe.NCRecipes;
import nc.tile.IGui;
import nc.tile.fluid.TileActiveCooler;
import nc.tile.generator.TileItemGenerator;
import nc.tile.internal.fluid.Tank;
import nc.util.BlockFinder;
import nc.util.BlockPosHelper;
import nc.util.EnergyHelper;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.RadiationHelper;
import nc.util.RegistryHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileFissionController
extends TileItemGenerator
implements IGui<FissionUpdatePacket>,
SimpleComponent {
    private Random rand = new Random();
    public double baseProcessHeat = 0.0;
    public double heat;
    public double cooling;
    public double heatChange;
    public double efficiency;
    public double heatMult;
    public int cells;
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    public int lengthX;
    public int lengthY;
    public int lengthZ = 3;
    public int complete;
    public int ready;
    public int ports = 1;
    public int currentEnergyStored = 0;
    public int energyChange = 0;
    public String problem = CASING_INCOMPLETE;
    public String problemPos = "";
    public int problemPosX = 0;
    public int problemPosY = 0;
    public int problemPosZ = 0;
    public static final int BASE_CAPACITY = 64000;
    public static final int BASE_MAX_HEAT = 25000;
    private boolean isActivated = false;
    public boolean computerActivated = false;
    private int comparatorCount = 0;
    private Object[] oc_layout;
    public static final String NO_FUEL = Lang.localise("gui.container.fission_controller.no_fuel");
    public static final String GENERIC_FUEL = Lang.localise("gui.container.fission_controller.generic_fuel");
    public static final String CASING_INCOMPLETE = Lang.localise("gui.container.fission_controller.casing_incomplete");
    public static final String INVALID_STRUCTURE = Lang.localise("gui.container.fission_controller.invalid_structure");
    public static final String CASING_IN_INTERIOR_AT = Lang.localise("gui.container.fission_controller.casing_in_interior");
    public static final String EXTRA_CONTROLLER_AT = Lang.localise("gui.container.fission_controller.multiple_controllers");
    public static final String CASING_INCOMPLETE_AT = Lang.localise("gui.container.fission_controller.casing_incomplete_at");
    public static final String POS = Lang.localise("gui.container.fission_controller.pos");
    public static final String NO_PROBLEM = Lang.localise("gui.container.fission_controller.no_problem");
    private BlockFinder finder;
    private boolean newRules;

    private TileFissionController(boolean newRules) {
        super("fission_controller", 1, 1, 0, 64000, NCRecipes.Type.FISSION);
        this.newRules = newRules;
    }

    @Override
    public void onAdded() {
        this.finder = new BlockFinder(this.field_174879_c, this.field_145850_b, this.func_145832_p() & 7);
        super.onAdded();
    }

    @Override
    public void updateGenerator() {
        if (this.fixControllerBlock()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean wasActivated = this.isActivated;
            boolean wasProcessing = this.isProcessing;
            this.isActivated = this.isActivated();
            this.isProcessing = this.isProcessing();
            boolean shouldUpdate = false;
            this.tickComparatorCheck();
            if (wasActivated != this.isActivated) {
                this.refreshMultiblock(true);
            } else {
                this.checkStructure(false);
            }
            this.energyChange = this.getEnergyStored() - this.currentEnergyStored;
            if (this.newRules) {
                this.newRun(false);
            } else {
                this.run(false);
            }
            if (this.overheat()) {
                return;
            }
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
                this.updateBlockType();
                this.sendUpdateToAllPlayers();
            }
            this.pushEnergy();
            this.currentEnergyStored = this.getEnergyStored();
            if (this.comparatorCount == 0 && this.findAdjacentComparator()) {
                shouldUpdate = true;
            }
            this.sendUpdateToListeningPlayers();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    private boolean fixControllerBlock() {
        if (!this.newRules) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockFissionController) {
            BlockFissionController controller = (BlockFissionController)state.func_177230_c();
            if (!controller.isNew) {
                this.newRules = false;
                return false;
            }
            int meta = NCBlocks.fission_controller_idle.func_176201_c(state);
            if (controller.isActive) {
                meta |= 8;
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, NCBlocks.fission_controller_new_fixed.func_176203_a(meta));
            return true;
        }
        return false;
    }

    public void tickComparatorCheck() {
        ++this.comparatorCount;
        this.comparatorCount %= 4 * NCConfig.machine_update_rate;
    }

    public void refreshMultiblock(boolean checkBlocks) {
        this.checkStructure(checkBlocks);
        if (this.newRules) {
            this.newRun(checkBlocks);
        } else {
            this.run(checkBlocks);
        }
    }

    @Override
    public void refreshActivity() {
        boolean canProcessInputsOld = this.canProcessInputs;
        super.refreshActivity();
        this.refreshMultiblock(canProcessInputsOld != this.canProcessInputs);
    }

    public boolean findAdjacentComparator() {
        return this.finder.adjacent(this.field_174879_c, 1, Blocks.field_150441_bU, Blocks.field_150455_bV);
    }

    public boolean overheat() {
        if (this.heat >= (double)this.getMaxHeat() && NCConfig.fission_overheat) {
            this.meltdown();
            return true;
        }
        return false;
    }

    public void meltdown() {
        BlockPos middle = this.finder.position((this.minX + this.maxX) / 2, (this.minY + this.maxY) / 2, (this.minZ + this.maxZ) / 2);
        RadiationHelper.addToChunkRadiation(this.field_145850_b.func_175726_f(middle), 8.0 * this.baseProcessRadiation * (double)this.cells * NCConfig.fission_fuel_use);
        IBlockState corium = RegistryHelper.getBlock("nuclearcraft:fluid_corium").func_176223_P();
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, corium);
        if (NCConfig.fission_explosions) {
            this.field_145850_b.func_72876_a(null, (double)middle.func_177958_n(), (double)middle.func_177956_o(), (double)middle.func_177952_p(), (float)(this.lengthX * this.lengthX + this.lengthY * this.lengthY + this.lengthZ * this.lengthZ), true);
        }
        for (int i = this.minX; i <= this.maxX; ++i) {
            for (int j = this.minY; j <= this.maxY; ++j) {
                for (int k = this.minZ; k <= this.maxZ; ++k) {
                    if (!(this.rand.nextDouble() < 0.18)) continue;
                    BlockPos position = this.finder.position(i, j, k);
                    if (this.field_145850_b.func_175625_s(position) != null) {
                        this.field_145850_b.func_175713_t(position);
                    }
                    this.field_145850_b.func_175656_a(position, corium);
                }
            }
        }
    }

    @Override
    public void setState(boolean isActive) {
        super.setState(isActive);
        if (this.func_145838_q() instanceof BlockFissionControllerNewFixed) {
            ((BlockFissionControllerNewFixed)this.func_145838_q()).setActiveState(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this.field_174879_c, isActive);
        }
    }

    @Override
    public boolean setRecipeStats() {
        if (this.recipe == null) {
            this.baseProcessTime = this.defaultProcessTime;
            this.baseProcessPower = this.defaultProcessPower;
            this.baseProcessHeat = 0.0;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = this.recipe.getFissionFuelTime();
        this.baseProcessPower = this.recipe.getFissionFuelPower();
        this.baseProcessHeat = this.recipe.getFissionFuelHeat();
        this.baseProcessRadiation = this.recipe.getFissionFuelRadiation();
        return true;
    }

    @Override
    public boolean isProcessing() {
        return this.readyToProcess() && this.isActivated;
    }

    @Override
    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasConsumed && this.complete == 1;
    }

    private boolean isActivated() {
        return this.getIsRedstonePowered() || this.computerActivated;
    }

    @Override
    public void finishProcess() {
        super.finishProcess();
    }

    @Override
    public int getEUSourceTier() {
        return EnergyHelper.getEUTier(this.processPower);
    }

    @Override
    public int getEUSinkTier() {
        return 4;
    }

    public String getFuelName() {
        if (this.recipe == null) {
            return NO_FUEL;
        }
        if (this.recipe.extras().size() < 4) {
            return GENERIC_FUEL;
        }
        Object fuelNameInfo = this.recipe.extras().get(3);
        if (fuelNameInfo instanceof String) {
            return ((String)fuelNameInfo).replace('_', '-');
        }
        return GENERIC_FUEL;
    }

    public int getLengthX() {
        return this.lengthX - 2;
    }

    public int getLengthY() {
        return this.lengthY - 2;
    }

    public int getLengthZ() {
        return this.lengthZ - 2;
    }

    public int getMaxHeat() {
        if (NCMath.atIntLimit(this.getLengthX() * this.getLengthY() * this.getLengthZ(), 25000)) {
            return Integer.MAX_VALUE;
        }
        if (this.getLengthX() <= 0 || this.getLengthY() <= 0 || this.getLengthZ() <= 0) {
            return 25000;
        }
        return 25000 * this.getLengthX() * this.getLengthY() * this.getLengthZ();
    }

    private boolean findCell(BlockPos pos) {
        return this.finder.find(pos, NCBlocks.cell_block);
    }

    private boolean findCell(int x, int y, int z) {
        return this.findCell(this.finder.position(x, y, z));
    }

    private boolean findModerator(BlockPos pos) {
        return this.finder.find(pos, "blockGraphite", "blockBeryllium");
    }

    private boolean findModerator(int x, int y, int z) {
        return this.findModerator(this.finder.position(x, y, z));
    }

    private boolean findCellOnSide(int x, int y, int z, EnumFacing side) {
        return this.findCell(this.finder.position(x, y, z).func_177972_a(side));
    }

    private boolean findModeratorThenCellOnSide(int x, int y, int z, EnumFacing side) {
        return this.findModerator(this.finder.position(x, y, z).func_177972_a(side)) && this.findCell(this.finder.position(x, y, z).func_177967_a(side, 2));
    }

    private boolean newFindModeratorThenCellOnSide(int x, int y, int z, EnumFacing side) {
        for (int i = 1; i <= NCConfig.fission_neutron_reach; ++i) {
            for (int j = 1; j <= i; ++j) {
                if (this.findModerator(this.finder.position(x, y, z).func_177967_a(side, j))) continue;
                return false;
            }
            if (!this.findCell(this.finder.position(x, y, z).func_177967_a(side, i + 1))) continue;
            return true;
        }
        return false;
    }

    private int moderatorAdjacentCount(BlockPos pos) {
        int count = 0;
        BlockPosHelper helper = new BlockPosHelper(pos);
        for (BlockPos blockPos : helper.adjacents()) {
            if (!this.findModerator(blockPos)) continue;
            ++count;
        }
        return count;
    }

    private int moderatorAdjacentCount(int x, int y, int z) {
        return this.moderatorAdjacentCount(this.finder.position(x, y, z));
    }

    private int activeModeratorAdjacentCount(BlockPos pos) {
        int count = 0;
        BlockPosHelper helper = new BlockPosHelper(pos);
        for (BlockPos blockPos : helper.adjacents()) {
            if (!this.findModerator(blockPos) || !this.cellAdjacent(blockPos)) continue;
            ++count;
        }
        return count;
    }

    private int activeModeratorAdjacentCount(int x, int y, int z) {
        return this.activeModeratorAdjacentCount(this.finder.position(x, y, z));
    }

    private boolean cellAdjacent(BlockPos pos) {
        return this.finder.adjacent(pos, 1, NCBlocks.cell_block);
    }

    private boolean cellAdjacent(int x, int y, int z) {
        return this.finder.adjacent(x, y, z, 1, NCBlocks.cell_block);
    }

    private int cellAdjacentCount(BlockPos pos) {
        return this.finder.adjacentCount(pos, 1, NCBlocks.cell_block);
    }

    private int cellAdjacentCount(int x, int y, int z) {
        return this.cellAdjacentCount(this.finder.position(x, y, z));
    }

    private boolean activeModeratorAdjacent(BlockPos pos) {
        BlockPosHelper helper = new BlockPosHelper(pos);
        for (BlockPos blockPos : helper.adjacents()) {
            if (!this.findModerator(blockPos) || !this.cellAdjacent(blockPos)) continue;
            return true;
        }
        return false;
    }

    private boolean activeModeratorAdjacent(int x, int y, int z) {
        return this.activeModeratorAdjacent(this.finder.position(x, y, z));
    }

    private boolean findCooler(BlockPos pos, int meta) {
        return this.finder.find(pos, NCBlocks.cooler.func_176203_a(meta));
    }

    private boolean findCooler(int x, int y, int z, int meta) {
        return this.findCooler(this.finder.position(x, y, z), meta);
    }

    private boolean activeCoolerAdjacent(BlockPos pos, int meta) {
        BlockPosHelper helper = new BlockPosHelper(pos);
        for (BlockPos blockPos : helper.adjacents()) {
            if (!this.findCooler(blockPos, meta) || !this.coolerRequirements(blockPos, meta)) continue;
            return true;
        }
        return false;
    }

    private boolean activeCoolerAdjacent(int x, int y, int z, int meta) {
        return this.activeCoolerAdjacent(this.finder.position(x, y, z), meta);
    }

    private int activeCoolerAdjacentCount(BlockPos pos, int meta) {
        int count = 0;
        BlockPosHelper helper = new BlockPosHelper(pos);
        for (BlockPos blockPos : helper.adjacents()) {
            if (!this.findCooler(blockPos, meta) || !this.coolerRequirements(blockPos, meta)) continue;
            ++count;
        }
        return count;
    }

    private int activeCoolerAdjacentCount(int x, int y, int z, int meta) {
        return this.activeCoolerAdjacentCount(this.finder.position(x, y, z), meta);
    }

    private boolean activeCoolerConfiguration(BlockPos pos, int meta, List<BlockPos[]> posArrays) {
        for (BlockPos[] posArray : posArrays) {
            if (!this.finder.configuration(posArray, NCBlocks.cooler.func_176203_a(meta))) continue;
            for (BlockPos blockPos : posArray) {
                if (this.coolerRequirements(blockPos, meta)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean activeCoolerHorizontal(BlockPos pos, int meta) {
        return this.activeCoolerConfiguration(pos, meta, new BlockPosHelper(pos).horizontalsList());
    }

    private boolean activeCoolerAxial(BlockPos pos, int meta) {
        return this.activeCoolerConfiguration(pos, meta, new BlockPosHelper(pos).axialsList());
    }

    private boolean coolerRequirements(BlockPos pos, int meta) {
        switch (meta) {
            case 1: {
                return !NCConfig.fission_water_cooler_requirement || (this.newRules ? this.cellAdjacent(pos) || this.activeModeratorAdjacent(pos) : this.casingAllAdjacent(pos));
            }
            case 2: {
                return this.cellAdjacent(pos);
            }
            case 3: {
                return this.activeModeratorAdjacent(pos);
            }
            case 4: {
                return this.activeCoolerAdjacent(pos, 1) && this.activeCoolerAdjacent(pos, 2);
            }
            case 5: {
                return this.activeModeratorAdjacentCount(pos) >= 2;
            }
            case 6: {
                return this.cellAdjacent(pos) && this.casingAllAdjacent(pos);
            }
            case 7: {
                return this.newRules ? this.activeCoolerAdjacent(pos, 1) && this.activeCoolerAdjacent(pos, 3) : this.activeCoolerHorizontal(pos, 1) && this.casingAllAdjacent(pos);
            }
            case 8: {
                return this.newRules ? this.activeCoolerAdjacentCount(pos, 2) == 1 && this.casingAllAdjacent(pos) : this.activeCoolerAdjacent(pos, 3) && this.casingAllAdjacent(pos);
            }
            case 9: {
                return this.casingAllOneVertex(pos);
            }
            case 10: {
                return this.cellAdjacentCount(pos) >= 2;
            }
            case 11: {
                return this.activeCoolerAdjacent(pos, 4);
            }
            case 12: {
                return this.activeModeratorAdjacent(pos) && this.cellAdjacent(pos);
            }
            case 13: {
                return this.activeCoolerAdjacent(pos, 5);
            }
            case 14: {
                return this.activeCoolerAxial(pos, 6);
            }
            case 15: {
                return this.newRules ? this.casingAllAdjacent(pos) && this.activeModeratorAdjacent(pos) : this.casingAllAdjacent(pos) && this.activeCoolerAdjacent(pos, 8);
            }
        }
        return false;
    }

    private boolean coolerRequirements(int x, int y, int z, int meta) {
        return this.coolerRequirements(this.finder.position(x, y, z), meta);
    }

    private boolean findCasing(BlockPos pos) {
        return this.finder.find(pos, NCBlocks.fission_block.func_176203_a(0), NCBlocks.reactor_casing_transparent, NCBlocks.fission_port, NCBlocks.buffer, NCBlocks.reactor_door, NCBlocks.reactor_trapdoor);
    }

    private boolean findCasing(int x, int y, int z) {
        return this.findCasing(this.finder.position(x, y, z));
    }

    private boolean findController(BlockPos pos) {
        return this.finder.find(pos, NCBlocks.fission_controller_new_fixed, NCBlocks.fission_controller_idle, NCBlocks.fission_controller_active, NCBlocks.fission_controller_new_idle, NCBlocks.fission_controller_new_active);
    }

    private boolean findController(int x, int y, int z) {
        return this.findController(this.finder.position(x, y, z));
    }

    private boolean findCasingAll(BlockPos pos) {
        return this.findCasing(pos) || this.findController(pos);
    }

    private boolean findCasingAll(int x, int y, int z) {
        return this.findCasingAll(this.finder.position(x, y, z));
    }

    private boolean findPort(BlockPos pos) {
        return this.finder.find(pos, NCBlocks.fission_port);
    }

    private boolean findPort(int x, int y, int z) {
        return this.findPort(this.finder.position(x, y, z));
    }

    private boolean casingAllAdjacent(BlockPos pos) {
        BlockPosHelper posHelper = new BlockPosHelper(pos);
        for (BlockPos blockPos : posHelper.adjacents()) {
            if (!this.findCasingAll(blockPos)) continue;
            return true;
        }
        return false;
    }

    private boolean casingAllOneVertex(BlockPos pos) {
        int count = 0;
        BlockPosHelper posHelper = new BlockPosHelper(pos);
        block0: for (BlockPos[] vertexPosList : posHelper.vertexList()) {
            for (BlockPos blockPos : vertexPosList) {
                if (!this.findCasingAll(blockPos)) continue block0;
            }
            if (++count <= 1) continue;
            return false;
        }
        return count == 1;
    }

    public boolean checkStructure(boolean checkBlocks) {
        if (checkBlocks) {
            int y;
            int x;
            int y2;
            int z;
            int maxLength = NCConfig.fission_max_size + 1;
            boolean validStructure = false;
            int maxZCheck = 0;
            int minZ = 0;
            int minX = 0;
            int minY = 0;
            int maxZ = 0;
            int maxX = 0;
            int maxY = 0;
            int portCount = 0;
            for (z = 0; z <= maxLength; ++z) {
                if (this.findCasingAll(0, 1, 0) || this.findCasingAll(0, -1, 0) || (this.findCasingAll(1, 1, 0) || this.findCasingAll(1, -1, 0)) && this.findCasingAll(1, 0, 0) || this.findCasingAll(1, 1, 0) && !this.findCasingAll(1, -1, 0) && !this.findCasingAll(1, 0, 0) || !this.findCasingAll(1, 1, 0) && this.findCasingAll(1, -1, 0) && !this.findCasingAll(1, 0, 0)) {
                    if (this.findCasingAll(0, 1, -z) || this.findCasingAll(0, -1, -z) || !this.findCasingAll(0, 0, -z + 1) && !this.findCasingAll(0, 1, -z + 1) && !this.findCasingAll(0, -1, -z + 1)) continue;
                    maxZCheck = maxLength - z;
                    minZ = -z;
                    validStructure = true;
                    break;
                }
                if (this.findCasing(0, 0, -z) || this.findCasing(1, 1, -z) || this.findCasing(1, -1, -z) || !this.findCasingAll(0, 0, -z + 1) || !this.findCasing(1, 0, -z) || !this.findCasing(1, 1, -z + 1) || !this.findCasing(1, -1, -z + 1)) continue;
                maxZCheck = maxLength - z;
                minZ = -z;
                validStructure = true;
                break;
            }
            if (!validStructure) {
                this.complete = 0;
                this.problem = CASING_INCOMPLETE;
                this.problemPos = "";
                return false;
            }
            validStructure = false;
            for (y2 = 0; y2 <= maxLength; ++y2) {
                if (this.findCasing(minX, -y2 + 1, minZ) || this.findCasing(minX + 1, -y2, minZ) || this.findCasing(minX, -y2, minZ + 1) || !this.findCasingAll(minX + 1, -y2, minZ + 1) || !this.findCasingAll(minX, -y2 + 1, minZ + 1) || !this.findCasingAll(minX + 1, -y2 + 1, minZ)) continue;
                minY = -y2;
                validStructure = true;
                break;
            }
            if (!validStructure) {
                this.complete = 0;
                this.problem = CASING_INCOMPLETE;
                this.problemPos = "";
                return false;
            }
            validStructure = false;
            for (z = 0; z <= maxZCheck; ++z) {
                if (this.findCasing(minX, minY + 1, z) || this.findCasing(minX + 1, minY, z) || this.findCasing(minX, minY, z - 1) || !this.findCasingAll(minX + 1, minY, z - 1) || !this.findCasingAll(minX, minY + 1, z - 1) || !this.findCasingAll(minX + 1, minY + 1, z)) continue;
                maxZ = z;
                validStructure = true;
                break;
            }
            if (!validStructure) {
                this.complete = 0;
                this.problem = CASING_INCOMPLETE;
                this.problemPos = "";
                return false;
            }
            validStructure = false;
            for (int x2 = 0; x2 <= maxLength; ++x2) {
                if (this.findCasing(minX + x2, minY + 1, minZ) || this.findCasing(minX + x2 - 1, minY, minZ) || this.findCasing(minX + x2, minY, minZ + 1) || !this.findCasingAll(minX + x2 - 1, minY, minZ + 1) || !this.findCasingAll(minX + x2, minY + 1, minZ + 1) || !this.findCasingAll(minX + x2 - 1, minY + 1, minZ)) continue;
                maxX = minX + x2;
                validStructure = true;
                break;
            }
            if (!validStructure) {
                this.complete = 0;
                this.problem = CASING_INCOMPLETE;
                this.problemPos = "";
                return false;
            }
            validStructure = false;
            for (y2 = 0; y2 <= maxLength; ++y2) {
                if (this.findCasing(minX, minY + y2 - 1, minZ) || this.findCasing(minX + 1, minY + y2, minZ) || this.findCasing(minX, minY + y2, minZ + 1) || !this.findCasingAll(minX + 1, minY + y2, minZ + 1) || !this.findCasingAll(minX, minY + y2 - 1, minZ + 1) || !this.findCasingAll(minX + 1, minY + y2 - 1, minZ)) continue;
                maxY = minY + y2;
                validStructure = true;
                break;
            }
            if (!validStructure) {
                this.complete = 0;
                this.problem = CASING_INCOMPLETE;
                this.problemPos = "";
                return false;
            }
            if (minX > 0 || maxX < 0 || minY > 0 || maxY < 0 || minZ > 0 || maxZ < 0 || maxX - minX < 1 || maxY - minY < 1 || maxZ - minZ < 1) {
                this.problem = INVALID_STRUCTURE;
                this.complete = 0;
                this.problemPos = "";
                return false;
            }
            for (z = minZ; z <= maxZ; ++z) {
                for (x = minX; x <= maxX; ++x) {
                    for (y = minY; y <= maxY; ++y) {
                        if (!this.findController(x, y, z) || x == 0 && y == 0 && z == 0) continue;
                        this.problem = EXTRA_CONTROLLER_AT;
                        this.complete = 0;
                        this.problemPosX = x;
                        this.problemPosY = y;
                        this.problemPosZ = z;
                        this.problemPos = POS + " " + BlockPosHelper.stringPos(this.finder.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                }
            }
            for (z = minZ + 1; z <= maxZ - 1; ++z) {
                for (x = minX + 1; x <= maxX - 1; ++x) {
                    if (!(this.findCasing(x, minY, z) || x == 0 && minY == 0 && z == 0)) {
                        this.problem = CASING_INCOMPLETE_AT;
                        this.complete = 0;
                        this.problemPosX = x;
                        this.problemPosY = minY;
                        this.problemPosZ = z;
                        this.problemPos = POS + " " + BlockPosHelper.stringPos(this.finder.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                    if (this.findCasing(x, maxY, z) || x == 0 && maxY == 0 && z == 0) continue;
                    this.problem = CASING_INCOMPLETE_AT;
                    this.complete = 0;
                    this.problemPosX = x;
                    this.problemPosY = maxY;
                    this.problemPosZ = z;
                    this.problemPos = POS + " " + BlockPosHelper.stringPos(this.finder.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                    return false;
                }
            }
            for (y2 = minY + 1; y2 <= maxY - 1; ++y2) {
                for (x = minX + 1; x <= maxX - 1; ++x) {
                    if (!(this.findCasing(x, y2, minZ) || x == 0 && y2 == 0 && minZ == 0)) {
                        this.problem = CASING_INCOMPLETE_AT;
                        this.complete = 0;
                        this.problemPosX = x;
                        this.problemPosY = y2;
                        this.problemPosZ = minZ;
                        this.problemPos = POS + " " + BlockPosHelper.stringPos(this.finder.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                    if (!(this.findCasing(x, y2, maxZ) || x == 0 && y2 == 0 && maxZ == 0)) {
                        this.problem = CASING_INCOMPLETE_AT;
                        this.complete = 0;
                        this.problemPosX = x;
                        this.problemPosY = y2;
                        this.problemPosZ = maxZ;
                        this.problemPos = POS + " " + BlockPosHelper.stringPos(this.finder.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                    if (this.findPort(x, y2, minZ)) {
                        ++portCount;
                    }
                    if (!this.findPort(x, y2, maxZ)) continue;
                    ++portCount;
                }
                for (int z2 = minZ + 1; z2 <= maxZ - 1; ++z2) {
                    if (!(this.findCasing(minX, y2, z2) || minX == 0 && y2 == 0 && z2 == 0)) {
                        this.problem = CASING_INCOMPLETE_AT;
                        this.complete = 0;
                        this.problemPosX = minX;
                        this.problemPosY = y2;
                        this.problemPosZ = z2;
                        this.problemPos = POS + " " + BlockPosHelper.stringPos(this.finder.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                    if (!(this.findCasing(maxX, y2, z2) || maxX == 0 && y2 == 0 && z2 == 0)) {
                        this.problem = CASING_INCOMPLETE_AT;
                        this.complete = 0;
                        this.problemPosX = maxX;
                        this.problemPosY = y2;
                        this.problemPosZ = z2;
                        this.problemPos = POS + " " + BlockPosHelper.stringPos(this.finder.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                    if (this.findPort(minX, y2, z2)) {
                        ++portCount;
                    }
                    if (!this.findPort(maxX, y2, z2)) continue;
                    ++portCount;
                }
            }
            for (z = minZ + 1; z <= maxZ - 1; ++z) {
                for (x = minX + 1; x <= maxX - 1; ++x) {
                    for (y = minY + 1; y <= maxY - 1; ++y) {
                        if (!this.findCasingAll(x, y, z)) continue;
                        this.problem = CASING_IN_INTERIOR_AT;
                        this.complete = 0;
                        this.problemPosX = x;
                        this.problemPosY = y;
                        this.problemPosZ = z;
                        this.problemPos = POS + " " + BlockPosHelper.stringPos(this.finder.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                }
            }
            this.problem = NO_PROBLEM;
            this.complete = 1;
            this.problemPos = "";
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            this.lengthX = maxX + 1 - minX;
            this.lengthY = maxY + 1 - minY;
            this.lengthZ = maxZ + 1 - minZ;
            this.ports = Math.max(1, portCount);
            this.setCapacity();
            return true;
        }
        return this.complete == 1;
    }

    private void setCapacity() {
        this.getEnergyStorage().setStorageCapacity(this.getNewCapacity());
        this.getEnergyStorage().setMaxTransfer(this.getNewCapacity());
    }

    private int getNewCapacity() {
        if (NCMath.atIntLimit(this.getLengthX() * this.getLengthY() * this.getLengthZ(), 64000)) {
            return Integer.MAX_VALUE;
        }
        if (this.getLengthX() <= 0 || this.getLengthY() <= 0 || this.getLengthZ() <= 0) {
            return 64000;
        }
        return 64000 * this.getLengthX() * this.getLengthY() * this.getLengthZ();
    }

    private void run(boolean checkBlocks) {
        double energyThisTick = 0.0;
        double fuelThisTick = 0.0;
        double heatThisTick = 0.0;
        double coolerHeatThisTick = 0.0;
        int cellCount = 0;
        double energyMultThisTick = 0.0;
        double heatMultThisTick = 0.0;
        double baseRF = this.baseProcessPower;
        double baseHeat = this.baseProcessHeat;
        int n = this.ready = this.readyToProcess() && !this.isActivated ? 1 : 0;
        if (checkBlocks) {
            boolean isProcessing = this.isProcessing();
            if (this.complete == 1) {
                for (int z = this.minZ + 1; z <= this.maxZ - 1; ++z) {
                    for (int x = this.minX + 1; x <= this.maxX - 1; ++x) {
                        for (int y = this.minY + 1; y <= this.maxY - 1; ++y) {
                            TileActiveCooler cooler;
                            Tank tank;
                            TileEntity tile;
                            if (this.findCell(x, y, z)) {
                                int extraCells = 0;
                                for (EnumFacing side : EnumFacing.field_82609_l) {
                                    if (!this.findCellOnSide(x, y, z, side) && !this.findModeratorThenCellOnSide(x, y, z, side)) continue;
                                    ++extraCells;
                                }
                                ++cellCount;
                                energyMultThisTick += (double)(extraCells + 1);
                                heatMultThisTick += (double)((extraCells + 1) * (extraCells + 2) / 2);
                                if (this.readyToProcess()) {
                                    energyThisTick += baseRF * (double)(extraCells + 1);
                                    heatThisTick += baseHeat * (double)(extraCells + 1) * (double)(extraCells + 2) / 2.0;
                                }
                                if (isProcessing) {
                                    fuelThisTick += NCConfig.fission_fuel_use;
                                }
                            }
                            if (this.findModerator(x, y, z)) {
                                if (this.readyToProcess()) {
                                    heatMultThisTick += (double)cellCount / 16.0;
                                    heatThisTick += NCConfig.fission_heat_generation * baseRF * (double)cellCount / 16.0;
                                }
                                if (this.cellAdjacent(x, y, z)) {
                                    energyMultThisTick += (double)cellCount / 8.0;
                                    if (this.readyToProcess()) {
                                        energyThisTick += NCConfig.fission_power * baseRF * (double)cellCount / 8.0;
                                    }
                                }
                            }
                            for (int i = 1; i < MetaEnums.CoolerType.values().length; ++i) {
                                if (!this.findCooler(x, y, z, i) || !this.coolerRequirements(x, y, z, i)) continue;
                                coolerHeatThisTick -= MetaEnums.CoolerType.values()[i].getCooling();
                                break;
                            }
                            if (!this.finder.find(x, y, z, NCBlocks.active_cooler) || !((tile = this.field_145850_b.func_175625_s(this.finder.position(x, y, z))) instanceof TileActiveCooler) || (tank = (cooler = (TileActiveCooler)tile).getTanks().get(0)).getFluidAmount() <= 0) continue;
                            double currentHeat = this.heat + (isProcessing ? heatThisTick : 0.0) + coolerHeatThisTick;
                            boolean isInValidPosition = false;
                            for (int i = 1; i < MetaEnums.CoolerType.values().length; ++i) {
                                if (tank.getFluidName() != MetaEnums.CoolerType.values()[i].getFluidName() || !this.coolerRequirements(x, y, z, i)) continue;
                                coolerHeatThisTick -= NCConfig.fission_active_cooling_rate[i - 1] * (double)NCConfig.active_cooler_max_rate / 20.0;
                                isInValidPosition = true;
                                break;
                            }
                            cooler.isActive = isInValidPosition && this.isActivated() && this.readyToProcess();
                        }
                    }
                }
            }
            if (this.complete == 1) {
                this.heatChange = heatThisTick + coolerHeatThisTick;
                this.cooling = coolerHeatThisTick;
                this.cells = cellCount;
                this.efficiency = cellCount == 0 ? 0.0 : 100.0 * energyMultThisTick / (double)cellCount;
                this.heatMult = cellCount == 0 ? 0.0 : 100.0 * heatMultThisTick / (double)cellCount;
                this.processPower = energyThisTick;
                this.speedMultiplier = fuelThisTick;
            } else {
                this.heatChange = 0.0;
                this.cooling = 0.0;
                this.efficiency = 0.0;
                this.heatMult = 0.0;
                this.cells = 0;
                this.processPower = 0.0;
                this.speedMultiplier = 0.0;
            }
        }
        if (this.isProcessing) {
            this.heat = this.heat + this.heatChange >= 0.0 ? (this.heat += this.heatChange) : 0.0;
        } else if (this.ready == 1 || this.complete == 1) {
            this.heat = this.heat + this.cooling >= 0.0 ? (this.heat += this.cooling) : 0.0;
        }
    }

    private void newRun(boolean checkBlocks) {
        double energyThisTick = 0.0;
        double fuelThisTick = 0.0;
        double heatThisTick = 0.0;
        double coolerHeatThisTick = 0.0;
        int cellCount = 0;
        double energyMultThisTick = 0.0;
        double heatMultThisTick = 0.0;
        double baseRF = NCConfig.fission_power * this.baseProcessPower;
        double baseHeat = NCConfig.fission_heat_generation * this.baseProcessHeat;
        double moderatorPowerMultiplier = NCConfig.fission_moderator_extra_power / 6.0;
        double moderatorHeatMultiplier = NCConfig.fission_moderator_extra_heat / 6.0;
        int n = this.ready = this.readyToProcess() && !this.isActivated ? 1 : 0;
        if (checkBlocks) {
            boolean isProcessing = this.isProcessing();
            if (this.complete == 1) {
                for (int z = this.minZ + 1; z <= this.maxZ - 1; ++z) {
                    for (int x = this.minX + 1; x <= this.maxX - 1; ++x) {
                        for (int y = this.minY + 1; y <= this.maxY - 1; ++y) {
                            TileActiveCooler cooler;
                            Tank tank;
                            TileEntity tile;
                            if (this.findCell(x, y, z)) {
                                int extraCells = 0;
                                for (EnumFacing side : EnumFacing.field_82609_l) {
                                    if (!this.findCellOnSide(x, y, z, side) && !this.newFindModeratorThenCellOnSide(x, y, z, side)) continue;
                                    ++extraCells;
                                }
                                ++cellCount;
                                energyMultThisTick += (double)extraCells + 1.0;
                                heatMultThisTick += ((double)extraCells + 1.0) * ((double)extraCells + 2.0) / 2.0;
                                if (this.readyToProcess()) {
                                    energyThisTick += baseRF * ((double)extraCells + 1.0);
                                    heatThisTick += baseHeat * ((double)extraCells + 1.0) * ((double)extraCells + 2.0) / 2.0;
                                }
                                if (isProcessing) {
                                    fuelThisTick += NCConfig.fission_fuel_use;
                                }
                                int moderatorAdjacentCount = this.moderatorAdjacentCount(x, y, z);
                                energyMultThisTick += moderatorPowerMultiplier * (double)moderatorAdjacentCount * ((double)extraCells + 1.0);
                                heatMultThisTick += moderatorHeatMultiplier * (double)moderatorAdjacentCount * ((double)extraCells + 1.0);
                                energyThisTick += baseRF * moderatorPowerMultiplier * (double)moderatorAdjacentCount * ((double)extraCells + 1.0);
                                heatThisTick += baseHeat * moderatorHeatMultiplier * (double)moderatorAdjacentCount * ((double)extraCells + 1.0);
                            }
                            if (this.readyToProcess() && this.findModerator(x, y, z) && !this.cellAdjacent(x, y, z)) {
                                heatThisTick += baseHeat;
                            }
                            for (int i = 1; i < MetaEnums.CoolerType.values().length; ++i) {
                                if (!this.findCooler(x, y, z, i) || !this.coolerRequirements(x, y, z, i)) continue;
                                coolerHeatThisTick -= MetaEnums.CoolerType.values()[i].getCooling();
                                break;
                            }
                            if (!this.finder.find(x, y, z, NCBlocks.active_cooler) || !((tile = this.field_145850_b.func_175625_s(this.finder.position(x, y, z))) instanceof TileActiveCooler) || (tank = (cooler = (TileActiveCooler)tile).getTanks().get(0)).getFluidAmount() <= 0) continue;
                            double currentHeat = this.heat + (isProcessing ? heatThisTick : 0.0) + coolerHeatThisTick;
                            boolean isInValidPosition = false;
                            for (int i = 1; i < MetaEnums.CoolerType.values().length; ++i) {
                                if (tank.getFluidName() != MetaEnums.CoolerType.values()[i].getFluidName() || !this.coolerRequirements(x, y, z, i)) continue;
                                coolerHeatThisTick -= NCConfig.fission_active_cooling_rate[i - 1] * (double)NCConfig.active_cooler_max_rate / 20.0;
                                isInValidPosition = true;
                                break;
                            }
                            cooler.isActive = isInValidPosition && this.isActivated() && this.readyToProcess();
                        }
                    }
                }
            }
            if (this.complete == 1) {
                this.heatChange = heatThisTick + coolerHeatThisTick;
                this.cooling = coolerHeatThisTick;
                this.cells = cellCount;
                this.efficiency = cellCount == 0 ? 0.0 : 100.0 * energyMultThisTick / (double)cellCount;
                this.heatMult = cellCount == 0 ? 0.0 : 100.0 * heatMultThisTick / (double)cellCount;
                this.processPower = energyThisTick;
                this.speedMultiplier = fuelThisTick;
            } else {
                this.heatChange = 0.0;
                this.cooling = 0.0;
                this.efficiency = 0.0;
                this.heatMult = 0.0;
                this.cells = 0;
                this.processPower = 0.0;
                this.speedMultiplier = 0.0;
            }
        }
        if (this.isProcessing) {
            this.heat = this.heat + this.heatChange >= 0.0 ? (this.heat += this.heatChange) : 0.0;
        } else if (this.ready == 1 || this.complete == 1) {
            this.heat = this.heat + this.cooling >= 0.0 ? (this.heat += this.cooling) : 0.0;
        }
    }

    public Object[] getOCReactorLayout() {
        if (ModCheck.openComputersLoaded() && this.complete == 1) {
            this.oc_layout = new Object[this.getLengthX() * this.getLengthY() * this.getLengthZ()];
            for (int z = this.minZ + 1; z <= this.maxZ - 1; ++z) {
                for (int x = this.minX + 1; x <= this.maxX - 1; ++x) {
                    for (int y = this.minY + 1; y <= this.maxY - 1; ++y) {
                        int arrayX = x - this.minX - 1;
                        int arrayY = y - this.minY - 1;
                        int arrayZ = z - this.minZ - 1;
                        IBlockState layoutState = this.field_145850_b.func_180495_p(this.finder.position(x, y, z));
                        String mainName = layoutState.func_177230_c().getRegistryName().toString();
                        int meta = layoutState.func_177230_c().func_176201_c(layoutState);
                        this.oc_layout[arrayX + this.getLengthX() * arrayY + this.getLengthX() * this.getLengthY() * arrayZ] = new Object[]{new Object[]{x, y, z}, new Object[]{mainName, meta}};
                    }
                }
            }
        } else {
            this.oc_layout = new Object[0];
        }
        return this.oc_layout;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("processPower", this.processPower);
        nbt.func_74780_a("speedMultiplier", this.speedMultiplier);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74780_a("heat", this.heat);
        nbt.func_74780_a("cooling", this.cooling);
        nbt.func_74780_a("efficiency", this.efficiency);
        nbt.func_74768_a("cells", this.cells);
        nbt.func_74768_a("minX", this.minX);
        nbt.func_74768_a("minY", this.minY);
        nbt.func_74768_a("minZ", this.minZ);
        nbt.func_74768_a("maxX", this.maxX);
        nbt.func_74768_a("maxY", this.maxY);
        nbt.func_74768_a("maxZ", this.maxZ);
        nbt.func_74768_a("lengthX", this.lengthX);
        nbt.func_74768_a("lengthY", this.lengthY);
        nbt.func_74768_a("lengthZ", this.lengthZ);
        nbt.func_74780_a("heatChange", this.heatChange);
        nbt.func_74780_a("heatMult", this.heatMult);
        nbt.func_74768_a("complete", this.complete);
        nbt.func_74768_a("ready", this.ready);
        nbt.func_74778_a("problem", this.problem);
        nbt.func_74778_a("problemPos", this.problemPos);
        nbt.func_74768_a("problemPosX", this.problemPosX);
        nbt.func_74768_a("problemPosY", this.problemPosY);
        nbt.func_74768_a("problemPosZ", this.problemPosZ);
        nbt.func_74757_a("newRules", this.newRules);
        nbt.func_74768_a("ports", this.ports);
        nbt.func_74768_a("currentEnergyStored", this.currentEnergyStored);
        nbt.func_74757_a("isActivated", this.isActivated);
        nbt.func_74757_a("computerActivated", this.computerActivated);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        this.lengthX = nbt.func_74762_e("lengthX");
        this.lengthY = nbt.func_74762_e("lengthY");
        this.lengthZ = nbt.func_74762_e("lengthZ");
        this.getEnergyStorage().setStorageCapacity(this.getNewCapacity());
        super.readAll(nbt);
        this.processPower = nbt.func_74769_h("processPower");
        this.speedMultiplier = nbt.func_74769_h("speedMultiplier");
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.heat = nbt.func_74769_h("heat");
        this.cooling = nbt.func_74769_h("cooling");
        this.efficiency = nbt.func_74769_h("efficiency");
        this.cells = nbt.func_74762_e("cells");
        this.minX = nbt.func_74762_e("minX");
        this.minY = nbt.func_74762_e("minY");
        this.minZ = nbt.func_74762_e("minZ");
        this.maxX = nbt.func_74762_e("maxX");
        this.maxY = nbt.func_74762_e("maxY");
        this.maxZ = nbt.func_74762_e("maxZ");
        this.heatChange = nbt.func_74769_h("heatChange");
        this.heatMult = nbt.func_74769_h("heatMult");
        this.complete = nbt.func_74762_e("complete");
        this.ready = nbt.func_74762_e("ready");
        this.problem = nbt.func_74779_i("problem");
        this.problemPos = nbt.func_74779_i("problemPos");
        this.problemPosX = nbt.func_74762_e("problemPosX");
        this.problemPosY = nbt.func_74762_e("problemPosY");
        this.problemPosZ = nbt.func_74762_e("problemPosZ");
        this.newRules = nbt.func_74767_n("newRules");
        this.ports = nbt.func_74762_e("ports");
        this.currentEnergyStored = nbt.func_74762_e("currentEnergyStored");
        this.isActivated = nbt.func_74767_n("isActivated");
        this.computerActivated = nbt.func_74767_n("computerActivated");
    }

    @Override
    public int getGuiID() {
        return 100;
    }

    @Override
    public Set<EntityPlayer> getPlayersToUpdate() {
        return this.playersToUpdate;
    }

    @Override
    public FissionUpdatePacket getGuiUpdatePacket() {
        return new FissionUpdatePacket(this.field_174879_c, this.time, this.getEnergyStored(), this.baseProcessTime, this.baseProcessPower, this.heat, this.cooling, this.efficiency, this.cells, this.speedMultiplier, this.lengthX, this.lengthY, this.lengthZ, this.heatChange, this.complete, this.ready, this.problemPosX, this.problemPosY, this.problemPosZ, this.heatMult, this.hasConsumed, this.computerActivated);
    }

    @Override
    public void onGuiPacket(FissionUpdatePacket message) {
        this.time = message.time;
        this.getEnergyStorage().setEnergyStored(message.energyStored);
        this.baseProcessTime = message.baseProcessTime;
        this.baseProcessPower = message.baseProcessPower;
        this.heat = message.heat;
        this.cooling = message.cooling;
        this.efficiency = message.efficiency;
        this.cells = message.cells;
        this.speedMultiplier = message.speedMultiplier;
        this.lengthX = message.lengthX;
        this.lengthY = message.lengthY;
        this.lengthZ = message.lengthZ;
        this.heatChange = message.heatChange;
        this.complete = message.complete;
        this.ready = message.ready;
        this.problemPosX = message.problemPosX;
        this.problemPosY = message.problemPosY;
        this.problemPosZ = message.problemPosZ;
        this.heatMult = message.heatMult;
        this.hasConsumed = message.hasConsumed;
        this.computerActivated = message.computerActivated;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= Math.max((double)(this.lengthX * this.lengthX + this.lengthY * this.lengthY + this.lengthZ * this.lengthZ), 64.0);
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_fission_reactor";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isComplete(Context context, Arguments args) {
        return new Object[]{this.complete == 1};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isProcessing(Context context, Arguments args) {
        return new Object[]{this.isProcessing};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getProblem(Context context, Arguments args) {
        return new Object[]{this.problem};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthX(Context context, Arguments args) {
        return new Object[]{this.getLengthX()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthY(Context context, Arguments args) {
        return new Object[]{this.getLengthY()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthZ(Context context, Arguments args) {
        return new Object[]{this.getLengthZ()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyStored(Context context, Arguments args) {
        return new Object[]{this.getEnergyStored()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxEnergyStored(Context context, Arguments args) {
        return new Object[]{this.getMaxEnergyStored()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyChange(Context context, Arguments args) {
        return new Object[]{this.energyChange};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getCurrentProcessTime(Context context, Arguments args) {
        return new Object[]{this.time};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getHeatLevel(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxHeatLevel(Context context, Arguments args) {
        return new Object[]{this.getMaxHeat()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEfficiency(Context context, Arguments args) {
        return new Object[]{this.efficiency};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getHeatMultiplier(Context context, Arguments args) {
        return new Object[]{this.heatMult};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFissionFuelTime(Context context, Arguments args) {
        return new Object[]{this.recipe != null ? this.baseProcessTime : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFissionFuelPower(Context context, Arguments args) {
        return new Object[]{this.baseProcessPower};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFissionFuelHeat(Context context, Arguments args) {
        return new Object[]{this.baseProcessHeat};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFissionFuelName(Context context, Arguments args) {
        return new Object[]{this.getFuelName()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessTime(Context context, Arguments args) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.recipe != null ? (this.cells == 0 ? this.baseProcessTime : this.baseProcessTime / (double)this.cells) : 0.0;
        return objectArray;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessPower(Context context, Arguments args) {
        return new Object[]{this.processPower};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessHeat(Context context, Arguments args) {
        return new Object[]{this.heatChange};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorCoolingRate(Context context, Arguments args) {
        return new Object[]{this.cooling};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorLayout(Context context, Arguments args) {
        return this.getOCReactorLayout();
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] activate(Context context, Arguments args) {
        this.computerActivated = true;
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] deactivate(Context context, Arguments args) {
        this.computerActivated = false;
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] forceUpdate(Context context, Arguments args) {
        this.refreshMultiblock(true);
        return new Object[0];
    }

    public static class Old
    extends TileFissionController {
        public Old() {
            super(false);
        }
    }

    public static class New
    extends TileFissionController {
        public New() {
            super(true);
        }
    }
}

