/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import nc.ModCheck;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.IngredientSorption;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import nc.tile.generator.IFluidGenerator;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileFluidGenerator
extends TileEnergyFluidSidedInventory
implements IFluidGenerator {
    public final int defaultProcessTime;
    public final int defaultProcessPower;
    public double baseProcessTime = 1.0;
    public double baseProcessPower = 0.0;
    public double baseProcessRadiation = 0.0;
    public double processPower = 0.0;
    public double speedMultiplier = 1.0;
    public final int fluidInputSize;
    public final int fluidOutputSize;
    public final int otherSlotsSize;
    public double time;
    public boolean isProcessing;
    public boolean hasConsumed;
    public boolean canProcessInputs;
    public final NCRecipes.Type recipeType;
    protected ProcessorRecipe recipe;
    protected Set<EntityPlayer> playersToUpdate;

    public TileFluidGenerator(String name, int fluidInSize, int fluidOutSize, int otherSize, @Nonnull List<Integer> fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluids, int capacity, @Nonnull NCRecipes.Type recipeType) {
        super(name, otherSize, capacity, ITileEnergy.energyConnectionAll(EnergyConnection.OUT), fluidCapacity, fluidCapacity, tankSorptions, allowedFluids, ITileFluid.fluidConnectionAll(FluidConnection.BOTH));
        this.fluidInputSize = fluidInSize;
        this.fluidOutputSize = fluidOutSize;
        this.otherSlotsSize = otherSize;
        this.setTanksShared(fluidInSize > 1);
        this.defaultProcessTime = 1;
        this.defaultProcessPower = 0;
        this.recipeType = recipeType;
        this.playersToUpdate = new HashSet<EntityPlayer>();
    }

    public static List<Integer> defaultTankCapacities(int capacity, int inSize, int outSize) {
        ArrayList<Integer> tankCapacities = new ArrayList<Integer>();
        for (int i = 0; i < 2 * inSize + outSize; ++i) {
            tankCapacities.add(capacity);
        }
        return tankCapacities;
    }

    public static List<TankSorption> defaultTankSorptions(int inSize, int outSize) {
        int i;
        ArrayList<TankSorption> tankSorptions = new ArrayList<TankSorption>();
        for (i = 0; i < inSize; ++i) {
            tankSorptions.add(TankSorption.IN);
        }
        for (i = 0; i < outSize; ++i) {
            tankSorptions.add(TankSorption.OUT);
        }
        for (i = 0; i < inSize; ++i) {
            tankSorptions.add(TankSorption.NON);
        }
        return tankSorptions;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.isProcessing = this.isProcessing();
            this.hasConsumed = this.hasConsumed();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateGenerator();
    }

    public abstract void updateGenerator();

    public void updateBlockType() {
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
        this.setState(this.isProcessing);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    @Override
    public void refreshRecipe() {
        if (this.recipe == null || !this.recipe.matchingInputs(new ArrayList<ItemStack>(), this.getFluidInputs(this.hasConsumed))) {
            this.recipe = (ProcessorRecipe)this.getRecipeHandler().getRecipeFromInputs(new ArrayList<ItemStack>(), this.getFluidInputs(this.hasConsumed));
        }
        this.consumeInputs();
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs(false);
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs(true);
    }

    public abstract boolean setRecipeStats();

    public boolean isProcessing() {
        return this.readyToProcess() && this.getIsRedstonePowered();
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasConsumed;
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (this.getTanks().get(i + this.fluidInputSize + this.fluidOutputSize).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcessInputs(boolean justProduced) {
        if (!this.setRecipeStats()) {
            if (this.hasConsumed) {
                for (Tank tank : this.getFluidInputs(true)) {
                    tank.setFluidStored(null);
                }
                this.hasConsumed = false;
            }
            return false;
        }
        if (!justProduced && this.time >= this.baseProcessTime) {
            return true;
        }
        return this.canProduceProducts();
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize() <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) continue;
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual(fluidProduct.getStack())) {
                return false;
            }
            if (this.getVoidExcessFluidOutputs() || this.getTanks().get(j + this.fluidInputSize).getFluidAmount() + fluidProduct.getMaxStackSize() <= this.getTanks().get(j + this.fluidInputSize).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs() {
        int i;
        if (this.hasConsumed || this.recipe == null) {
            return;
        }
        List<Integer> fluidInputOrder = this.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < this.fluidInputSize; ++i) {
            if (this.getTanks().get(i + this.fluidInputSize + this.fluidOutputSize).isEmpty()) continue;
            this.getTanks().get(i + this.fluidInputSize + this.fluidOutputSize).setFluid(null);
        }
        for (i = 0; i < this.fluidInputSize; ++i) {
            IFluidIngredient fluidIngredient = this.getFluidIngredients().get(fluidInputOrder.get(i));
            if (fluidIngredient.getMaxStackSize() > 0) {
                this.getTanks().get(i + this.fluidInputSize + this.fluidOutputSize).setFluidStored(new FluidStack(this.getTanks().get(i).getFluid(), fluidIngredient.getMaxStackSize()));
                this.getTanks().get(i).changeFluidAmount(-fluidIngredient.getMaxStackSize());
            }
            if (!this.getTanks().get(i).isEmpty()) continue;
            this.getTanks().get(i).setFluid(null);
        }
        this.hasConsumed = true;
    }

    public void process() {
        this.time += this.speedMultiplier;
        this.getEnergyStorage().changeEnergyStored((int)this.processPower);
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.speedMultiplier);
        if (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        if (!this.setRecipeStats()) {
            this.time = 0.0;
            if (this.getEmptyUnusableTankInputs()) {
                for (int i = 0; i < this.fluidInputSize; ++i) {
                    this.getTanks().get(i).setFluid(null);
                }
            }
        } else {
            this.time = MathHelper.func_151237_a((double)(this.time - oldProcessTime), (double)0.0, (double)this.baseProcessTime);
        }
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
    }

    public void produceProducts() {
        for (int i = this.fluidInputSize + this.fluidOutputSize; i < 2 * this.fluidInputSize + this.fluidOutputSize; ++i) {
            this.getTanks().get(i).setFluid(null);
        }
        if (!this.hasConsumed || this.recipe == null) {
            return;
        }
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getNextStackSize() <= 0) continue;
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) {
                this.getTanks().get(j + this.fluidInputSize).setFluidStored(fluidProduct.getNextStack());
                continue;
            }
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual(fluidProduct.getStack())) continue;
            this.getTanks().get(j + this.fluidInputSize).changeFluidAmount(fluidProduct.getNextStackSize());
        }
        this.hasConsumed = false;
    }

    @Override
    public ProcessorRecipeHandler getRecipeHandler() {
        return this.recipeType.getRecipeHandler();
    }

    @Override
    public ProcessorRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public List<Tank> getFluidInputs(boolean consumed) {
        return consumed ? this.getTanks().subList(this.fluidInputSize + this.fluidOutputSize, 2 * this.fluidInputSize + this.fluidOutputSize) : this.getTanks().subList(0, this.fluidInputSize);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipe.fluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipe.fluidProducts();
    }

    @Override
    public List<Integer> getFluidInputOrder() {
        ArrayList<Integer> fluidInputOrder = new ArrayList<Integer>();
        List<IFluidIngredient> fluidIngredients = this.recipe.fluidIngredients();
        for (int i = 0; i < this.fluidInputSize; ++i) {
            int position = -1;
            for (int j = 0; j < fluidIngredients.size(); ++j) {
                if (!fluidIngredients.get(j).matches((Object)this.getFluidInputs(false).get(i), IngredientSorption.INPUT)) continue;
                position = j;
                break;
            }
            if (position == -1) {
                return AbstractRecipeHandler.INVALID;
            }
            fluidInputOrder.add(position);
        }
        return fluidInputOrder;
    }

    public void func_70296_d() {
        this.refreshRecipe();
        this.refreshActivity();
        super.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public boolean isNextToFill(FluidStack resource, int tankNumber) {
        if (tankNumber >= this.fluidInputSize) {
            return false;
        }
        if (!this.getTanksShared()) {
            return true;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (tankNumber == i || !this.getTanks().get(i).canFill() || this.getTanks().get(i).getFluid() == null || !this.getTanks().get(i).getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
    }
}

