/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.init.NCItems;
import nc.network.tile.ProcessorUpdatePacket;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.IngredientSorption;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.IGui;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.processor.IFluidProcessor;
import nc.tile.processor.IProcessor;
import nc.tile.processor.IUpgradable;
import nc.util.ArrayHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class TileFluidProcessor
extends TileEnergyFluidSidedInventory
implements IFluidProcessor,
IGui<ProcessorUpdatePacket>,
IUpgradable {
    public final int[] slots;
    public final int defaultProcessTime;
    public final int defaultProcessPower;
    public double baseProcessTime;
    public double baseProcessPower;
    public double baseProcessRadiation;
    public final int fluidInputSize;
    public final int fluidOutputSize;
    public double time;
    public boolean isProcessing;
    public boolean canProcessInputs;
    public final boolean shouldLoseProgress;
    public final boolean hasUpgrades;
    public final int guiID;
    public final NCRecipes.Type recipeType;
    protected ProcessorRecipe recipe;
    protected Set<EntityPlayer> playersToUpdate;

    public TileFluidProcessor(String name, int fluidInSize, int fluidOutSize, @Nonnull List<Integer> fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluids, int time, int power, boolean shouldLoseProgress, @Nonnull NCRecipes.Type recipeType) {
        this(name, fluidInSize, fluidOutSize, fluidCapacity, tankSorptions, allowedFluids, time, power, shouldLoseProgress, false, recipeType, 1);
    }

    public TileFluidProcessor(String name, int fluidInSize, int fluidOutSize, @Nonnull List<Integer> fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluids, int time, int power, boolean shouldLoseProgress, @Nonnull NCRecipes.Type recipeType, int guiID) {
        this(name, fluidInSize, fluidOutSize, fluidCapacity, tankSorptions, allowedFluids, time, power, shouldLoseProgress, true, recipeType, guiID);
    }

    public TileFluidProcessor(String name, int fluidInSize, int fluidOutSize, @Nonnull List<Integer> fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluids, int time, int power, boolean shouldLoseProgress, boolean upgrades, @Nonnull NCRecipes.Type recipeType, int guiID) {
        super(name, upgrades ? 2 : 0, IProcessor.getBaseCapacity(recipeType), power != 0 ? ITileEnergy.energyConnectionAll(EnergyConnection.IN) : ITileEnergy.energyConnectionAll(EnergyConnection.NON), fluidCapacity, fluidCapacity, tankSorptions, allowedFluids, ITileFluid.fluidConnectionAll(FluidConnection.BOTH));
        this.fluidInputSize = fluidInSize;
        this.fluidOutputSize = fluidOutSize;
        this.defaultProcessTime = time;
        this.defaultProcessPower = power;
        this.baseProcessTime = time;
        this.baseProcessPower = power;
        this.shouldLoseProgress = shouldLoseProgress;
        this.hasUpgrades = upgrades;
        this.guiID = guiID;
        this.setTanksShared(fluidInSize > 1);
        this.recipeType = recipeType;
        this.slots = ArrayHelper.increasingArray(this.hasUpgrades ? 2 : 0);
        this.playersToUpdate = new HashSet<EntityPlayer>();
    }

    public static List<Integer> defaultTankCapacities(int capacity, int inSize, int outSize) {
        ArrayList<Integer> tankCapacities = new ArrayList<Integer>();
        for (int i = 0; i < inSize + outSize; ++i) {
            tankCapacities.add(capacity);
        }
        return tankCapacities;
    }

    public static List<TankSorption> defaultTankSorptions(int inSize, int outSize) {
        int i;
        ArrayList<TankSorption> tankSorptions = new ArrayList<TankSorption>();
        for (i = 0; i < inSize; ++i) {
            tankSorptions.add(TankSorption.IN);
        }
        for (i = 0; i < outSize; ++i) {
            tankSorptions.add(TankSorption.OUT);
        }
        return tankSorptions;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.refreshUpgrades();
            this.isProcessing = this.isProcessing();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateProcessor();
    }

    public void updateProcessor() {
        if (!this.field_145850_b.field_72995_K) {
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            boolean shouldUpdate = false;
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
                if (this.time > 0.0 && !this.getIsRedstonePowered()) {
                    this.loseProgress();
                }
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
                this.updateBlockType();
                this.sendUpdateToAllPlayers();
            }
            this.sendUpdateToListeningPlayers();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void updateBlockType() {
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
        this.setState(this.isProcessing);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    @Override
    public void refreshRecipe() {
        if (this.recipe == null || !this.recipe.matchingInputs(new ArrayList<ItemStack>(), this.getFluidInputs())) {
            this.recipe = (ProcessorRecipe)this.getRecipeHandler().getRecipeFromInputs(new ArrayList<ItemStack>(), this.getFluidInputs());
        }
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs(false);
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs(true);
    }

    public double getProcessTime() {
        return Math.max(1.0, this.baseProcessTime / this.getSpeedMultiplier());
    }

    public int getProcessPower() {
        return Math.min(Integer.MAX_VALUE, (int)(this.baseProcessPower * this.getPowerMultiplier()));
    }

    public double getProcessEnergy() {
        return this.getProcessTime() * (double)this.getProcessPower();
    }

    public boolean setRecipeStats() {
        if (this.recipe == null) {
            this.baseProcessTime = this.defaultProcessTime;
            this.baseProcessPower = this.defaultProcessPower;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = this.recipe.getProcessTime(this.defaultProcessTime);
        this.baseProcessPower = this.recipe.getProcessPower(this.defaultProcessPower);
        this.baseProcessRadiation = this.recipe.getProcessRadiation();
        return true;
    }

    public void setCapacityFromSpeed() {
        this.getEnergyStorage().setStorageCapacity((int)MathHelper.func_151237_a((double)((double)(NCConfig.machine_update_rate * this.defaultProcessPower) * this.getPowerMultiplier()), (double)IProcessor.getBaseCapacity(this.recipeType), (double)2.147483647E9));
        this.getEnergyStorage().setMaxTransfer((int)MathHelper.func_151237_a((double)((double)(NCConfig.machine_update_rate * this.defaultProcessPower) * this.getPowerMultiplier()), (double)IProcessor.getBaseCapacity(this.recipeType), (double)2.147483647E9));
    }

    private int getMaxEnergyModified() {
        return ModCheck.galacticraftLoaded() ? this.getMaxEnergyStored() - 16 : this.getMaxEnergyStored();
    }

    public boolean isProcessing() {
        return this.readyToProcess() && !this.getIsRedstonePowered();
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasSufficientEnergy();
    }

    public boolean canProcessInputs(boolean justProduced) {
        if (!this.setRecipeStats()) {
            return false;
        }
        if (!justProduced && this.time >= this.baseProcessTime) {
            return true;
        }
        return this.canProduceProducts();
    }

    public boolean hasSufficientEnergy() {
        return this.time <= 0.0 && (this.getProcessEnergy() >= (double)this.getMaxEnergyModified() && this.getEnergyStored() >= this.getMaxEnergyModified() || this.getProcessEnergy() <= (double)this.getEnergyStored()) || this.time > 0.0 && this.getEnergyStored() >= this.getProcessPower();
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize() <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) continue;
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual(fluidProduct.getStack())) {
                return false;
            }
            if (this.getVoidExcessFluidOutputs() || this.getTanks().get(j + this.fluidInputSize).getFluidAmount() + fluidProduct.getMaxStackSize() <= this.getTanks().get(j + this.fluidInputSize).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void process() {
        this.time += this.getSpeedMultiplier();
        this.getEnergyStorage().changeEnergyStored(-this.getProcessPower());
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.getSpeedMultiplier());
        if (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        if (!this.setRecipeStats()) {
            this.time = 0.0;
            if (this.getEmptyUnusableTankInputs()) {
                for (int i = 0; i < this.fluidInputSize; ++i) {
                    this.getTanks().get(i).setFluid(null);
                }
            }
        } else {
            this.time = MathHelper.func_151237_a((double)(this.time - oldProcessTime), (double)0.0, (double)this.baseProcessTime);
        }
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
    }

    public void produceProducts() {
        if (this.recipe == null) {
            return;
        }
        List<Integer> fluidInputOrder = this.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            int fluidIngredientStackSize = this.getFluidIngredients().get(fluidInputOrder.get(i)).getMaxStackSize();
            if (fluidIngredientStackSize > 0) {
                this.getTanks().get(i).changeFluidAmount(-fluidIngredientStackSize);
            }
            if (this.getTanks().get(i).getFluidAmount() > 0) continue;
            this.getTanks().get(i).setFluidStored(null);
        }
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize() <= 0) continue;
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) {
                this.getTanks().get(j + this.fluidInputSize).setFluidStored(fluidProduct.getNextStack());
                continue;
            }
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual(fluidProduct.getStack())) continue;
            this.getTanks().get(j + this.fluidInputSize).changeFluidAmount(fluidProduct.getNextStackSize());
        }
    }

    public void loseProgress() {
        this.time = MathHelper.func_151237_a((double)(this.time - 1.5 * this.getSpeedMultiplier()), (double)0.0, (double)this.baseProcessTime);
    }

    @Override
    public ProcessorRecipeHandler getRecipeHandler() {
        return this.recipeType.getRecipeHandler();
    }

    @Override
    public ProcessorRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public List<Tank> getFluidInputs() {
        return this.getTanks().subList(0, this.fluidInputSize);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipe.fluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipe.fluidProducts();
    }

    @Override
    public List<Integer> getFluidInputOrder() {
        ArrayList<Integer> fluidInputOrder = new ArrayList<Integer>();
        List<IFluidIngredient> fluidIngredients = this.recipe.fluidIngredients();
        for (int i = 0; i < this.fluidInputSize; ++i) {
            int position = -1;
            for (int j = 0; j < fluidIngredients.size(); ++j) {
                if (!fluidIngredients.get(j).matches((Object)this.getFluidInputs().get(i), IngredientSorption.INPUT)) continue;
                position = j;
                break;
            }
            if (position == -1) {
                return AbstractRecipeHandler.INVALID;
            }
            fluidInputOrder.add(position);
        }
        return fluidInputOrder;
    }

    @Override
    public boolean hasUpgrades() {
        return this.hasUpgrades;
    }

    @Override
    public int getSpeedUpgradeSlot() {
        return 0;
    }

    @Override
    public int getEnergyUpgradeSlot() {
        return 1;
    }

    @Override
    public int getSpeedCount() {
        return this.hasUpgrades ? ((ItemStack)this.inventoryStacks.get(this.getSpeedUpgradeSlot())).func_190916_E() + 1 : 1;
    }

    @Override
    public int getEnergyCount() {
        return this.hasUpgrades ? Math.min(this.getSpeedCount(), ((ItemStack)this.inventoryStacks.get(this.getEnergyUpgradeSlot())).func_190916_E() + 1) : 1;
    }

    @Override
    public void refreshUpgrades() {
        this.setCapacityFromSpeed();
    }

    @Override
    public int getEUSourceTier() {
        return 1;
    }

    @Override
    public int getEUSinkTier() {
        return 4;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (!(this.field_145850_b.field_72995_K || slot != this.getSpeedUpgradeSlot() && slot != this.getEnergyUpgradeSlot())) {
            this.refreshUpgrades();
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (!(this.field_145850_b.field_72995_K || slot != this.getSpeedUpgradeSlot() && slot != this.getEnergyUpgradeSlot())) {
            this.refreshUpgrades();
        }
    }

    public void func_70296_d() {
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshUpgrades();
        super.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        if (this.hasUpgrades && stack.func_77973_b() == NCItems.upgrade) {
            if (slot == this.getSpeedUpgradeSlot()) {
                return stack.func_77960_j() == 0;
            }
            if (slot == this.getEnergyUpgradeSlot()) {
                return stack.func_77960_j() == 1;
            }
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.slots;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public boolean isNextToFill(FluidStack resource, int tankNumber) {
        if (tankNumber >= this.fluidInputSize) {
            return false;
        }
        if (!this.getTanksShared()) {
            return true;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (tankNumber == i || !this.getTanks().get(i).canFill() || this.getTanks().get(i).getFluid() == null || !this.getTanks().get(i).getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
    }

    @Override
    public int getGuiID() {
        return this.guiID;
    }

    @Override
    public Set<EntityPlayer> getPlayersToUpdate() {
        return this.playersToUpdate;
    }

    @Override
    public ProcessorUpdatePacket getGuiUpdatePacket() {
        return new ProcessorUpdatePacket(this.field_174879_c, this.time, this.getEnergyStored(), this.baseProcessTime, this.baseProcessPower);
    }

    @Override
    public void onGuiPacket(ProcessorUpdatePacket message) {
        this.time = message.time;
        this.getEnergyStorage().setEnergyStored(message.energyStored);
        this.baseProcessTime = message.baseProcessTime;
        this.baseProcessPower = message.baseProcessPower;
    }
}

