/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import javax.annotation.Nullable;
import nc.block.tile.processor.BlockNuclearFurnace;
import nc.capability.radiation.IRadiationSource;
import nc.capability.radiation.RadiationSource;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energyFluid.IBufferable;
import nc.tile.inventory.ITileInventory;
import nc.util.OreDictHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileNuclearFurnace
extends TileEntity
implements ITickable,
ISidedInventory,
ITileInventory,
IInterfaceable,
IBufferable {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 1};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private IRadiationSource radiation;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileNuclearFurnace() {
        this.radiation = new RadiationSource();
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.furnaceItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.furnaceItemStacks.get(slot);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)amount);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && nc.util.ItemStackHelper.areItemStackTagsEqual(stack, itemstack);
        this.furnaceItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    @Override
    public NonNullList<ItemStack> getInventoryStacks() {
        return this.furnaceItemStacks;
    }

    @Override
    public IRadiationSource getRadiationSource() {
        return this.radiation;
    }

    public String func_70005_c_() {
        return "nuclearcraft.container.nuclear_furnace";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public static void registerFixesFurnace(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileNuclearFurnace.class, new String[]{"Items"}));
    }

    public void readRadiation(NBTTagCompound nbt) {
        if (nbt.func_74764_b("radiationLevel")) {
            this.getRadiationSource().setRadiationLevel(nbt.func_74769_h("radiationLevel"));
        }
    }

    public NBTTagCompound writeRadiation(NBTTagCompound nbt) {
        nbt.func_74780_a("radiationLevel", this.getRadiationSource().getRadiationLevel());
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.furnaceItemStacks);
        this.furnaceBurnTime = nbt.func_74762_e("BurnTime");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.totalCookTime = nbt.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileNuclearFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
        this.readRadiation(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("BurnTime", (int)((short)this.furnaceBurnTime));
        nbt.func_74768_a("CookTime", (int)((short)this.cookTime));
        nbt.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.furnaceItemStacks);
        this.writeRadiation(nbt);
        return nbt;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
            this.getRadiationSource().setRadiationLevel(1.5E-6);
        } else {
            this.getRadiationSource().setRadiationLevel(0.0);
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(1);
            if (this.isBurning() || !itemstack.func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileNuclearFurnace.getItemBurnTime(itemstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.furnaceItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                BlockNuclearFurnace.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
                this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, true);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime() {
        return 10;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.furnaceItemStacks.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        int result = itemstack1.func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack1.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(0);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            ItemStack itemstack2 = (ItemStack)this.furnaceItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstack.func_77960_j() == 1 && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() && ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (OreDictHelper.isOreMember(stack, "blockThorium")) {
            return 3200;
        }
        if (OreDictHelper.isOreMember(stack, "blockUranium")) {
            return 3200;
        }
        if (OreDictHelper.isOreMember(stack, "ingotThorium")) {
            return 320;
        }
        if (OreDictHelper.isOreMember(stack, "ingotUranium")) {
            return 320;
        }
        if (OreDictHelper.isOreMember(stack, "dustThorium")) {
            return 320;
        }
        if (OreDictHelper.isOreMember(stack, "dustUranium")) {
            return 320;
        }
        if (OreDictHelper.isOreMember(stack, "ingotThoriumOxide")) {
            return 480;
        }
        if (OreDictHelper.isOreMember(stack, "ingotUraniumOxide")) {
            return 480;
        }
        if (OreDictHelper.isOreMember(stack, "dustThoriumOxide")) {
            return 480;
        }
        if (OreDictHelper.isOreMember(stack, "dustUraniumOxide")) {
            return 480;
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileNuclearFurnace.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        return TileNuclearFurnace.isItemFuel(stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_174890_g() {
        return 4;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public void func_174888_l() {
        this.furnaceItemStacks.clear();
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145838_q() != null) {
            return new TextComponentTranslation(this.func_145838_q().func_149732_F(), new Object[0]);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return this.radiation != null;
        }
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return (T)this.radiation;
        }
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public World getTileWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getTilePos() {
        return this.field_174879_c;
    }

    @Override
    public void markTileDirty() {
        this.func_70296_d();
    }

    @Override
    public Block getTileBlockType() {
        return this.func_145838_q();
    }

    @Override
    public void setState(boolean isActive) {
    }

    @Override
    public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
    }

    @Override
    public boolean getIsRedstonePowered() {
        return false;
    }

    @Override
    public void setIsRedstonePowered(boolean isRedstonePowered) {
    }

    @Override
    public boolean getAlternateComparator() {
        return false;
    }

    @Override
    public void setAlternateComparator(boolean alternate) {
    }
}

