/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.quantum;

import nc.tile.NCTile;
import nc.util.Complex;
import net.minecraft.nbt.NBTTagCompound;

public class TileSpin
extends NCTile {
    public double measuredSpin = -0.5;
    public double phi = 0.0;
    public double theta = 180.0;
    public int isMeasured;
    public Complex[] stateVector = this.getStateFromAngles(this.phi, this.theta);

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isMeasured > 0) {
            --this.isMeasured;
        }
        if (this.isMeasured < 0) {
            this.isMeasured = 0;
        }
    }

    public void setStateFromAngles(double phi, double theta) {
        this.stateVector = this.getStateFromAngles(phi, theta);
    }

    public Complex[] getStateFromAngles(double phi, double theta) {
        return new Complex[]{Complex.exp(new Complex(0.0, phi * Math.PI / 180.0)).multiply(Math.sin(theta * Math.PI / 360.0)), new Complex(Math.cos(theta * Math.PI / 360.0), 0.0)};
    }

    public boolean isMeasured() {
        return this.isMeasured > 0;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("measuredSpin", this.measuredSpin);
        nbt.func_74780_a("phi", this.phi);
        nbt.func_74780_a("theta", this.theta);
        nbt.func_74780_a("stateVectorUpRe", this.stateVector[0].re());
        nbt.func_74780_a("stateVectorUpIm", this.stateVector[0].im());
        nbt.func_74780_a("stateVectorDownRe", this.stateVector[1].re());
        nbt.func_74780_a("stateVectorDownIm", this.stateVector[1].im());
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.measuredSpin = nbt.func_74769_h("measuredSpin");
        this.phi = nbt.func_74769_h("phi");
        this.theta = nbt.func_74769_h("theta");
        this.stateVector = new Complex[]{new Complex(nbt.func_74769_h("stateVectorUpRe"), nbt.func_74769_h("stateVectorUpIm")), new Complex(nbt.func_74769_h("stateVectorDownRe"), nbt.func_74769_h("stateVectorDownIm"))};
    }
}

