/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class ItemStackHelper {
    public static ItemStack fixItemStack(Object object) {
        if (object instanceof ItemStack) {
            ItemStack stack = ((ItemStack)object).func_77946_l();
            if (stack.func_190916_E() == 0) {
                stack.func_190920_e(1);
            }
            return stack;
        }
        if (object instanceof Item) {
            return new ItemStack((Item)object, 1);
        }
        if (!(object instanceof Block)) {
            throw new RuntimeException(String.format("Invalid ItemStack: %s", object));
        }
        return new ItemStack((Block)object, 1);
    }

    public static ItemStack blockStateToStack(IBlockState state) {
        if (state == null) {
            return ItemStack.field_190927_a;
        }
        Block block = state.func_177230_c();
        if (block == null) {
            return ItemStack.field_190927_a;
        }
        int meta = block.func_176201_c(state);
        return new ItemStack(block, 1, meta);
    }

    public static Block getBlockFromStack(ItemStack stack) {
        if (stack.func_190926_b() || stack == null) {
            return null;
        }
        int meta = stack.func_77960_j();
        Item item = stack.func_77973_b();
        if (!ItemBlock.class.isAssignableFrom(item.getClass())) {
            return null;
        }
        ItemBlock itemBlock = (ItemBlock)item;
        return itemBlock.func_179223_d();
    }

    public static ItemStack changeStackSize(ItemStack stack, int size) {
        ItemStack newStack = stack.func_77946_l();
        newStack.func_190920_e(size);
        return newStack.func_77946_l();
    }

    public static String stackName(ItemStack stack) {
        return stack.func_77973_b().func_77658_a() + ":" + stack.func_77960_j();
    }

    public static String stackListNames(List<ItemStack> list) {
        String names = "";
        for (ItemStack stack : list) {
            names = names + ", " + ItemStackHelper.stackName(stack);
        }
        return names.substring(2);
    }

    public static boolean areItemStackTagsEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
            if (stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
                return false;
            }
            return stackA.func_77978_p() == null || stackA.func_77978_p().equals((Object)stackB.func_77978_p());
        }
        return false;
    }
}

