/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import nc.recipe.IRecipe;
import nc.recipe.IngredientSorption;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.FluidRegHelper;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RecipeHelper {
    public static boolean containsItemIngredient(List<IItemIngredient> list, IItemIngredient ingredient) {
        for (IItemIngredient i : list) {
            if (i == null || !i.matches(ingredient, IngredientSorption.NEUTRAL)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFluidIngredient(List<IFluidIngredient> list, IFluidIngredient ingredient) {
        for (IFluidIngredient i : list) {
            if (i == null || !i.matches(ingredient, IngredientSorption.NEUTRAL)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack fixItemStack(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ItemStack) {
            ItemStack stack = ((ItemStack)object).func_77946_l();
            if (stack.func_190916_E() <= 0) {
                stack.func_190920_e(1);
            }
            return stack;
        }
        if (object instanceof Item) {
            return new ItemStack((Item)object, 1);
        }
        if (!(object instanceof Block)) {
            throw new RuntimeException(String.format("Invalid ItemStack: %s", object));
        }
        return new ItemStack((Block)object, 1);
    }

    public static FluidStack fixFluidStack(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof FluidStack) {
            FluidStack fluidstack = ((FluidStack)object).copy();
            if (fluidstack.amount <= 0) {
                fluidstack.amount = 1000;
            }
            return fluidstack;
        }
        if (!(object instanceof Fluid)) {
            throw new RuntimeException(String.format("Invalid FluidStack: %s", object));
        }
        return new FluidStack((Fluid)object, 1000);
    }

    public static OreIngredient oreStackFromString(String name) {
        if (OreDictHelper.oreExists(name)) {
            return new OreIngredient(name, 1);
        }
        return null;
    }

    public static FluidIngredient fluidStackFromString(String name) {
        if (FluidRegHelper.fluidExists(name)) {
            return new FluidIngredient(name, 1000);
        }
        return null;
    }

    public static List<List<ItemStack>> getItemInputLists(List<IItemIngredient> ingredientList) {
        ArrayList<List<ItemStack>> values = new ArrayList<List<ItemStack>>();
        ingredientList.forEach(ingredient -> values.add(ingredient.getInputStackList()));
        return values;
    }

    public static List<List<FluidStack>> getFluidInputLists(List<IFluidIngredient> ingredientList) {
        ArrayList<List<FluidStack>> values = new ArrayList<List<FluidStack>>();
        ingredientList.forEach(ingredient -> values.add(ingredient.getInputStackList()));
        return values;
    }

    public static List<List<ItemStack>> getItemOutputLists(List<IItemIngredient> ingredientList) {
        ArrayList<List<ItemStack>> values = new ArrayList<List<ItemStack>>();
        ingredientList.forEach(ingredient -> values.add(RecipeHelper.getItemOutputStackList(ingredient)));
        return values;
    }

    public static List<List<FluidStack>> getFluidOutputLists(List<IFluidIngredient> ingredientList) {
        ArrayList<List<FluidStack>> values = new ArrayList<List<FluidStack>>();
        ingredientList.forEach(ingredient -> values.add(RecipeHelper.getFluidOutputStackList(ingredient)));
        return values;
    }

    public static List<ItemStack> getItemOutputStackList(IItemIngredient ingredient) {
        if (ingredient instanceof ChanceItemIngredient) {
            return ingredient.getOutputStackList();
        }
        return Lists.newArrayList((Object[])new ItemStack[]{ingredient.getStack()});
    }

    public static List<FluidStack> getFluidOutputStackList(IFluidIngredient ingredient) {
        if (ingredient instanceof ChanceFluidIngredient) {
            return ingredient.getOutputStackList();
        }
        return Lists.newArrayList((Object[])new FluidStack[]{ingredient.getStack()});
    }

    @Nullable
    public static List<ItemStack> getItemOutputList(List<IItemIngredient> list) {
        if (list.contains(null)) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        list.forEach(ingredient -> stacks.add(ingredient.getStack()));
        if (stacks.contains(null)) {
            return new ArrayList<ItemStack>();
        }
        return stacks;
    }

    @Nullable
    public static List<FluidStack> getFluidOutputList(List<IFluidIngredient> list) {
        if (list.contains(null)) {
            return new ArrayList<FluidStack>();
        }
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        list.forEach(ingredient -> stacks.add(ingredient.getStack()));
        if (stacks.contains(null)) {
            return new ArrayList<FluidStack>();
        }
        return stacks;
    }

    @Nullable
    public static ItemStack getItemStackFromIngredientList(List<IItemIngredient> list, int pos) {
        if (!list.isEmpty() && pos < list.size()) {
            IItemIngredient object = list.get(pos);
            return object.getStack();
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidStackFromIngredientList(List<IFluidIngredient> list, int pos) {
        if (!list.isEmpty() && pos < list.size()) {
            IFluidIngredient object = list.get(pos);
            return object.getStack();
        }
        return null;
    }

    public static boolean matchingIngredients(IngredientSorption sorption, List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List items, List fluids, boolean shapeless) {
        ArrayList<IItemIngredient> itemIngredientsMatch = new ArrayList<IItemIngredient>(itemIngredients);
        ArrayList<IFluidIngredient> fluidIngredientsMatch = new ArrayList<IFluidIngredient>(fluidIngredients);
        if (itemIngredients.size() != items.size() || fluidIngredients.size() != fluids.size()) {
            return false;
        }
        int pos = -1;
        if (!items.isEmpty()) {
            block0: for (Object item : items) {
                ++pos;
                if (shapeless) {
                    for (IItemIngredient itemIngredient : new ArrayList<IItemIngredient>(itemIngredientsMatch)) {
                        if (!itemIngredient.matches(item, sorption)) continue;
                        itemIngredientsMatch.remove(itemIngredient);
                        continue block0;
                    }
                } else if (itemIngredients.get(pos).matches(item, sorption)) {
                    itemIngredientsMatch.remove(itemIngredients.get(pos));
                    continue;
                }
                return false;
            }
        }
        pos = -1;
        if (!fluids.isEmpty()) {
            block2: for (Object fluid : fluids) {
                ++pos;
                if (fluid instanceof Tank) {
                    fluid = ((Tank)((Object)fluid)).getFluid();
                }
                if (shapeless) {
                    for (IFluidIngredient fluidIngredient : new ArrayList<IFluidIngredient>(fluidIngredientsMatch)) {
                        if (!fluidIngredient.matches(fluid, sorption)) continue;
                        fluidIngredientsMatch.remove(fluidIngredient);
                        continue block2;
                    }
                } else if (fluidIngredients.get(pos).matches(fluid, sorption)) {
                    fluidIngredientsMatch.remove(fluidIngredients.get(pos));
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public static List<String> getItemIngredientNames(List<IItemIngredient> ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (IItemIngredient ingredient : ingredientList) {
            if (ingredient == null || ingredient instanceof EmptyItemIngredient) {
                ingredientNames.add("null");
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize() + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static List<String> getFluidIngredientNames(List<IFluidIngredient> ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (IFluidIngredient ingredient : ingredientList) {
            if (ingredient == null || ingredient instanceof EmptyFluidIngredient) {
                ingredientNames.add("null");
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize() + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static String getAllIngredientNamesConcat(List<IItemIngredient> itemIngredientList, List<IFluidIngredient> fluidIngredientList) {
        return StringHelper.stringListConcat(RecipeHelper.getItemIngredientNames(itemIngredientList), RecipeHelper.getFluidIngredientNames(fluidIngredientList));
    }

    public static String getRecipeString(List<IItemIngredient> itemIngredientList, List<IFluidIngredient> fluidIngredientList, List<IItemIngredient> itemProductList, List<IFluidIngredient> fluidProductList) {
        return RecipeHelper.getAllIngredientNamesConcat(itemIngredientList, fluidIngredientList) + " -> " + RecipeHelper.getAllIngredientNamesConcat(itemProductList, fluidProductList);
    }

    public static String getRecipeString(IRecipe recipe) {
        if (recipe == null) {
            return "nullRecipe";
        }
        return RecipeHelper.getRecipeString(recipe.itemIngredients(), recipe.fluidIngredients(), recipe.itemProducts(), recipe.fluidProducts());
    }

    public static List<String> buildItemIngredientNames(List ingredientList, NCRecipes.Type recipeType) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (Object obj : ingredientList) {
            if (obj == null) {
                ingredientNames.add("null");
                continue;
            }
            if (!(obj instanceof IItemIngredient)) {
                obj = recipeType.getRecipeHandler().buildItemIngredient(obj);
            }
            IItemIngredient ingredient = (IItemIngredient)obj;
            ingredientNames.add(ingredient.getMaxStackSize() + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static List<String> buildFluidIngredientNames(List ingredientList, NCRecipes.Type recipeType) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (Object obj : ingredientList) {
            if (obj == null) {
                ingredientNames.add("null");
                continue;
            }
            if (!(obj instanceof IFluidIngredient)) {
                obj = recipeType.getRecipeHandler().buildFluidIngredient(obj);
            }
            IFluidIngredient ingredient = (IFluidIngredient)obj;
            ingredientNames.add(ingredient.getMaxStackSize() + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static List<List<String>> validFluids(NCRecipes.Type recipeType) {
        return RecipeHelper.validFluids(recipeType, new ArrayList<String>());
    }

    public static List<List<String>> validFluids(NCRecipes.Type recipeType, List<String> exceptions) {
        return RecipeHelper.validFluids(recipeType.getRecipeHandler(), exceptions);
    }

    private static List<List<String>> validFluids(ProcessorRecipeHandler recipes, List<String> exceptions) {
        int i;
        int fluidInputSize = recipes.fluidInputSize;
        int fluidOutputSize = recipes.fluidOutputSize;
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (Object fluid : FluidRegistry.getRegisteredFluids().values()) {
            fluidStackList.add(new FluidStack((Fluid)fluid, 1000));
        }
        ArrayList<String> fluidNameList = new ArrayList<String>();
        for (FluidStack fluidStack : fluidStackList) {
            String fluidName = fluidStack.getFluid().getName();
            if (!recipes.isValidFluidInput(fluidStack) || exceptions.contains(fluidName)) continue;
            fluidNameList.add(fluidName);
        }
        ArrayList<List<String>> allowedFluidLists = new ArrayList<List<String>>();
        for (i = 0; i < fluidInputSize; ++i) {
            allowedFluidLists.add(fluidNameList);
        }
        for (i = fluidInputSize; i < fluidInputSize + fluidOutputSize; ++i) {
            allowedFluidLists.add(null);
        }
        return allowedFluidLists;
    }

    public static OreIngredient getOreStackFromItems(List<ItemStack> stackList, int stackSize) {
        if (stackList.isEmpty() || stackList == null) {
            return null;
        }
        String oreName = OreDictHelper.getOreNameFromStacks(stackList);
        if (oreName == "Unknown") {
            return null;
        }
        return new OreIngredient(oreName, stackSize);
    }

    public static InventoryCrafting fakeCrafter(int width, int height) {
        return new FakeCrafting(width, height);
    }

    private static class FakeCrafting
    extends InventoryCrafting {
        private static final FakeCraftingContainer FAKE_CONTAINER = new FakeCraftingContainer();

        private FakeCrafting(int width, int height) {
            super((Container)FAKE_CONTAINER, width, height);
        }

        private static class FakeCraftingContainer
        extends Container {
            private FakeCraftingContainer() {
            }

            public void func_75130_a(IInventory inventory) {
            }

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }
    }
}

