/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import nc.util.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class RegistryHelper {
    public static Block getBlock(String location) {
        ResourceLocation resLoc = new ResourceLocation(location);
        if (!Loader.isModLoaded((String)resLoc.func_110624_b())) {
            return null;
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(resLoc);
    }

    public static Item getItem(String location) {
        ResourceLocation resLoc = new ResourceLocation(location);
        if (!Loader.isModLoaded((String)resLoc.func_110624_b())) {
            return null;
        }
        return (Item)ForgeRegistries.ITEMS.getValue(resLoc);
    }

    public static ItemStack blockStackFromRegistry(String location, int stackSize) {
        return RegistryHelper.getBlock(RegistryHelper.removeMeta(location)) == null ? null : new ItemStack(RegistryHelper.getBlock(RegistryHelper.removeMeta(location)), stackSize, RegistryHelper.getStackMeta(location));
    }

    public static ItemStack blockStackFromRegistry(String location) {
        return RegistryHelper.blockStackFromRegistry(location, 1);
    }

    public static ItemStack itemStackFromRegistry(String location, int stackSize) {
        return RegistryHelper.getItem(RegistryHelper.removeMeta(location)) == null ? null : new ItemStack(RegistryHelper.getItem(RegistryHelper.removeMeta(location)), stackSize, RegistryHelper.getStackMeta(location));
    }

    public static ItemStack itemStackFromRegistry(String location) {
        return RegistryHelper.itemStackFromRegistry(location, 1);
    }

    public static Biome biomeFromRegistry(String location) {
        ResourceLocation resLoc = new ResourceLocation(location);
        if (!Loader.isModLoaded((String)resLoc.func_110624_b())) {
            return null;
        }
        return (Biome)ForgeRegistries.BIOMES.getValue(resLoc);
    }

    public static int getStackMeta(String location) {
        if (StringUtils.countMatches((CharSequence)location, (char)':') < 2) {
            return 0;
        }
        return Integer.parseInt(location.substring(location.lastIndexOf(58) + 1));
    }

    public static String removeMeta(String location) {
        if (StringUtils.countMatches((CharSequence)location, (char)':') < 2) {
            return location;
        }
        return StringHelper.starting(location, location.lastIndexOf(58));
    }

    public static String getModID(ItemStack stack) {
        if (stack == null) {
            return "";
        }
        Item item = stack.func_77973_b();
        if (item == null || item.delegate == null || item.delegate.name() == null || item.delegate.name().func_110624_b() == null) {
            return "";
        }
        return item.delegate.name().func_110624_b();
    }
}

