/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.blocks;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import omtteam.omlib.api.IHasItemBlock;
import omtteam.omlib.util.WorldUtil;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.blocks.BlockTurretBaseAddon;
import omtteam.openmodularturrets.handler.OMTConfigHandler;
import omtteam.openmodularturrets.items.blocks.ItemBlockBaseAddon;
import omtteam.openmodularturrets.tileentity.BaseAddon;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class BlockBaseAddon
extends BlockTurretBaseAddon
implements IHasItemBlock {
    public static final PropertyInteger MODEL = PropertyInteger.func_177719_a((String)"model", (int)0, (int)1);
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockBaseAddon() {
        super(Material.field_151592_s);
        this.func_149647_a(OpenModularTurrets.modularTurretsTab);
        if (!OMTConfigHandler.turretBreakable) {
            this.func_149722_s();
        }
        this.func_149752_b(3.0f);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149663_c("base_addon");
        this.setRegistryName("openmodularturrets", "base_addon");
    }

    public ItemBlock getItemBlock(Block block) {
        return new ItemBlockBaseAddon(block);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MODEL, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MODEL);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MODEL, FACING});
    }

    public static AxisAlignedBB getBoundingBoxFromFacing(EnumFacing facing) {
        return BlockTurretBaseAddon.getBoundingBoxFromFacing(facing);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BaseAddon te = (BaseAddon)worldIn.func_175625_s(pos);
        if (te != null) {
            return state.func_177226_a((IProperty)FACING, (Comparable)te.getOrientation());
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BaseAddon();
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState blockState = this.func_176221_a(state, source, pos);
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        return BlockBaseAddon.getBoundingBoxFromFacing(facing);
    }

    @Override
    public AxisAlignedBB getBoundingBoxFromFacing(EnumFacing facing, World world, BlockPos pos) {
        return BlockBaseAddon.getBoundingBoxFromFacing(facing).func_186670_a(pos);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand.equals((Object)EnumHand.OFF_HAND)) {
            return true;
        }
        BaseAddon baseAddon = (BaseAddon)worldIn.func_175625_s(pos);
        if (baseAddon == null) {
            return true;
        }
        TurretBase base = baseAddon.getBase();
        if (base == null) {
            worldIn.func_175655_b(pos, true);
            return true;
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BaseAddon baseAddon = (BaseAddon)worldIn.func_175625_s(pos);
        if (baseAddon != null) {
            baseAddon.setSide();
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)worldIn, (BlockPos)pos)) {
            if (!(tileEntity instanceof TurretBase)) continue;
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.dropItems(worldIn, pos);
            super.func_180663_b(worldIn, pos, state);
        }
    }
}

