/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.gui.containers.ContainerDishwasher;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.tileentity.TileEntityFurniture;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;

public class TileEntityDishwasher
extends TileEntityFurniture
implements ISidedInventory,
ITickable {
    private Random rand = new Random();
    private static final int[] slots_top = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] slots_bottom = new int[]{0, 1, 2, 3, 4, 5, 6};
    private static final int[] slots_sides = new int[]{6};
    private boolean washing = false;
    public boolean superMode = false;
    public int progress = 0;
    public int timeRemaining = 0;
    private int timer = 0;

    public TileEntityDishwasher() {
        super("diswasher", 7);
    }

    public void startWashing() {
        if (this.canWash()) {
            if (this.timeRemaining == 0) {
                this.superMode = ((ItemStack)this.inventory.get(6)).func_77973_b() == FurnitureItems.SUPER_SOAPY_WATER;
                this.inventory.set(6, (Object)new ItemStack(((ItemStack)this.inventory.get(6)).func_77973_b().func_77668_q()));
                this.timeRemaining = 5000;
            }
            this.washing = true;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
        }
    }

    public void stopWashing() {
        this.progress = 0;
        this.washing = false;
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
    }

    public boolean canWash() {
        if (((ItemStack)this.inventory.get(6)).func_190926_b() && this.timeRemaining == 0) {
            return false;
        }
        if (!((ItemStack)this.inventory.get(6)).func_190926_b() && this.timeRemaining == 0) {
            return TileEntityDishwasher.isFuel((ItemStack)this.inventory.get(6));
        }
        for (int i = 0; i < 6; ++i) {
            RecipeData data;
            if (((ItemStack)this.inventory.get(i)).func_190926_b() || (data = RecipeAPI.getDishwasherRecipeFromInput((ItemStack)this.inventory.get(i))) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isWashing() {
        return this.washing;
    }

    public static boolean isFuel(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() == FurnitureItems.SOAPY_WATER || stack.func_77973_b() == FurnitureItems.SUPER_SOAPY_WATER;
    }

    public void func_73660_a() {
        if (this.washing) {
            if (!this.canWash()) {
                this.washing = false;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                return;
            }
            if (this.canRepair()) {
                for (int i = 0; i < 6; ++i) {
                    if (this.inventory.get(i) == ItemStack.field_190927_a || ((ItemStack)this.inventory.get(i)).func_77958_k() - ((ItemStack)this.inventory.get(i)).func_77952_i() == ((ItemStack)this.inventory.get(i)).func_77958_k()) continue;
                    ((ItemStack)this.inventory.get(i)).func_77964_b(((ItemStack)this.inventory.get(i)).func_77952_i() - 1);
                }
            }
            --this.timeRemaining;
            if (this.timeRemaining <= 0) {
                if (this.inventory.get(4) != ItemStack.field_190927_a) {
                    if (((ItemStack)this.inventory.get(4)).func_77973_b() == FurnitureItems.SOAPY_WATER) {
                        this.superMode = false;
                        this.inventory.set(4, (Object)new ItemStack(FurnitureItems.SOAPY_WATER.func_77668_q()));
                        this.timeRemaining = 5000;
                    } else if (((ItemStack)this.inventory.get(4)).func_77973_b() == FurnitureItems.SUPER_SOAPY_WATER) {
                        this.superMode = true;
                        this.inventory.set(4, (Object)new ItemStack(FurnitureItems.SUPER_SOAPY_WATER.func_77668_q()));
                        this.timeRemaining = 5000;
                    }
                } else {
                    this.timeRemaining = 0;
                    this.progress = 0;
                    this.washing = false;
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                }
            }
            ++this.progress;
            if (this.timer == 19) {
                this.timer = 0;
            }
            if (this.timer == 0) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), FurnitureSounds.dishwasher, SoundCategory.BLOCKS, 0.75f, 1.0f);
            }
            ++this.timer;
        }
    }

    public boolean canRepair() {
        return this.progress % (this.superMode ? 20 : 50) == 0;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.washing = tagCompound.func_74767_n("Washing");
        this.superMode = tagCompound.func_74767_n("SuperMode");
        this.progress = tagCompound.func_74762_e("Progress");
        this.timeRemaining = tagCompound.func_74762_e("Remaining");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("Washing", this.washing);
        tagCompound.func_74757_a("SuperMode", this.superMode);
        tagCompound.func_74768_a("Progress", this.progress);
        tagCompound.func_74768_a("Remaining", this.timeRemaining);
        return tagCompound;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        int target = ContainerDishwasher.toolToSlot(stack);
        return target == -1 || slot == target;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return slots_top;
        }
        if (side == EnumFacing.DOWN) {
            return slots_bottom;
        }
        return slots_sides;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        if (this.func_174893_q_()) {
            return false;
        }
        if (side == EnumFacing.UP) {
            return RecipeAPI.getDishwasherRecipeFromInput(stack) != null;
        }
        return side != EnumFacing.DOWN && TileEntityDishwasher.isFuel(stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return side == EnumFacing.DOWN && !TileEntityDishwasher.isFuel(stack) && stack.func_77952_i() == 0 && !this.func_174893_q_();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184281_d(playerIn);
        return new ContainerDishwasher((IInventory)playerInventory, this);
    }
}

