/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import ic2.api.classic.addon.IC2Plugin;
import ic2.api.classic.addon.IModModul;
import ic2.core.IC2;
import ic2.core.entity.IC2DamageSource;
import ic2.core.entity.IC2Potion;
import ic2.core.entity.boat.EntityCarbonBoat;
import ic2.core.entity.boat.EntityElectricBoat;
import ic2.core.entity.boat.EntityRubberBoat;
import ic2.core.entity.explosion.EntityDynamite;
import ic2.core.entity.explosion.EntityITNT;
import ic2.core.entity.explosion.EntityNuke;
import ic2.core.entity.misc.EntityMiningLaser;
import ic2.core.entity.misc.EntityTrackingMiningLaser;
import ic2.core.inventory.base.IHasGui;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.events.EntityEventHandlers;
import ic2.core.util.helpers.AddonModifier;
import ic2.core.util.misc.IC2Addon;
import ic2.core.util.misc.ModulLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class Platform {
    Map<ModulLoader.Modul, ModContainer> containers = new LinkedHashMap<ModulLoader.Modul, ModContainer>();

    public void preInit() {
    }

    public void init() {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("ic2", "Dynamite"), EntityDynamite.class, (String)"Dynamite", (int)0, (Object)IC2.getInstance(), (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("ic2", "Itnt"), EntityITNT.class, (String)"Itnt", (int)1, (Object)IC2.getInstance(), (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("ic2", "Nuke"), EntityNuke.class, (String)"Nuke", (int)2, (Object)IC2.getInstance(), (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("ic2", "rubberBoat"), EntityRubberBoat.class, (String)"rubberBoat", (int)3, (Object)IC2.getInstance(), (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("ic2", "carbonBoat"), EntityCarbonBoat.class, (String)"carbonBoat", (int)4, (Object)IC2.getInstance(), (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("ic2", "electricBoat"), EntityElectricBoat.class, (String)"electricBoat", (int)7, (Object)IC2.getInstance(), (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("ic2", "MiningLaser"), EntityMiningLaser.class, (String)"MiningLaser", (int)8, (Object)IC2.getInstance(), (int)160, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("ic2", "TrackingMiningLaser"), EntityTrackingMiningLaser.class, (String)"TrackingMiningLaser", (int)9, (Object)IC2.getInstance(), (int)160, (int)1, (boolean)true);
        IC2DamageSource.init();
        IC2Potion.init();
    }

    public void postInit() {
        if (this.isSimulating() && IC2.config.getFlag("ElytraServer") || this.isRendering() && IC2.config.getFlag("ElytraClient")) {
            MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandlers.ElytraEventHandler());
        }
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandlers.StatAdvancementTracker());
        AddonModifier.modify();
        Ic2Lang.getInstance().init();
    }

    public void onGameLoaded() {
    }

    public boolean isSimulating() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public boolean isRendering() {
        return !this.isSimulating();
    }

    public void displayError(String error) {
        FMLLog.getLogger().info("IndustrialCraft 2 Error\n\n=== IndustrialCraft 2 Error ===\n\n" + error);
        throw new RuntimeException(("IndustrialCraft 2 Error\n\n=== IndustrialCraft 2 Error ===\n\n" + error + "\n\n===============================\n").replace("\n", System.getProperty("line.separator")));
    }

    public EntityPlayer getPlayerInstance() {
        return null;
    }

    public World getWorld(int dim) {
        return DimensionManager.getWorld((int)dim);
    }

    public World getClientWorld() {
        return null;
    }

    public void messagePlayer(EntityPlayer player, String message) {
        player.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    public void messagePlayer(EntityPlayer player, LocaleComp comp) {
        player.func_145747_a(comp.createComponent());
    }

    public void messagePlayer(EntityPlayer player, LocaleComp comp, Object ... obj) {
        player.func_145747_a(comp.createComponent(obj));
    }

    public void messagePlayer(EntityPlayer player, List<Tuple<LocaleComp, Object[]>> obj) {
        TextComponentString text = new TextComponentString("");
        for (Tuple<LocaleComp, Object[]> entry : obj) {
            text.func_150257_a(((LocaleComp)entry.func_76341_a()).createComponent((Object[])entry.func_76340_b()));
        }
        player.func_145747_a((ITextComponent)text);
    }

    public void messagePlayer(EntityPlayer player, TextFormatting color, LocaleComp comp) {
        ITextComponent text = comp.createComponent();
        text.func_150256_b().func_150238_a(color);
        player.func_145747_a(text);
    }

    public void messagePlayer(EntityPlayer player, TextFormatting color, LocaleComp comp, Object ... obj) {
        ITextComponent text = comp.createComponent(obj);
        text.func_150256_b().func_150238_a(color);
        player.func_145747_a(text);
    }

    public boolean isPVP() {
        return this.getServer().func_71219_W();
    }

    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public boolean isOp(UUID id) {
        PlayerList list = this.getServer().func_184103_al();
        EntityPlayerMP mp = list.func_177451_a(id);
        if (mp == null) {
            return false;
        }
        return list.func_152603_m().func_187452_a(mp.func_146103_bH()) >= this.getServer().func_110455_j();
    }

    public File getMinecraftDir() {
        return new File(".");
    }

    public void removePotion(EntityLivingBase entity, Potion potion) {
        entity.func_184589_d(potion);
    }

    public void resetPlayerInAirTime(Entity player) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        ObfuscationReflectionHelper.setPrivateValue(NetHandlerPlayServer.class, (Object)((EntityPlayerMP)player).field_71135_a, (Object)0, (String[])new String[]{"field_147365_f", "floatingTickCount"});
        ObfuscationReflectionHelper.setPrivateValue(NetHandlerPlayServer.class, (Object)((EntityPlayerMP)player).field_71135_a, (Object)0, (String[])new String[]{"field_184346_E", "vehicleFloatingTickCount"});
    }

    public void updatePlayerUsingItem(EntityPlayer player, ItemStack stack) {
        ObfuscationReflectionHelper.setPrivateValue(EntityLivingBase.class, (Object)player, (Object)stack, (String[])new String[]{"activeItemStack", "field_184627_bm"});
    }

    public boolean launchGui(EntityPlayer player, IHasGui inventory, EnumHand hand) {
        if (player instanceof EntityPlayerMP && inventory != null && inventory.hasGui(player)) {
            EntityPlayerMP entityPlayerMp = (EntityPlayerMP)player;
            entityPlayerMp.func_71117_bO();
            entityPlayerMp.func_71128_l();
            IC2.network.get().initiateGuiDisplay(entityPlayerMp, hand, inventory, entityPlayerMp.field_71139_cq);
            player.field_71070_bA = inventory.getGuiContainer(player);
            player.field_71070_bA.field_75152_c = entityPlayerMp.field_71139_cq;
            player.field_71070_bA.func_75132_a((IContainerListener)entityPlayerMp);
            return true;
        }
        return false;
    }

    public boolean launchGuiClient(EntityPlayer player, IHasGui inventory) {
        return false;
    }

    public boolean canStartMod() {
        return true;
    }

    public GameProfile getSessionProfile() {
        return null;
    }

    public boolean isPlayer(UUID id) {
        return true;
    }

    public long getSeed() {
        return 1L;
    }

    public void loadPack(ModulLoader.Modul modul) {
        ModContainer container;
        ModMetadata meta;
        ModMetadata modMetadata = meta = modul instanceof IModModul ? ((IModModul)((Object)modul)).createModMetadata() : null;
        if (meta == null) {
            meta = new ModMetadata();
            IC2Plugin plugin = modul.getPlugin();
            meta.modId = plugin.id().toLowerCase(Locale.ROOT);
            meta.version = plugin.version();
            meta.name = plugin.name();
        }
        meta.parentMod = container = Loader.instance().activeModContainer();
        IC2Addon addon = new IC2Addon(modul, meta);
        container.getMetadata().childMods.add(addon);
        this.containers.put(modul, (ModContainer)addon);
        this.loadLanguage((ModContainer)addon);
    }

    public void storeMods() {
        try {
            LinkedHashMap<String, ModContainer> mods = new LinkedHashMap<String, ModContainer>();
            mods.putAll((Map)ReflectionHelper.getPrivateValue(Loader.class, (Object)Loader.instance(), (String[])new String[]{"namedMods"}));
            for (ModContainer data : this.containers.values()) {
                mods.put(data.getModId().toLowerCase(Locale.ROOT), data);
            }
            ReflectionHelper.setPrivateValue(Loader.class, (Object)Loader.instance(), (Object)ImmutableMap.copyOf(mods), (String[])new String[]{"namedMods"});
            ArrayList<ModContainer> list = new ArrayList<ModContainer>();
            list.addAll(Loader.instance().getModList());
            list.addAll(this.containers.values());
            ReflectionHelper.setPrivateValue(Loader.class, (Object)Loader.instance(), (Object)ImmutableList.copyOf(list), (String[])new String[]{"mods"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reloadLang() {
    }

    /*
     * Exception decompiling
     */
    protected void loadLanguage(ModContainer container) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ModContainer getModData(ModulLoader.Modul modul, ModContainer unpresent) {
        return this.containers.getOrDefault(modul, unpresent);
    }
}

