/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import com.mojang.authlib.GameProfile;
import ic2.api.classic.addon.IC2Plugin;
import ic2.api.classic.addon.IModModul;
import ic2.api.classic.addon.IModul;
import ic2.core.IC2;
import ic2.core.Platform;
import ic2.core.audio.GuiChoseAudioManager;
import ic2.core.block.machine.high.TileEntityElectricEnchanter;
import ic2.core.block.machine.high.TileEntityPlasmafier;
import ic2.core.block.personal.tile.TileEntityPersonalChest;
import ic2.core.block.render.tile.RenderComparator;
import ic2.core.block.render.tile.RenderElectricEnchanter;
import ic2.core.block.render.tile.RenderPersonalChest;
import ic2.core.block.render.tile.RenderPlasmafier;
import ic2.core.block.wiring.tile.TileEntityAdvComparator;
import ic2.core.energy.render.EnergyNetRenderer;
import ic2.core.entity.boat.EntityCarbonBoat;
import ic2.core.entity.boat.EntityElectricBoat;
import ic2.core.entity.boat.EntityRubberBoat;
import ic2.core.entity.explosion.EntityDynamite;
import ic2.core.entity.explosion.EntityIC2Explosive;
import ic2.core.entity.misc.EntityMiningLaser;
import ic2.core.entity.misc.EntityTrackingMiningLaser;
import ic2.core.entity.render.RenderClassicBoat;
import ic2.core.entity.render.RenderCrossed;
import ic2.core.entity.render.RenderExplosiveBlock;
import ic2.core.entity.render.RenderFlyingItem;
import ic2.core.entity.render.RenderOldClassicBoat;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiIC2ErrorScreen;
import ic2.core.item.render.TileEntityIC2StackRenderer;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.registry.Ic2People;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.SubIconManager;
import ic2.core.util.events.ElectricToolTipManager;
import ic2.core.util.helpers.IC2Colors;
import ic2.core.util.misc.IC2Addon;
import ic2.core.util.misc.ModulLoader;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenOptionsSounds;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PlatformClient
extends Platform {
    static long seed = 0L;
    static Minecraft mc;
    public static boolean open;
    List<IResourcePack> defaultPacks;

    @Override
    public void preInit() {
        super.preInit();
        mc = Minecraft.func_71410_x();
        try {
            this.defaultPacks = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)mc, (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
        }
        catch (Exception e) {
            e.printStackTrace();
            this.defaultPacks = new ArrayList<IResourcePack>();
        }
    }

    @Override
    public void init() {
        super.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new SubIconManager.ForgeEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ElectricToolTipManager());
        this.onRegisterRender();
        EnergyNetRenderer.instance.init();
    }

    @Override
    public void postInit() {
        super.postInit();
        IC2Colors color = new IC2Colors();
        mc.func_184125_al().func_186722_a((IBlockColor)color, new Block[]{Ic2States.rubberLeaves.func_177230_c(), Ic2States.copperCable.func_177230_c(), Ic2States.texturedWall.func_177230_c(), Ic2States.luminator.func_177230_c()});
        mc.getItemColors().func_186730_a((IItemColor)color, new Item[]{Ic2Items.rubberLeaves.func_77973_b(), Ic2Items.obscurator.func_77973_b(), Ic2Items.quantumBoots.func_77973_b(), Ic2Items.quantumLeggings.func_77973_b(), Ic2Items.quantumChest.func_77973_b(), Ic2Items.quantumHelmet.func_77973_b(), Ic2Items.quantumJetplate.func_77973_b(), Ic2Items.quantumNuclearJetplate.func_77973_b()});
        IReloadableResourceManager manager = (IReloadableResourceManager)mc.func_110442_L();
        manager.func_110542_a((IResourceManagerReloadListener)new Ic2Models.ModelReloader());
        manager.func_110542_a((IResourceManagerReloadListener)new Ic2Lang.LangReloader());
    }

    @Override
    public void onGameLoaded() {
        super.onGameLoaded();
        TileEntityItemStackRenderer.field_147719_a = new TileEntityIC2StackRenderer(TileEntityItemStackRenderer.field_147719_a);
    }

    @Override
    public void reloadLang() {
        Minecraft.func_71410_x().func_110436_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void loadPack(ModulLoader.Modul mod) {
        ModContainer container;
        File file = mod.getSource();
        IModul modul = mod.getModul();
        IC2Plugin plugin = mod.getPlugin();
        FolderResourcePack pack = file.isDirectory() ? new FolderResourcePack(file) : new FileResourcePack(file);
        this.defaultPacks.add((IResourcePack)pack);
        IResourceManager manager = mc.func_110442_L();
        if (manager instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)manager).func_110545_a((IResourcePack)pack);
        }
        ModMetadata data = null;
        if (modul instanceof IModModul) {
            data = ((IModModul)modul).createModMetadata();
        }
        if (data == null) {
            try {
                Method met = ReflectionHelper.findMethod(AbstractResourcePack.class, (String)"getInputStreamByName", (String)"func_110591_a", (Class[])new Class[]{String.class});
                InputStream stream = (InputStream)met.invoke((Object)pack, "mcmod.info");
                String name = plugin.id().toLowerCase(Locale.ROOT);
                data = MetadataCollection.from((InputStream)stream, (String)name).getMetadataForId(name, null);
                stream.close();
            }
            catch (Exception met) {
                // empty catch block
            }
        }
        if (data == null) {
            data = new ModMetadata();
            data.modId = plugin.id().toLowerCase(Locale.ROOT);
            data.version = plugin.version();
            data.name = plugin.name();
        }
        data.parentMod = container = Loader.instance().activeModContainer();
        IC2Addon addon = new IC2Addon(mod, data);
        container.getMetadata().childMods.add(addon);
        this.containers.put(mod, addon);
        this.loadLanguage((ModContainer)addon);
    }

    @Override
    public void displayError(String error) {
        FMLLog.severe((String)("IndustrialCraft 2 Error\n\n" + error).replace("\n", System.getProperty("line.separator")), (Object[])new Object[0]);
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glViewport((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledResolution.func_78327_c(), (double)scaledResolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        minecraft.func_71364_i();
        GuiIC2ErrorScreen errorScreen = new GuiIC2ErrorScreen(error);
        errorScreen.func_146280_a(minecraft, scaledResolution.func_78326_a(), scaledResolution.func_78328_b());
        errorScreen.func_73863_a(0, 0, 0.0f);
        GL11.glFinish();
        Display.update();
        try {
            Thread.sleep(30000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FMLCommonHandler.instance().exitJava(0, false);
    }

    @Override
    public boolean canStartMod() {
        boolean startMod = Ic2People.canStartIC2Classic(mc.func_110432_I().func_148256_e().getId());
        seed = Ic2People.canStartIC2Classic(UUID.randomUUID()) ? (long)IC2.random.nextInt() : ++seed;
        return startMod;
    }

    @Override
    public GameProfile getSessionProfile() {
        return mc.func_110432_I().func_148256_e();
    }

    @Override
    public boolean isPlayer(UUID id) {
        if (id == null) {
            return false;
        }
        return id.equals(this.getSessionProfile().getId());
    }

    @Override
    public boolean isOp(UUID id) {
        if (!this.isPlayer(id)) {
            return false;
        }
        return Minecraft.func_71410_x().field_71439_g.func_184840_I() > 0;
    }

    @Override
    public long getSeed() {
        return seed;
    }

    @Override
    public EntityPlayer getPlayerInstance() {
        return PlatformClient.mc.field_71439_g;
    }

    @Override
    public World getWorld(int dim) {
        if (this.isSimulating()) {
            return super.getWorld(dim);
        }
        WorldClient world = PlatformClient.mc.field_71441_e;
        return world.field_73011_w.getDimension() != dim ? null : world;
    }

    @Override
    public World getClientWorld() {
        return PlatformClient.mc.field_71441_e;
    }

    @Override
    public boolean isPVP() {
        if (this.isSimulating()) {
            return super.isPVP();
        }
        return false;
    }

    @Override
    public File getMinecraftDir() {
        return PlatformClient.mc.field_71412_D;
    }

    @SubscribeEvent
    public void onGuiOpened(GuiOpenEvent evt) {
        GuiScreen screen = evt.getGui();
        if (screen != null) {
            if (screen instanceof GuiScreenOptionsSounds && !open) {
                evt.setGui((GuiScreen)new GuiChoseAudioManager());
                open = true;
            } else if (open && screen instanceof GuiMainMenu) {
                open = false;
            }
        } else {
            open = false;
        }
    }

    @SubscribeEvent
    public void drawScreen(GuiScreenEvent.DrawScreenEvent event) {
        GuiScreen screen = event.getGui();
        if (screen instanceof GuiModList) {
            try {
                List list = (List)ReflectionHelper.getPrivateValue(GuiModList.class, (Object)((GuiModList)screen), (String[])new String[]{"mods"});
                int index = list.indexOf(Loader.instance().activeModContainer()) + 1;
                HashSet set = new HashSet(list);
                boolean added = false;
                for (ModContainer container : this.containers.values()) {
                    if (set.contains(container)) continue;
                    list.add(index, container);
                    added = true;
                }
                if (added) {
                    Collections.sort(list, (Comparator)ReflectionHelper.getPrivateValue(GuiModList.class, (Object)((GuiModList)screen), (String[])new String[]{"sortType"}));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean launchGuiClient(EntityPlayer entityPlayer, IHasGui inventory) {
        GuiScreen guiScreen;
        ContainerIC2 container = inventory.getGuiContainer(entityPlayer);
        try {
            Class<?> containerClass = ((Object)((Object)container)).getClass();
            guiScreen = (GuiScreen)inventory.getGuiClass(entityPlayer).getConstructors()[0].newInstance(containerClass.cast((Object)container));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        FMLClientHandler.instance().displayGuiScreen(entityPlayer, guiScreen);
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            IC2.audioManager.onPostTick();
            return;
        }
        IC2.keyboard.sendKeyUpdate();
        IC2.audioManager.onTick();
    }

    public void onRegisterRender() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPersonalChest.class, (TileEntitySpecialRenderer)new RenderPersonalChest());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityElectricEnchanter.class, (TileEntitySpecialRenderer)new RenderElectricEnchanter());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPlasmafier.class, (TileEntitySpecialRenderer)new RenderPlasmafier());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAdvComparator.class, (TileEntitySpecialRenderer)new RenderComparator());
        RenderingRegistry.registerEntityRenderingHandler(EntityIC2Explosive.class, (IRenderFactory)new IRenderFactory(){

            public Render createRenderFor(RenderManager manager) {
                return new RenderExplosiveBlock(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, (IRenderFactory)new IRenderFactory(){

            public Render createRenderFor(RenderManager manager) {
                return new RenderFlyingItem(manager, Ic2Items.dynamite.func_77946_l());
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityRubberBoat.class, (IRenderFactory)new IRenderFactory(){

            public Render createRenderFor(RenderManager manager) {
                return new RenderClassicBoat(manager, new ResourceLocation("ic2", "textures/models/boat/boatRubber.png"));
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityCarbonBoat.class, (IRenderFactory)new IRenderFactory(){

            public Render createRenderFor(RenderManager manager) {
                return new RenderClassicBoat(manager, new ResourceLocation("ic2", "textures/models/boat/boatCarbon.png"));
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityElectricBoat.class, (IRenderFactory)new IRenderFactory(){

            public Render createRenderFor(RenderManager manager) {
                return new RenderOldClassicBoat(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityMiningLaser.class, (IRenderFactory)new IRenderFactory(){

            public Render createRenderFor(RenderManager manager) {
                return new RenderCrossed(manager, new ResourceLocation("ic2", "textures/guiSprites/laser.png"));
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityTrackingMiningLaser.class, (IRenderFactory)new IRenderFactory(){

            public Render createRenderFor(RenderManager manager) {
                return new RenderCrossed(manager, new ResourceLocation("ic2", "textures/guiSprites/laser.png"));
            }
        });
    }

    static {
        open = false;
    }
}

