/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.util.EnumFacing;

public final class RotationList
implements Iterable<EnumFacing> {
    public static RotationList DOWN = new RotationList(EnumFacing.DOWN);
    public static RotationList UP = new RotationList(EnumFacing.UP);
    public static RotationList NORTH = new RotationList(EnumFacing.NORTH);
    public static RotationList SOUTH = new RotationList(EnumFacing.SOUTH);
    public static RotationList EAST = new RotationList(EnumFacing.EAST);
    public static RotationList WEST = new RotationList(EnumFacing.WEST);
    public static RotationList VERTICAL = new RotationList(DOWN, UP);
    public static RotationList HORIZONTAL = new RotationList(EnumFacing.field_176754_o);
    public static RotationList XAXIS = new RotationList(EAST, WEST);
    public static RotationList ZAXIS = new RotationList(NORTH, SOUTH);
    public static RotationList XYAXIS = new RotationList(XAXIS, VERTICAL);
    public static RotationList YZAXIS = new RotationList(ZAXIS, VERTICAL);
    public static RotationList PCORNER = new RotationList(SOUTH, EAST);
    public static RotationList NCORNER = new RotationList(NORTH, WEST);
    public static RotationList ALL = new RotationList(EnumFacing.field_82609_l);
    EnumFacing[] array;
    RotationList opposite;

    private RotationList() {
    }

    public RotationList(EnumFacing ... facings) {
        this.setArray(facings);
    }

    public RotationList(Collection<EnumFacing> facings) {
        EnumSet<EnumFacing> sets = EnumSet.noneOf(EnumFacing.class);
        sets.addAll(facings);
        this.setArray(sets.toArray(new EnumFacing[sets.size()]));
    }

    public RotationList(RotationList base, EnumFacing ... facings) {
        EnumSet<EnumFacing> sets = EnumSet.noneOf(EnumFacing.class);
        sets.addAll(Arrays.asList(base.getFacings()));
        sets.addAll(Arrays.asList(facings));
        this.setArray(sets.toArray(new EnumFacing[sets.size()]));
    }

    public RotationList(RotationList ... base) {
        EnumSet<EnumFacing> sets = EnumSet.noneOf(EnumFacing.class);
        for (RotationList list : base) {
            sets.addAll(Arrays.asList(list.getFacings()));
        }
        this.setArray(sets.toArray(new EnumFacing[sets.size()]));
    }

    private void setArray(EnumFacing ... list) {
        this.array = list;
        this.opposite = new RotationList();
        EnumSet<EnumFacing> set = EnumSet.allOf(EnumFacing.class);
        set.removeAll(Arrays.asList(list));
        this.opposite.array = set.toArray(new EnumFacing[set.size()]);
        this.opposite.opposite = this;
    }

    public EnumFacing[] getFacings() {
        return this.array;
    }

    public RotationList getOppositeList() {
        return this.opposite;
    }

    public Set<EnumFacing> toSet() {
        EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
        set.addAll(Arrays.asList(this.array));
        return set;
    }

    @Override
    public Iterator<EnumFacing> iterator() {
        return new Iterator<EnumFacing>(){
            int state = 0;

            @Override
            public boolean hasNext() {
                return this.state < RotationList.this.array.length;
            }

            @Override
            public EnumFacing next() {
                EnumFacing face = RotationList.this.array[this.state];
                ++this.state;
                return face;
            }

            @Override
            public void remove() {
            }
        };
    }

    public Iterable<EnumFacing> getRandomIterator() {
        return new Iterable<EnumFacing>(){

            @Override
            public Iterator<EnumFacing> iterator() {
                return new RandomIterator(RotationList.this);
            }
        };
    }

    public int writeToNumber() {
        EnumSet<EnumFacing> facing = EnumSet.noneOf(EnumFacing.class);
        facing.addAll(Arrays.asList(this.array));
        int connect = 0;
        int mask = 1;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (facing.contains(side)) {
                connect = (byte)(connect | mask);
            }
            mask *= 2;
        }
        return connect;
    }

    public static RotationList readFromNumber(int data) {
        RotationList list = new RotationList();
        EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
        for (int i = 0; i < 6; ++i) {
            if ((data & 1 << i) == 0) continue;
            set.add(EnumFacing.func_82600_a((int)i));
        }
        list.setArray(set.toArray(new EnumFacing[set.size()]));
        return list;
    }

    private static class RandomIterator
    implements Iterator<EnumFacing> {
        LinkedList<EnumFacing> sides;

        public RandomIterator(RotationList list) {
            this.sides = new LinkedList<EnumFacing>(Arrays.asList(list.getFacings()));
            Collections.shuffle(this.sides);
        }

        @Override
        public boolean hasNext() {
            return this.sides.size() > 0;
        }

        @Override
        public EnumFacing next() {
            return this.sides.remove();
        }

        @Override
        public void remove() {
        }
    }
}

