/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import com.google.common.base.Strings;
import ic2.api.classic.network.INetworkGuiDataProvider;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.IInfoTile;
import ic2.api.classic.util.IWorldTickCallback;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.IHasComparator;
import ic2.core.block.base.util.info.WrenchInfo;
import ic2.core.network.NetworkManager;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Capabilities;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.helpers.ChunkUpdater;
import ic2.core.util.helpers.FilteredList;
import ic2.core.util.obj.IWrenchableTile;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBlock
extends TileEntity
implements INetworkDataProvider,
IHasComparator,
IInfoTile,
INetworkGuiDataProvider,
INetworkUpdateListener,
IWorldNameable,
IWrenchableTile {
    public static Random random = new Random();
    @NetworkField(index=0)
    public boolean isActive;
    private boolean prevActive;
    @NetworkField(index=1, compression=NetworkField.BitLevel.Bit8)
    public int facing = 0;
    private int prevFacing = 0;
    private boolean loaded = false;
    @NetworkField(index=2, compression=NetworkField.BitLevel.Bit16)
    public String customName;
    public boolean redstone;
    public boolean needsRedstoneUpdate = this.needsInitialRedstoneUpdate();
    private final boolean isServer;
    private final NetworkManager network;
    private List<String> networkFields = new FilteredList<String>();
    private List<String> guiFields = new FilteredList<String>();
    private List<IInfoTile.InfoComponent> infos = new FilteredList<IInfoTile.InfoComponent>();
    public ComparatorManager comparatorManager = new ComparatorManager(this);

    public TileEntityBlock() {
        this.isServer = IC2.platform.isSimulating();
        this.network = IC2.network.get(this.isServer);
        this.addNetworkFields("facing", "isActive");
        this.addGuiFields("customName");
        this.addComparators(this.comparatorManager);
        this.addInfos(new WrenchInfo(this));
    }

    protected void addInfos(IInfoTile.InfoComponent ... infoArray) {
        this.infos.addAll(Arrays.asList(infoArray));
    }

    protected void addComparators(ComparatorManager manager) {
    }

    protected void addNetworkFields(String ... fields) {
        this.networkFields.addAll(Arrays.asList(fields));
    }

    protected void addGuiFields(String ... fields) {
        this.guiFields.addAll(Arrays.asList(fields));
    }

    @Override
    public ComparatorManager getManager() {
        return this.comparatorManager;
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (active != this.prevActive) {
            this.getNetwork().updateTileEntityField(this, "isActive");
        }
        this.prevActive = active;
    }

    public void setActiveWithoutNotify(boolean active) {
        this.isActive = active;
        this.prevActive = active;
    }

    public boolean getActive() {
        return this.isActive;
    }

    public boolean isActiveChanged() {
        return this.isActive != this.prevActive;
    }

    public void setCustomName(String name) {
        this.customName = name;
        this.getNetwork().updateTileGuiField(this, "customName");
    }

    @Override
    public void setFacing(EnumFacing face) {
        if (face == null) {
            return;
        }
        this.facing = face.func_176745_a();
        if (this.facing != this.prevFacing) {
            this.getNetwork().updateTileEntityField(this, "facing");
        }
        this.prevFacing = this.facing;
    }

    public void setFacingWithoutNotify(EnumFacing face) {
        if (face == null) {
            return;
        }
        this.facing = face.func_176745_a();
        this.prevFacing = face.func_176745_a();
    }

    @Override
    public EnumFacing getFacing() {
        return EnumFacing.func_82600_a((int)this.facing);
    }

    @Override
    public List<String> getNetworkedFields() {
        return this.networkFields;
    }

    @Override
    public List<String> getGuiFields() {
        return this.guiFields;
    }

    @Override
    public List<IInfoTile.InfoComponent> getComponents() {
        return this.infos;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("isActive") || field.equals("facing")) {
            this.prevActive = this.isActive;
            this.prevFacing = this.facing;
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiFieldSynced(String field) {
    }

    public boolean needsPostLoadTick() {
        return false;
    }

    public void onLoaded() {
        if (this.isRendering()) {
            this.getNetwork().requestInitialData(this);
        } else {
            ChunkUpdater.addWatcher(this.func_145831_w(), this.func_174877_v());
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
        if (this.isSimulating()) {
            ChunkUpdater.removeWatcher(this.func_145831_w(), this.func_174877_v());
        }
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoad() {
        if (!this.canUpdate()) {
            this.field_145850_b.field_175730_i.remove(this);
        }
        if (!this.loaded) {
            if (this.isSimulating()) {
                IC2.callbacks.addCallback(this.field_145850_b, new IWorldTickCallback(){

                    @Override
                    public ActionResult<Integer> tickCallback(World world) {
                        TileEntityBlock.this.onLoaded();
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)0);
                    }
                });
            } else {
                this.onLoaded();
            }
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void updateComparators() {
        this.comparatorManager.update();
    }

    public boolean canRenderBreaking() {
        return false;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return false;
    }

    public boolean canRemoveBlockProbe(EntityPlayer player) {
        return this.canRemoveBlock(player);
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return false;
    }

    @Override
    public double getWrenchDropRate() {
        return 1.0;
    }

    @Override
    public boolean hasSpecialAction(EntityPlayer player, EnumFacing facing, Vec3d hit) {
        return false;
    }

    @Override
    public EnumActionResult doSpecialAction(EntityPlayer player, EnumFacing facing, Vec3d hit) {
        return EnumActionResult.PASS;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.comparatorManager.readFromNBT(nbt.func_74775_l("ComparatorManager"));
        this.setFacingWithoutNotify(EnumFacing.func_82600_a((int)nbt.func_74771_c("Facing")));
        this.customName = nbt.func_74779_i("CustomName");
        if (StringUtils.func_151246_b((String)this.customName)) {
            this.customName = null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.comparatorManager.writeToNBT(this.getTag(nbt, "ComparatorManager"));
        nbt.func_74774_a("Facing", (byte)this.facing);
        nbt.func_74778_a("CustomName", this.func_145818_k_() ? this.customName : "");
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", this.field_174879_c.func_177958_n());
        nbt.func_74768_a("y", this.field_174879_c.func_177956_o());
        nbt.func_74768_a("z", this.field_174879_c.func_177952_p());
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
    }

    public String func_70005_c_() {
        return this.customName;
    }

    public LocaleComp getBlockName() {
        return Ic2Lang.nullKey;
    }

    public boolean func_145818_k_() {
        return !Strings.isNullOrEmpty((String)this.customName);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.customName);
    }

    public void onBlockBreak() {
    }

    public boolean isRedstonePowered() {
        return this.redstone;
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public void handleRedstone() {
        if (this.needsRedstoneUpdate) {
            this.redstone = this.field_145850_b.func_175640_z(this.func_174877_v());
            this.needsRedstoneUpdate = false;
        }
    }

    public void onBlockUpdate(Block block) {
        this.needsRedstoneUpdate = true;
    }

    public boolean needsInitialRedstoneUpdate() {
        return false;
    }

    public NetworkManager getNetwork() {
        return this.network;
    }

    public boolean isSimulating() {
        return this.isServer;
    }

    public boolean isRendering() {
        return !this.isServer;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == Ic2Capabilities.SinkLimiterCapability) {
            return super.hasCapability(capability, facing);
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == Ic2Capabilities.SinkLimiterCapability) {
            return (T)super.getCapability(capability, facing);
        }
        return null;
    }
}

