/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.RotationList;
import ic2.core.block.crop.crops.CropCardBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropGlowShroom
extends CropCardBase {
    public CropGlowShroom() {
        super(new CropProperties(5, 2, 4, 0, 3, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 1) {
            return this.getSprite("bc")[37];
        }
        return this.getSprite("bc")[87 + state];
    }

    @Override
    public String getDiscoveredBy() {
        return "Speiger";
    }

    @Override
    public String getId() {
        return "GlowShroom";
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Yellow", "Nether", "Light", "Soulsand"};
    }

    @Override
    public double dropGainChance() {
        return 0.8;
    }

    @Override
    public int getMaxSize() {
        return 3;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Items.field_151114_aO);
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 1 || cropTile.getCurrentSize() < 3 && this.hasGlowStone(cropTile);
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 3;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 3;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 2;
    }

    public boolean hasGlowStone(ICropTile crop) {
        World world = crop.getWorldObj();
        for (EnumFacing facing : RotationList.DOWN.getOppositeList()) {
            BlockPos pos = crop.getPosition().func_177972_a(facing);
            if (!world.func_175667_e(pos) || world.func_180495_p(pos).func_177230_c() != Blocks.field_150426_aN) continue;
            return true;
        }
        return false;
    }
}

