/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.misc;

import ic2.api.classic.crops.ClassicBaseSeed;
import ic2.api.classic.recipe.ICustomRecipeInput;
import ic2.api.crops.BaseSeed;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropSeed;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RecipeInputCrop
implements ICustomRecipeInput {
    ClassicBaseSeed seed;
    boolean more;

    public RecipeInputCrop(CropCard card) {
        this(card, 1);
    }

    public RecipeInputCrop(CropCard card, boolean up) {
        this(card, 1, up);
    }

    public RecipeInputCrop(CropCard card, int amount) {
        this(card, amount, true);
    }

    public RecipeInputCrop(CropCard card, int amount, boolean up) {
        this(new ClassicBaseSeed(card, 0, 0, 0, 0, amount), up);
    }

    public RecipeInputCrop(BaseSeed seed) {
        this(new ClassicBaseSeed(seed));
    }

    public RecipeInputCrop(BaseSeed seed, boolean up) {
        this(new ClassicBaseSeed(seed), up);
    }

    public RecipeInputCrop(ClassicBaseSeed seed) {
        this(seed, true);
    }

    public RecipeInputCrop(ClassicBaseSeed seed, boolean up) {
        this.seed = seed;
        this.more = up;
    }

    @Override
    public boolean matches(ItemStack subject) {
        if (subject == null || !(subject.func_77973_b() instanceof ICropSeed)) {
            return false;
        }
        ICropSeed crop = (ICropSeed)subject.func_77973_b();
        int gain = crop.getGainFromStack(subject);
        int growth = crop.getGrowthFromStack(subject);
        int resi = crop.getResistanceFromStack(subject);
        return this.more ? this.seed.statGain <= gain && this.seed.statGrowth <= growth && this.seed.statResistance <= resi && this.seed.stackSize <= subject.func_190916_E() : this.seed.statGain >= gain && this.seed.statGrowth >= growth && this.seed.statResistance >= resi && this.seed.stackSize >= subject.func_190916_E();
    }

    @Override
    public int getAmount() {
        return this.seed.stackSize;
    }

    @Override
    public List<ItemStack> getInputs() {
        ItemStack crop = StackUtil.copyWithSize(Ic2Items.cropSeed, this.getAmount());
        ICropSeed item = (ICropSeed)crop.func_77973_b();
        item.setCropFromStack(crop, this.seed.crop);
        item.setGainFromStack(crop, this.seed.statGain);
        item.setGrowthFromStack(crop, this.seed.statGrowth);
        item.setResistanceFromStack(crop, this.seed.statResistance);
        item.setScannedFromStack(crop, 4);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(crop);
        if (this.more) {
            crop = StackUtil.copyWithSize(Ic2Items.cropSeed, this.getAmount());
            item = (ICropSeed)crop.func_77973_b();
            item.setCropFromStack(crop, this.seed.crop);
            item.setGainFromStack(crop, 32);
            item.setGrowthFromStack(crop, 32);
            item.setResistanceFromStack(crop, 32);
            item.setScannedFromStack(crop, 4);
            list.add(crop);
        } else {
            crop = StackUtil.copyWithSize(Ic2Items.cropSeed, this.getAmount());
            item = (ICropSeed)crop.func_77973_b();
            item.setCropFromStack(crop, this.seed.crop);
            item.setGainFromStack(crop, 0);
            item.setGrowthFromStack(crop, 0);
            item.setResistanceFromStack(crop, 0);
            item.setScannedFromStack(crop, 4);
            list.add(crop);
        }
        return list;
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    @Override
    public boolean isOreDict() {
        return false;
    }

    @Override
    public String getOreDictEntry() {
        return null;
    }
}

