/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.info.Info;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityFuelGeneratorBase;
import ic2.core.block.generator.container.ContainerSlagGenerator;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.math.Box2D;
import ic2.core.util.misc.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class TileEntitySlagGenerator
extends TileEntityFuelGeneratorBase {
    public int nextScrap;
    public int scrap;
    @NetworkField(index=7)
    public int maxFuel;
    public boolean scrapFuel;
    public float subProduction;
    public float config = IC2.config.getFloat("ScrapGenerator");

    public TileEntitySlagGenerator() {
        super(3);
        this.production = (int)this.config + 1;
        this.maxStorage = 8000;
        this.addGuiFields("maxFuel");
        this.nextScrap = this.getNextScrapCounter();
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 0);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.getOppositeList(), 1);
        handler.registerDefaultSlotsForSide(RotationList.UP.getOppositeList(), 2);
        handler.registerInputFilter(CommonFilters.IronFurnaceFuelWithLava, 1);
        handler.registerOutputFilter(CommonFilters.NotIronFurnaceFuelWithLava, 1);
        handler.registerInputFilter(CommonFilters.ChargeEU, 0);
        handler.registerSlotType(SlotType.Charge, 0);
        handler.registerSlotType(SlotType.Fuel, 1);
        handler.registerSlotType(SlotType.Output, 2);
    }

    public int getNextScrapCounter() {
        return (int)(160.0 * (0.5 + Math.random()));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Scrap", this.scrapFuel);
        nbt.func_74768_a("NextScrap", this.nextScrap);
        nbt.func_74768_a("ScrapCounter", this.scrap);
        nbt.func_74768_a("MaxFuel", this.maxFuel);
        nbt.func_74776_a("SubProduction", this.subProduction);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.scrapFuel = nbt.func_74767_n("Scrap");
        this.nextScrap = nbt.func_74762_e("NextScrap");
        this.scrap = nbt.func_74762_e("ScrapCounter");
        this.maxFuel = nbt.func_74762_e("MaxFuel");
        this.subProduction = nbt.func_74760_g("SubProduction");
    }

    @Override
    public float getMaxFuel() {
        return this.maxFuel;
    }

    @Override
    public int getMaxSendingEnergy() {
        return (int)(this.config + 1.0f);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerSlagGenerator(player.field_71071_by, this);
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.slagGenerator;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.slagGenerator;
    }

    @Override
    public Box2D getFuelBox() {
        return Ic2GuiComp.generatorFuelBox;
    }

    @Override
    public Box2D getEnergyBox() {
        return Ic2GuiComp.generatorEnergyBox;
    }

    @Override
    public boolean isConverting() {
        return this.fuel > 0;
    }

    @Override
    public boolean gainEnergy() {
        if (this.isConverting()) {
            this.subProduction += this.config;
            --this.fuel;
            this.getNetwork().updateTileGuiField(this, "fuel");
            int toAdd = (int)this.subProduction;
            if (this.subProduction > 0.0f) {
                this.subProduction -= (float)toAdd;
                this.storage += toAdd;
            }
            if (!this.scrapFuel) {
                ++this.scrap;
                if (this.scrap >= this.nextScrap) {
                    this.scrap = 0;
                    this.nextScrap = this.getNextScrapCounter();
                    if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
                        this.inventory.set(2, (Object)Ic2Items.scrap.func_77946_l());
                    } else if (StackUtil.isStackEqual((ItemStack)this.inventory.get(2), Ic2Items.scrap) && ((ItemStack)this.inventory.get(2)).func_190916_E() < ((ItemStack)this.inventory.get(2)).func_77976_d()) {
                        ((ItemStack)this.inventory.get(2)).func_190917_f(1);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean gainFuel() {
        if (!((ItemStack)this.inventory.get(1)).func_190926_b()) {
            int value = Info.itemInfo.getFuelValue((ItemStack)this.inventory.get(1), true) / 4;
            if (value <= 0) {
                return false;
            }
            this.scrapFuel = false;
            if (StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.scrap) || StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.scrapBox)) {
                value /= 10;
                this.scrapFuel = true;
            }
            this.fuel += value;
            this.maxFuel = this.fuel;
            this.getNetwork().updateTileGuiField(this, "maxFuel");
            if (((ItemStack)this.inventory.get(1)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(1))) {
                this.inventory.set(1, (Object)((ItemStack)this.inventory.get(1)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(1)));
            } else {
                ((ItemStack)this.inventory.get(1)).func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    @Override
    public ResourceLocation getOperationSoundFile() {
        return Ic2Sounds.generatorLoop;
    }
}

