/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.info.EmitterInfo;
import ic2.core.block.base.util.info.SourceTierInfo;
import ic2.core.block.base.util.info.misc.IEmitterTile;
import ic2.core.block.generator.container.ContainerSolarPanel;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Resources;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntitySolarPanel
extends TileEntityMachine
implements IHasGui,
ITickable,
IEnergySource,
IEmitterTile {
    int ticker = 127;
    double config = (double)IC2.config.getInt("energyGeneratorSolar") / 100.0;
    protected double production = 1.0;
    public int tier = 1;
    boolean enet = false;
    int storage;

    public TileEntitySolarPanel() {
        super(1);
        this.addInfos(new SourceTierInfo(this), new EmitterInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.None, RotationList.UP);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.UP.getOppositeList());
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 0);
        handler.registerInputFilter(CommonFilters.ChargeEU, 0);
        handler.registerSlotType(SlotType.Charge, 0);
    }

    @Override
    public int getOutput() {
        return (int)(this.production * this.config);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return this.storage;
    }

    @Override
    public void drawEnergy(double amount) {
        this.storage = (int)((double)this.storage - amount);
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerSolarPanel(player.field_71071_by, this);
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.solarPanel;
    }

    public ResourceLocation getTexture() {
        return Ic2Resources.solarPanel;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    public void func_73660_a() {
        if (this.ticker++ % 128 == 0) {
            this.setActive(TileEntitySolarPanel.isSunVisible(this.field_145850_b, this.func_174877_v().func_177984_a()));
        }
        if (this.getActive()) {
            this.storage = (int)(this.production * this.config);
        }
        if (this.storage > 0 && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
            this.storage = (int)((double)this.storage - ElectricItem.manager.charge((ItemStack)this.inventory.get(0), this.storage, this.tier, false, false));
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.enet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.enet = false;
        }
        super.onUnloaded();
    }

    public static boolean isSunVisible(World world, BlockPos pos) {
        if (!world.field_73011_w.func_191066_m() || !world.func_72935_r()) {
            return false;
        }
        if (!world.func_175710_j(pos)) {
            return false;
        }
        Biome biome = world.func_180494_b(pos);
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && !biome.func_76738_d()) {
            return true;
        }
        return !world.func_72896_J() && !world.func_72911_I();
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.9;
    }

    public static class TileEntityHVSolarPanel
    extends TileEntitySolarPanel {
        public TileEntityHVSolarPanel() {
            this.tier = 3;
            this.production = 512.0;
            this.config = (double)IC2.config.getInt("energyGeneratorSolarHV") / 100.0;
        }

        @Override
        public LocaleComp getBlockName() {
            return Ic2BlockLang.solarHV;
        }

        @Override
        public double getWrenchDropRate() {
            return 1.0;
        }
    }

    public static class TileEntityMVSolarPanel
    extends TileEntitySolarPanel {
        public TileEntityMVSolarPanel() {
            this.tier = 2;
            this.production = 64.0;
            this.config = (double)IC2.config.getInt("energyGeneratorSolarMV") / 100.0;
        }

        @Override
        public LocaleComp getBlockName() {
            return Ic2BlockLang.solarMV;
        }

        @Override
        public double getWrenchDropRate() {
            return 1.0;
        }
    }

    public static class TileEntityLVSolarPanel
    extends TileEntitySolarPanel {
        public TileEntityLVSolarPanel() {
            this.tier = 1;
            this.production = 8.0;
            this.config = (double)IC2.config.getInt("energyGeneratorSolarLV") / 100.0;
        }

        @Override
        public LocaleComp getBlockName() {
            return Ic2BlockLang.solarLV;
        }

        @Override
        public double getWrenchDropRate() {
            return 1.0;
        }
    }
}

